/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import com.sun.jsftemplating.util.TypeConversion;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.FacesContext;

public class TypeConverter {
    private static final String CONVERSIONS = "__jsft_TypeConversions";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String TYPE_UNKNOWN = "null";
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_CHARACTER = "character";
    public static final String TYPE_BIG_DECIMAL = "bigdecimal";
    public static final String TYPE_SQL_DATE = "sqldate";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_SQL_TIME = "sqltime";
    public static final String TYPE_LOCALE = "locale";
    public static final String TYPE_SQL_TIMESTAMP = "sqltimestamp";
    public static final TypeConversion UNKNOWN_TYPE_CONVERSION = new UnknownTypeConversion();
    public static final TypeConversion OBJECT_TYPE_CONVERSION = new ObjectTypeConversion();
    public static final TypeConversion STRING_TYPE_CONVERSION = new StringTypeConversion();
    public static final TypeConversion INTEGER_TYPE_CONVERSION = new IntegerTypeConversion();
    public static final TypeConversion DOUBLE_TYPE_CONVERSION = new DoubleTypeConversion();
    public static final TypeConversion BOOLEAN_TYPE_CONVERSION = new BooleanTypeConversion();
    public static final TypeConversion LONG_TYPE_CONVERSION = new LongTypeConversion();
    public static final TypeConversion FLOAT_TYPE_CONVERSION = new FloatTypeConversion();
    public static final TypeConversion SHORT_TYPE_CONVERSION = new ShortTypeConversion();
    public static final TypeConversion BIG_DECIMAL_TYPE_CONVERSION = new BigDecimalTypeConversion();
    public static final TypeConversion BYTE_TYPE_CONVERSION = new ByteTypeConversion();
    public static final TypeConversion CHARACTER_TYPE_CONVERSION = new CharacterTypeConversion();
    public static final TypeConversion DATE_TYPE_CONVERSION = new DateTypeConversion();
    public static final TypeConversion SQL_DATE_TYPE_CONVERSION = new SqlDateTypeConversion();
    public static final TypeConversion SQL_TIME_TYPE_CONVERSION = new SqlTimeTypeConversion();
    public static final TypeConversion SQL_TIMESTAMP_TYPE_CONVERSION = new SqlTimestampTypeConversion();
    public static final TypeConversion LOCALE_TYPE_CONVERSION = new LocaleTypeConversion();

    private TypeConverter() {
    }

    public static Map<Object, TypeConversion> getTypeConversions(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        ConcurrentHashMap<Object, TypeConversion> conversions = null;
        if (ctx != null) {
            conversions = (ConcurrentHashMap<Object, TypeConversion>)ctx.getExternalContext().getApplicationMap().get(CONVERSIONS);
        }
        if (conversions == null) {
            conversions = new ConcurrentHashMap<Object, TypeConversion>(80, 0.75f, 1);
            conversions.put(Object.class, OBJECT_TYPE_CONVERSION);
            conversions.put(String.class, STRING_TYPE_CONVERSION);
            conversions.put(Integer.class, INTEGER_TYPE_CONVERSION);
            conversions.put(Integer.TYPE, INTEGER_TYPE_CONVERSION);
            conversions.put(Double.class, DOUBLE_TYPE_CONVERSION);
            conversions.put(Double.TYPE, DOUBLE_TYPE_CONVERSION);
            conversions.put(Boolean.class, BOOLEAN_TYPE_CONVERSION);
            conversions.put(Boolean.TYPE, BOOLEAN_TYPE_CONVERSION);
            conversions.put(Long.class, LONG_TYPE_CONVERSION);
            conversions.put(Long.TYPE, LONG_TYPE_CONVERSION);
            conversions.put(Float.class, FLOAT_TYPE_CONVERSION);
            conversions.put(Float.TYPE, FLOAT_TYPE_CONVERSION);
            conversions.put(Short.class, SHORT_TYPE_CONVERSION);
            conversions.put(Short.TYPE, SHORT_TYPE_CONVERSION);
            conversions.put(BigDecimal.class, BIG_DECIMAL_TYPE_CONVERSION);
            conversions.put(Byte.class, BYTE_TYPE_CONVERSION);
            conversions.put(Byte.TYPE, BYTE_TYPE_CONVERSION);
            conversions.put(Character.class, CHARACTER_TYPE_CONVERSION);
            conversions.put(Character.TYPE, CHARACTER_TYPE_CONVERSION);
            conversions.put(java.util.Date.class, DATE_TYPE_CONVERSION);
            conversions.put(Date.class, SQL_DATE_TYPE_CONVERSION);
            conversions.put(Time.class, SQL_TIME_TYPE_CONVERSION);
            conversions.put(Timestamp.class, SQL_TIMESTAMP_TYPE_CONVERSION);
            conversions.put(Locale.class, LOCALE_TYPE_CONVERSION);
            conversions.put(Object.class.getName(), OBJECT_TYPE_CONVERSION);
            conversions.put(String.class.getName(), STRING_TYPE_CONVERSION);
            conversions.put(Integer.class.getName(), INTEGER_TYPE_CONVERSION);
            conversions.put(Double.class.getName(), DOUBLE_TYPE_CONVERSION);
            conversions.put(Boolean.class.getName(), BOOLEAN_TYPE_CONVERSION);
            conversions.put(Long.class.getName(), LONG_TYPE_CONVERSION);
            conversions.put(Float.class.getName(), FLOAT_TYPE_CONVERSION);
            conversions.put(Short.class.getName(), SHORT_TYPE_CONVERSION);
            conversions.put(BigDecimal.class.getName(), BIG_DECIMAL_TYPE_CONVERSION);
            conversions.put(Byte.class.getName(), BYTE_TYPE_CONVERSION);
            conversions.put(Character.class.getName(), CHARACTER_TYPE_CONVERSION);
            conversions.put(java.util.Date.class.getName(), DATE_TYPE_CONVERSION);
            conversions.put(Date.class.getName(), SQL_DATE_TYPE_CONVERSION);
            conversions.put(Time.class.getName(), SQL_TIME_TYPE_CONVERSION);
            conversions.put(Timestamp.class.getName(), SQL_TIMESTAMP_TYPE_CONVERSION);
            conversions.put(Locale.class.getName(), LOCALE_TYPE_CONVERSION);
            conversions.put(TYPE_UNKNOWN, UNKNOWN_TYPE_CONVERSION);
            conversions.put(TYPE_OBJECT, OBJECT_TYPE_CONVERSION);
            conversions.put(TYPE_STRING, STRING_TYPE_CONVERSION);
            conversions.put(TYPE_INT, INTEGER_TYPE_CONVERSION);
            conversions.put(TYPE_INTEGER, INTEGER_TYPE_CONVERSION);
            conversions.put(TYPE_DOUBLE, DOUBLE_TYPE_CONVERSION);
            conversions.put(TYPE_BOOLEAN, BOOLEAN_TYPE_CONVERSION);
            conversions.put(TYPE_LONG, LONG_TYPE_CONVERSION);
            conversions.put(TYPE_FLOAT, FLOAT_TYPE_CONVERSION);
            conversions.put(TYPE_SHORT, SHORT_TYPE_CONVERSION);
            conversions.put(TYPE_BIG_DECIMAL, BIG_DECIMAL_TYPE_CONVERSION);
            conversions.put(TYPE_BYTE, BYTE_TYPE_CONVERSION);
            conversions.put(TYPE_CHAR, CHARACTER_TYPE_CONVERSION);
            conversions.put(TYPE_CHARACTER, CHARACTER_TYPE_CONVERSION);
            conversions.put(TYPE_DATE, DATE_TYPE_CONVERSION);
            conversions.put(TYPE_SQL_DATE, SQL_DATE_TYPE_CONVERSION);
            conversions.put(TYPE_SQL_TIME, SQL_TIME_TYPE_CONVERSION);
            conversions.put(TYPE_SQL_TIMESTAMP, SQL_TIMESTAMP_TYPE_CONVERSION);
            conversions.put(TYPE_LOCALE, LOCALE_TYPE_CONVERSION);
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(CONVERSIONS, conversions);
            }
        }
        return conversions;
    }

    public static void registerTypeConversion(FacesContext ctx, Object key, TypeConversion conversion) {
        TypeConverter.getTypeConversions(ctx).put(key, conversion);
    }

    public static Object asType(Object typeKey, Object value) {
        if (value == null) {
            return null;
        }
        if (typeKey == null) {
            return value;
        }
        if (typeKey instanceof Class && (Class)typeKey != Object.class && ((Class)typeKey).isInstance(value)) {
            return value;
        }
        TypeConversion conversion = TypeConverter.getTypeConversions(null).get(typeKey);
        if (conversion != null) {
            return conversion.convertValue(value);
        }
        throw new IllegalArgumentException("Could not find type conversion for type \"" + typeKey + "\" (value = \"" + value + "\")");
    }

    public static byte asByte(Object value) {
        return TypeConverter.asByte(value, (byte)0);
    }

    public static byte asByte(Object value, byte defaultValue) {
        if ((value = TypeConverter.asType(Byte.class, value)) != null) {
            return (Byte)value;
        }
        return defaultValue;
    }

    public static short asShort(Object value) {
        return TypeConverter.asShort(value, (short)0);
    }

    public static short asShort(Object value, short defaultValue) {
        if ((value = TypeConverter.asType(Short.class, value)) != null) {
            return (Short)value;
        }
        return defaultValue;
    }

    public static int asInt(Object value) {
        return TypeConverter.asInt(value, 0);
    }

    public static int asInt(Object value, int defaultValue) {
        if ((value = TypeConverter.asType(Integer.class, value)) != null) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public static long asLong(Object value) {
        return TypeConverter.asLong(value, 0L);
    }

    public static long asLong(Object value, long defaultValue) {
        if ((value = TypeConverter.asType(Long.class, value)) != null) {
            return (Long)value;
        }
        return defaultValue;
    }

    public static float asFloat(Object value) {
        return TypeConverter.asFloat(value, 0.0f);
    }

    public static float asFloat(Object value, float defaultValue) {
        if ((value = TypeConverter.asType(Float.class, value)) != null) {
            return ((Float)value).floatValue();
        }
        return defaultValue;
    }

    public static double asDouble(Object value) {
        return TypeConverter.asDouble(value, 0.0);
    }

    public static double asDouble(Object value, double defaultValue) {
        if ((value = TypeConverter.asType(Double.class, value)) != null) {
            return (Double)value;
        }
        return defaultValue;
    }

    public static char asChar(Object value) {
        return TypeConverter.asChar(value, '\u0000');
    }

    public static char asChar(Object value, char defaultValue) {
        if ((value = TypeConverter.asType(Character.class, value)) != null) {
            return ((Character)value).charValue();
        }
        return defaultValue;
    }

    public static boolean asBoolean(Object value) {
        return TypeConverter.asBoolean(value, false);
    }

    public static boolean asBoolean(Object value, boolean defaultValue) {
        if ((value = TypeConverter.asType(Boolean.class, value)) != null) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static String asString(Object value) {
        return (String)TypeConverter.asType(String.class, value);
    }

    public static String asString(Object value, String defaultValue) {
        if ((value = TypeConverter.asType(String.class, value)) != null) {
            return (String)value;
        }
        return defaultValue;
    }

    public static class LocaleTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Locale)) {
                String language = value.toString();
                String country = null;
                String locale = value.toString();
                int index = locale.indexOf("_");
                if (index > -1) {
                    language = locale.substring(0, index);
                    country = locale.substring(index + 1);
                    value = new Locale(language, country);
                } else {
                    value = new Locale(language);
                }
            }
            return value;
        }
    }

    public static class ObjectTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            return value;
        }
    }

    public static class SqlTimestampTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Timestamp)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Timestamp.valueOf(v);
            }
            return value;
        }
    }

    public static class SqlTimeTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Time)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Time.valueOf(v);
            }
            return value;
        }
    }

    public static class DateTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof java.util.Date)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new java.util.Date(v);
            }
            return value;
        }
    }

    public static class SqlDateTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Date)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Date.valueOf(v);
            }
            return value;
        }
    }

    public static class CharacterTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Character)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Character(v.charAt(0));
            }
            return value;
        }
    }

    public static class ByteTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Byte)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Byte(v);
            }
            return value;
        }
    }

    public static class BigDecimalTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof BigDecimal)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new BigDecimal(v);
            }
            return value;
        }
    }

    public static class ShortTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Short)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Short(v);
            }
            return value;
        }
    }

    public static class FloatTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Float)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Float(v);
            }
            return value;
        }
    }

    public static class LongTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Long)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Long(v);
            }
            return value;
        }
    }

    public static class BooleanTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Boolean)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Boolean.valueOf(v);
            }
            return value;
        }
    }

    public static class DoubleTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Double)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Double(v);
            }
            return value;
        }
    }

    public static class IntegerTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Integer)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Integer(v);
            }
            return value;
        }
    }

    public static class StringTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType() == Byte.TYPE) {
                    value = new String((byte[])value, UTF8);
                } else if (value.getClass().getComponentType() == Character.TYPE) {
                    value = new String((char[])value);
                }
            } else if (!(value instanceof String)) {
                value = value.toString();
            }
            return value;
        }
    }

    public static class UnknownTypeConversion
    implements TypeConversion {
        @Override
        public Object convertValue(Object value) {
            return value;
        }
    }
}

