/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Vector;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.hk2.api.ServiceLocator;

public class LogFilterForInstance {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadGivenInstanceLogFile(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String domainRoot, String logFileName, String instanceLogFileName) throws IOException {
        File instanceLogFile = null;
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (node.getType().equals("SSH")) {
            try {
                SftpATTRS sftpFileAttributes;
                long fileSizeOnNode;
                String loggingFile;
                sshL.init(node, logger);
                SFTPClient sftpClient = sshL.getSFTPClient();
                File logFileDirectoryOnServer = this.makingDirectory(domainRoot + File.separator + "logs" + File.separator + instanceName);
                boolean noFileFound = true;
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileName, node, sNode, instanceName);
                try {
                    Vector instanceLogFileNames = sftpClient.getSftpChannel().ls(loggingDir);
                    for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                        ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)instanceLogFileNames.get(i);
                        String fileName = file.getFilename();
                        if (file.getAttrs().isDir() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        noFileFound = false;
                        break;
                    }
                }
                catch (Exception e) {
                    noFileFound = true;
                }
                if (noFileFound) {
                    loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileName, node, sNode, instanceName);
                }
                if (!sftpClient.exists(loggingFile = loggingDir + File.separator + logFileName)) {
                    loggingFile = loggingDir + File.separator + "server.log";
                } else if (!sftpClient.exists(loggingFile)) {
                    loggingFile = instanceLogFileName;
                }
                long instanceLogFileSize = 0L;
                instanceLogFile = new File(logFileDirectoryOnServer.getAbsolutePath() + File.separator + loggingFile.substring(loggingFile.lastIndexOf(File.separator), loggingFile.length()));
                if (instanceLogFile.exists()) {
                    instanceLogFileSize = instanceLogFile.length();
                }
                if (instanceLogFileSize != (fileSizeOnNode = (sftpFileAttributes = sftpClient._stat(loggingFile)).getSize())) {
                    BufferedInputStream in = null;
                    FileOutputStream file = null;
                    FilterOutputStream out = null;
                    try {
                        int i;
                        InputStream inputStream = sftpClient.getSftpChannel().get(loggingFile);
                        in = new BufferedInputStream(inputStream);
                        file = new FileOutputStream(instanceLogFile);
                        out = new BufferedOutputStream(file);
                        while ((i = in.read()) != -1) {
                            ((BufferedOutputStream)out).write(i);
                        }
                        ((BufferedOutputStream)out).flush();
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                sftpClient.close();
            }
            catch (JSchException ex) {
                throw new IOException("Unable to download instance log file from SSH Node", ex);
            }
            catch (SftpException ex) {
                throw new IOException("Unable to download instance log file from SSH Node", ex);
            }
        }
        return instanceLogFile;
    }

    public void downloadAllInstanceLogFiles(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String tempDirectoryOnServer, String instanceLogFileDirectory) throws IOException {
        SSHLauncher sshL = this.getSSHL(habitat);
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (node.getType().equals("SSH")) {
            try {
                sshL.init(node, logger);
                Vector allInstanceLogFileName = this.getInstanceLogFileNames(habitat, targetServer, domain, logger, instanceName, instanceLogFileDirectory);
                boolean noFileFound = true;
                String sourceDir = this.getLoggingDirectoryForNode(instanceLogFileDirectory, node, sNode, instanceName);
                SFTPClient sftpClient = sshL.getSFTPClient();
                try {
                    Vector instanceLogFileNames = sftpClient.getSftpChannel().ls(sourceDir);
                    for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                        ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)instanceLogFileNames.get(i);
                        String fileName = file.getFilename();
                        if (file.getAttrs().isDir() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        noFileFound = false;
                        break;
                    }
                }
                catch (Exception e) {
                    noFileFound = true;
                }
                if (noFileFound) {
                    sourceDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDirectory, node, sNode, instanceName);
                }
                for (int i = 0; i < allInstanceLogFileName.size(); ++i) {
                    String remoteFileName = sourceDir + File.separator + allInstanceLogFileName.get(i);
                    InputStream inputStream = sftpClient.getSftpChannel().get(remoteFileName);
                    Files.copy(inputStream, Paths.get(tempDirectoryOnServer, new String[0]), new CopyOption[0]);
                }
                sftpClient.close();
            }
            catch (JSchException ex) {
                throw new IOException("Unable to download instance log file from SSH Node", ex);
            }
            catch (SftpException ex) {
                throw new IOException("Unable to download instance log file from SSH Node", ex);
            }
        }
    }

    public Vector getInstanceLogFileNames(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String instanceLogFileDetails) throws IOException {
        Vector<String> instanceLogFileNamesAsString;
        block13: {
            Vector instanceLogFileNames;
            Node node;
            String sNode;
            block12: {
                String fileName;
                File file;
                int i;
                sNode = targetServer.getNodeRef();
                node = domain.getNodes().getNode(sNode);
                instanceLogFileNames = null;
                instanceLogFileNamesAsString = new Vector<String>();
                if (!node.isLocal()) break block12;
                String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
                File logsDir = new File(loggingDir);
                File[] allLogFileNames = logsDir.listFiles();
                boolean noFileFound = true;
                if (allLogFileNames != null) {
                    for (i = 0; i < allLogFileNames.length; ++i) {
                        file = allLogFileNames[i];
                        fileName = file.getName();
                        if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                        instanceLogFileNamesAsString.add(fileName);
                        noFileFound = false;
                    }
                }
                if (!noFileFound) break block13;
                loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName);
                logsDir = new File(loggingDir);
                allLogFileNames = logsDir.listFiles();
                for (i = 0; i < allLogFileNames.length; ++i) {
                    file = allLogFileNames[i];
                    fileName = file.getName();
                    if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    instanceLogFileNamesAsString.add(fileName);
                }
                break block13;
            }
            if (node.getType().equals("SSH")) {
                try {
                    String fileName;
                    ChannelSftp.LsEntry file;
                    SSHLauncher sshL = this.getSSHL(habitat);
                    sshL.init(node, logger);
                    SFTPClient sftpClient = sshL.getSFTPClient();
                    boolean noFileFound = true;
                    String loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
                    try {
                        instanceLogFileNames = sftpClient.getSftpChannel().ls(loggingDir);
                        for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                            file = (ChannelSftp.LsEntry)instanceLogFileNames.get(i);
                            fileName = file.getFilename();
                            if (file.getAttrs().isDir() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                            instanceLogFileNamesAsString.add(fileName);
                            noFileFound = false;
                        }
                    }
                    catch (Exception ex) {
                        noFileFound = true;
                    }
                    if (noFileFound) {
                        loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName);
                        instanceLogFileNames = sftpClient.getSftpChannel().ls(loggingDir);
                        for (int i = 0; i < instanceLogFileNames.size(); ++i) {
                            file = (ChannelSftp.LsEntry)instanceLogFileNames.get(i);
                            fileName = file.getFilename();
                            if (file.getAttrs().isDir() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                            instanceLogFileNamesAsString.add(fileName);
                        }
                    }
                    sftpClient.close();
                }
                catch (JSchException ex) {
                    throw new IOException("Unable to download instance log file from SSH Node", ex);
                }
                catch (SftpException ex) {
                    throw new IOException("Unable to download instance log file from SSH Node", ex);
                }
            }
        }
        return instanceLogFileNamesAsString;
    }

    private SSHLauncher getSSHL(ServiceLocator habitat) {
        return (SSHLauncher)habitat.getService(SSHLauncher.class, new Annotation[0]);
    }

    private File makingDirectory(String path) {
        File targetDir = new File(path);
        boolean created = false;
        boolean deleted = false;
        if (targetDir.exists() && !(deleted = targetDir.delete())) {
            return targetDir;
        }
        created = targetDir.mkdir();
        if (!created) {
            return null;
        }
        return targetDir;
    }

    public String getLoggingDirectoryForNode(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        String loggingDir = "";
        loggingDir = instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }

    public String getLoggingDirectoryForNodeWhenNoFilesFound(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        String loggingDir = "";
        loggingDir = node.getNodeDir() != null ? node.getNodeDir() + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : (node.getInstallDir() != null ? node.getInstallDir() + File.separator + "glassfish" + File.separator + "nodes" + File.separator + sNode + File.separator + instanceName + File.separator + "logs" : instanceLogFileDirectory.substring(0, instanceLogFileDirectory.lastIndexOf(File.separator)));
        return loggingDir;
    }
}

