/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.sourcemodelwatcher;

import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.di.ClientId;
import org.eclipse.glsp.server.disposable.IDisposable;
import org.eclipse.glsp.server.features.sourcemodelwatcher.SourceModelChangedAction;
import org.eclipse.glsp.server.features.sourcemodelwatcher.SourceModelWatcher;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.session.ClientSession;
import org.eclipse.glsp.server.session.ClientSessionListener;
import org.eclipse.glsp.server.session.ClientSessionManager;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;
import org.eclipse.glsp.server.utils.Debouncer;

public class FileWatcher
implements ClientSessionListener,
SourceModelWatcher {
    protected Debouncer<ClientNotification> clientNotificationDebouncer;
    @Inject
    protected ActionDispatcher actionDispatcher;
    @Inject
    protected GModelState modelState;
    protected int debounceDelay = 500;
    protected final List<FileWatchWorker> workers = new ArrayList<FileWatchWorker>();

    @Inject
    public FileWatcher(ClientSessionManager sessionManager, @ClientId String clientId) {
        sessionManager.addListener(this, clientId);
    }

    public FileWatcher(ClientSessionManager sessionManager, ActionDispatcher actionDispatcher) {
        this(sessionManager, "");
        this.actionDispatcher = actionDispatcher;
    }

    public FileWatcher(ClientSessionManager sessionManager, ActionDispatcher actionDispatcher, GModelState modelState) {
        this(sessionManager, actionDispatcher);
        this.modelState = modelState;
    }

    public int getDebounceDelay() {
        return this.debounceDelay;
    }

    public void setDebounceDelay(int debounceDelay) {
        this.debounceDelay = debounceDelay;
    }

    @Override
    public void sessionDisposed(ClientSession session) {
        this.disposeAllWorkers();
    }

    @Override
    public void startWatching() {
        this.start();
    }

    @Override
    public void stopWatching() {
        this.disposeAllWorkers();
    }

    @Override
    public void pauseWatching() {
        this.workers.forEach(FileWatchWorker::pauseNotifications);
    }

    @Override
    public void continueWatching() {
        this.workers.forEach(FileWatchWorker::continueNotifications);
    }

    protected void start() {
        IDisposable.disposeIfExists(this.clientNotificationDebouncer);
        this.clientNotificationDebouncer = new Debouncer<ClientNotification>(this::notifyClient, this.getDebounceDelay(), TimeUnit.MILLISECONDS);
        this.createWorkers(this.modelState).forEach(Thread::start);
    }

    protected void stop() {
        this.disposeAllWorkers();
        IDisposable.disposeIfExists(this.clientNotificationDebouncer);
    }

    protected List<Path> getPaths() {
        return ClientOptionsUtil.getSourceUriAsFile(this.modelState.getClientOptions()).stream().map(file -> file.toPath()).collect(Collectors.toList());
    }

    protected List<FileWatchWorker> createWorkers(GModelState modelState) {
        this.disposeAllWorkers();
        this.workers.addAll(this.createFileWatchWorkers(modelState));
        return this.workers;
    }

    protected void disposeAllWorkers() {
        this.workers.forEach(FileWatchWorker::stopWorking);
        this.workers.clear();
    }

    private List<FileWatchWorker> createFileWatchWorkers(GModelState modelState) {
        return this.getPaths().stream().map(path -> new FileWatchWorker(modelState.getClientId(), (Path)path)).collect(Collectors.toList());
    }

    protected void scheduleClientNotification(String clientId, Path filePath) {
        this.clientNotificationDebouncer.accept(new ClientNotification(clientId, filePath.getFileName().toString()));
    }

    protected void notifyClient(ClientNotification clientNotification) {
        this.actionDispatcher.dispatch(new SourceModelChangedAction(clientNotification.modelSourceName));
    }

    protected class ClientNotification {
        protected final String clientId;
        protected final String modelSourceName;

        ClientNotification(String clientId, String modelSourceName) {
            this.clientId = clientId;
            this.modelSourceName = modelSourceName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + Objects.hash(this.clientId, this.modelSourceName);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClientNotification)) {
                return false;
            }
            ClientNotification other = (ClientNotification)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.modelSourceName, other.modelSourceName);
        }

        protected FileWatcher getEnclosingInstance() {
            return FileWatcher.this;
        }
    }

    protected class FileWatchWorker
    extends Thread {
        protected boolean stopped;
        protected boolean paused;
        protected final String clientId;
        protected final Path filePath;
        protected WatchKey key;

        FileWatchWorker(String clientId, Path filePath) {
            this.clientId = clientId;
            this.filePath = filePath;
            this.setName("File watcher: file " + filePath + " [" + clientId + "]");
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                    Path directory = this.filePath.getParent();
                    this.key = directory.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                    while (!this.stopped) {
                        WatchKey newKey = watchService.take();
                        if (this.key != newKey) continue;
                        this.pollEventsAndNotifyClient(directory);
                        if (this.key.reset()) continue;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException | ClosedWatchServiceException e) {
                Thread.currentThread().interrupt();
            }
        }

        protected void pollEventsAndNotifyClient(Path directory) throws IOException {
            for (WatchEvent<?> event : this.key.pollEvents()) {
                if (this.paused || this.stopped || !Files.isSameFile(directory.resolve((Path)event.context()), this.filePath)) continue;
                FileWatcher.this.scheduleClientNotification(this.clientId, this.filePath);
            }
        }

        public void stopWorking() {
            this.stopped = true;
            if (this.key != null) {
                this.key.reset();
            }
            this.interrupt();
        }

        public void pauseNotifications() {
            this.paused = true;
        }

        public void continueNotifications() {
            this.paused = false;
        }
    }
}

