/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.golo.doc.DocumentationElement;

class UnionDocumentation
implements Comparable<UnionDocumentation>,
DocumentationElement {
    private String name;
    private String documentation;
    private int line;
    private Set<UnionValueDocumentation> values = new LinkedHashSet<UnionValueDocumentation>();

    UnionDocumentation() {
    }

    @Override
    public String name() {
        return this.name;
    }

    public UnionDocumentation name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String documentation() {
        return this.documentation != null ? this.documentation : "\n";
    }

    public UnionDocumentation documentation(String doc) {
        this.documentation = doc;
        return this;
    }

    @Override
    public int line() {
        return this.line;
    }

    public UnionDocumentation line(int l) {
        this.line = l;
        return this;
    }

    public Set<UnionValueDocumentation> values() {
        return Collections.unmodifiableSet(this.values);
    }

    public UnionDocumentation values(Collection<UnionValueDocumentation> v) {
        this.values.addAll(v);
        return this;
    }

    public boolean addValue(UnionValueDocumentation v) {
        return this.values.add(v);
    }

    public UnionValueDocumentation addValue(String name) {
        UnionValueDocumentation v = new UnionValueDocumentation();
        v.name(name);
        this.values.add(v);
        return v;
    }

    @Override
    public int compareTo(UnionDocumentation o) {
        return this.name.compareTo(o.name());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnionDocumentation)) {
            return false;
        }
        return this.name.equals(((UnionDocumentation)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static final class UnionValueDocumentation
    implements DocumentationElement {
        private String name;
        private String documentation;
        private int line;
        private Set<String> members = new LinkedHashSet<String>();

        @Override
        public String name() {
            return this.name;
        }

        public UnionValueDocumentation name(String n) {
            this.name = n;
            return this;
        }

        @Override
        public String documentation() {
            return this.documentation != null ? this.documentation : "\n";
        }

        public UnionValueDocumentation documentation(String doc) {
            this.documentation = doc;
            return this;
        }

        @Override
        public int line() {
            return this.line;
        }

        public UnionValueDocumentation line(int l) {
            this.line = l;
            return this;
        }

        public Set<String> members() {
            return Collections.unmodifiableSet(this.members);
        }

        public UnionValueDocumentation members(Collection<String> m) {
            this.members.addAll(m);
            return this;
        }

        public boolean hasMembers() {
            return !this.members.isEmpty();
        }
    }
}

