/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IParameterValidator2;
import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ResourceBundle;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.validators.NoValidator;
import com.beust.jcommander.validators.NoValueValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ParameterDescription {
    private Object m_object;
    private WrappedParameter m_wrappedParameter;
    private Parameter m_parameterAnnotation;
    private DynamicParameter m_dynamicParameterAnnotation;
    private Parameterized m_parameterized;
    private boolean m_assigned = false;
    private java.util.ResourceBundle m_bundle;
    private String m_description;
    private JCommander m_jCommander;
    private Object m_default;
    private String m_longestName = "";

    public ParameterDescription(Object object, DynamicParameter dynamicParameter, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        if (!Map.class.isAssignableFrom(parameterized.getType())) {
            throw new ParameterException("@DynamicParameter " + parameterized.getName() + " should be of type " + "Map but is " + parameterized.getType().getName());
        }
        this.m_dynamicParameterAnnotation = dynamicParameter;
        this.m_wrappedParameter = new WrappedParameter(this.m_dynamicParameterAnnotation);
        this.init(object, parameterized, resourceBundle, jCommander);
    }

    public ParameterDescription(Object object, Parameter parameter, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        this.m_parameterAnnotation = parameter;
        this.m_wrappedParameter = new WrappedParameter(this.m_parameterAnnotation);
        this.init(object, parameterized, resourceBundle, jCommander);
    }

    private java.util.ResourceBundle findResourceBundle(Object object) {
        java.util.ResourceBundle resourceBundle = null;
        Parameters parameters = object.getClass().getAnnotation(Parameters.class);
        if (parameters != null && !this.isEmpty(parameters.resourceBundle())) {
            resourceBundle = java.util.ResourceBundle.getBundle(parameters.resourceBundle(), Locale.getDefault());
        } else {
            ResourceBundle resourceBundle2 = object.getClass().getAnnotation(ResourceBundle.class);
            if (resourceBundle2 != null && !this.isEmpty(resourceBundle2.value())) {
                resourceBundle = java.util.ResourceBundle.getBundle(resourceBundle2.value(), Locale.getDefault());
            }
        }
        return resourceBundle;
    }

    private boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    private void initDescription(String string, String string2, String[] stringArray) {
        this.m_description = string;
        if (!"".equals(string2) && this.m_bundle != null) {
            this.m_description = this.m_bundle.getString(string2);
        }
        for (String string3 : stringArray) {
            if (string3.length() <= this.m_longestName.length()) continue;
            this.m_longestName = string3;
        }
    }

    private void init(Object object, Parameterized parameterized, java.util.ResourceBundle resourceBundle, JCommander jCommander) {
        this.m_object = object;
        this.m_parameterized = parameterized;
        this.m_bundle = resourceBundle;
        if (this.m_bundle == null) {
            this.m_bundle = this.findResourceBundle(object);
        }
        this.m_jCommander = jCommander;
        if (this.m_parameterAnnotation != null) {
            String string = Enum.class.isAssignableFrom(parameterized.getType()) && this.m_parameterAnnotation.description().isEmpty() ? "Options: " + EnumSet.allOf(parameterized.getType()) : this.m_parameterAnnotation.description();
            this.initDescription(string, this.m_parameterAnnotation.descriptionKey(), this.m_parameterAnnotation.names());
        } else if (this.m_dynamicParameterAnnotation != null) {
            this.initDescription(this.m_dynamicParameterAnnotation.description(), this.m_dynamicParameterAnnotation.descriptionKey(), this.m_dynamicParameterAnnotation.names());
        } else {
            throw new AssertionError((Object)"Shound never happen");
        }
        try {
            this.m_default = parameterized.get(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_default != null && this.m_parameterAnnotation != null) {
            this.validateDefaultValues(this.m_parameterAnnotation.names());
        }
    }

    private void validateDefaultValues(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "";
        this.validateValueParameter(string, this.m_default);
    }

    public String getLongestName() {
        return this.m_longestName;
    }

    public Object getDefault() {
        return this.m_default;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Object getObject() {
        return this.m_object;
    }

    public String getNames() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.m_wrappedParameter.names();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public WrappedParameter getParameter() {
        return this.m_wrappedParameter;
    }

    public Parameterized getParameterized() {
        return this.m_parameterized;
    }

    private boolean isMultiOption() {
        Class<?> clazz = this.m_parameterized.getType();
        return clazz.equals(List.class) || clazz.equals(Set.class) || this.m_parameterized.isDynamicParameter();
    }

    public void addValue(String string) {
        this.addValue(string, false);
    }

    public boolean isAssigned() {
        return this.m_assigned;
    }

    public void setAssigned(boolean bl) {
        this.m_assigned = bl;
    }

    public void addValue(String string, boolean bl) {
        ParameterDescription.p("Adding " + (bl ? "default " : "") + "value:" + string + " to parameter:" + this.m_parameterized.getName());
        String string2 = this.m_wrappedParameter.names()[0];
        if (this.m_assigned && !this.isMultiOption() && !this.m_jCommander.isParameterOverwritingAllowed() || this.isNonOverwritableForced()) {
            throw new ParameterException("Can only specify option " + string2 + " once.");
        }
        this.validateParameter(string2, string);
        Class<?> clazz = this.m_parameterized.getType();
        Object object = this.m_jCommander.convertValue(this, string);
        this.validateValueParameter(string2, object);
        boolean bl2 = Collection.class.isAssignableFrom(clazz);
        if (bl2) {
            Collection<Object> collection = (Collection<Object>)this.m_parameterized.get(this.m_object);
            if (collection == null || this.fieldIsSetForTheFirstTime(bl)) {
                collection = this.newCollection(clazz);
                this.m_parameterized.set(this.m_object, collection);
            }
            if (object instanceof Collection) {
                collection.addAll((Collection)object);
            } else {
                collection.add(object);
            }
        } else {
            this.m_wrappedParameter.addValue(this.m_parameterized, this.m_object, object);
        }
        if (!bl) {
            this.m_assigned = true;
        }
    }

    private void validateParameter(String string, String string2) {
        Class<? extends IParameterValidator> clazz = this.m_wrappedParameter.validateWith();
        if (clazz != null) {
            ParameterDescription.validateParameter(this, clazz, string, string2);
        }
    }

    private void validateValueParameter(String string, Object object) {
        Class<? extends IValueValidator> clazz = this.m_wrappedParameter.validateValueWith();
        if (clazz != null) {
            ParameterDescription.validateValueParameter(clazz, string, object);
        }
    }

    public static void validateValueParameter(Class<? extends IValueValidator> clazz, String string, Object object) {
        try {
            if (clazz != NoValueValidator.class) {
                ParameterDescription.p("Validating value parameter:" + string + " value:" + object + " validator:" + clazz);
            }
            clazz.newInstance().validate(string, object);
        }
        catch (InstantiationException instantiationException) {
            throw new ParameterException("Can't instantiate validator:" + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ParameterException("Can't instantiate validator:" + illegalAccessException);
        }
    }

    public static void validateParameter(ParameterDescription parameterDescription, Class<? extends IParameterValidator> clazz, String string, String string2) {
        try {
            if (clazz != NoValidator.class) {
                ParameterDescription.p("Validating parameter:" + string + " value:" + string2 + " validator:" + clazz);
            }
            clazz.newInstance().validate(string, string2);
            if (IParameterValidator2.class.isAssignableFrom(clazz)) {
                IParameterValidator2 iParameterValidator2 = (IParameterValidator2)clazz.newInstance();
                iParameterValidator2.validate(string, string2, parameterDescription);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ParameterException("Can't instantiate validator:" + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ParameterException("Can't instantiate validator:" + illegalAccessException);
        }
        catch (ParameterException parameterException) {
            throw parameterException;
        }
        catch (Exception exception) {
            throw new ParameterException(exception);
        }
    }

    private Collection<Object> newCollection(Class<?> clazz) {
        if (SortedSet.class.isAssignableFrom(clazz)) {
            return new TreeSet<Object>();
        }
        if (LinkedHashSet.class.isAssignableFrom(clazz)) {
            return new LinkedHashSet<Object>();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList<Object>();
        }
        throw new ParameterException("Parameters of Collection type '" + clazz.getSimpleName() + "' are not supported. Please use List or Set instead.");
    }

    private boolean fieldIsSetForTheFirstTime(boolean bl) {
        return !bl && !this.m_assigned;
    }

    private static void p(String string) {
        if (System.getProperty("jcommander.debug") != null) {
            JCommander.getConsole().println("[ParameterDescription] " + string);
        }
    }

    public String toString() {
        return "[ParameterDescription " + this.m_parameterized.getName() + "]";
    }

    public boolean isDynamicParameter() {
        return this.m_dynamicParameterAnnotation != null;
    }

    public boolean isHelp() {
        return this.m_wrappedParameter.isHelp();
    }

    public boolean isNonOverwritableForced() {
        return this.m_wrappedParameter.isNonOverwritableForced();
    }
}

