/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class LocalReference
extends GoloElement {
    private Kind kind = Kind.CONSTANT;
    private final String name;
    private boolean synthetic = false;
    private int index = -1;

    LocalReference(String name) {
        this.name = name;
    }

    @Override
    public LocalReference ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    public Kind getKind() {
        return this.kind;
    }

    public LocalReference variable() {
        this.kind = this.kind == Kind.MODULE_VARIABLE || this.kind == Kind.MODULE_CONSTANT ? Kind.MODULE_VARIABLE : Kind.VARIABLE;
        return this;
    }

    public LocalReference moduleLevel() {
        this.kind = this.kind == Kind.CONSTANT || this.kind == Kind.MODULE_CONSTANT ? Kind.MODULE_CONSTANT : Kind.MODULE_VARIABLE;
        return this;
    }

    public LocalReference kind(Kind k) {
        this.kind = k;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public LocalReference synthetic(boolean isSynthetic) {
        this.synthetic = isSynthetic;
        return this;
    }

    public LocalReference synthetic() {
        return this.synthetic(true);
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isModuleState() {
        return this.kind == Kind.MODULE_CONSTANT || this.kind == Kind.MODULE_VARIABLE;
    }

    public boolean isConstant() {
        return this.kind == Kind.CONSTANT || this.kind == Kind.MODULE_CONSTANT;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public LocalReference index(int index) {
        this.setIndex(index);
        return this;
    }

    public ReferenceLookup lookup() {
        return new ReferenceLookup(this.name);
    }

    public String toString() {
        return String.format("LocalReference{kind=%s, name='%s', index=%d}", new Object[]{this.kind, this.name, this.index});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalReference that = (LocalReference)o;
        return this.kind == that.kind && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitLocalReference(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        throw this.cantReplace();
    }

    public static enum Kind {
        CONSTANT,
        VARIABLE,
        MODULE_CONSTANT,
        MODULE_VARIABLE;

    }
}

