/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import gololang.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.cli.command.ClasspathOption;
import org.eclipse.golo.cli.command.spi.CliCommand;
import org.eclipse.golo.compiler.GoloClassLoader;
import org.eclipse.golo.compiler.GoloCompilationException;

@Parameters(commandNames={"golo"}, resourceBundle="commands", commandDescriptionKey="golo")
public class GoloGoloCommand
implements CliCommand {
    @Parameter(names={"--files"}, variableArity=true, descriptionKey="golo.files", required=true)
    List<String> files = new LinkedList<String>();
    @Parameter(names={"--module"}, descriptionKey="main_module")
    String module;
    @Parameter(names={"--args"}, variableArity=true, descriptionKey="arguments")
    List<String> arguments = new LinkedList<String>();
    @ParametersDelegate
    ClasspathOption classpath = new ClasspathOption();

    @Override
    public void execute() throws Throwable {
        GoloClassLoader loader = this.classpath.initGoloClassLoader();
        Class<?> lastClass = null;
        for (String goloFile : this.files) {
            lastClass = this.loadGoloFile(goloFile, this.module, loader);
        }
        if (lastClass == null && this.module != null) {
            Messages.error(Messages.message("module_not_found", this.module));
            return;
        }
        if (lastClass == null) {
            return;
        }
        try {
            this.callRun(lastClass, this.arguments.toArray(new String[this.arguments.size()]));
        }
        catch (CliCommand.NoMainMethodException e) {
            Messages.error(Messages.message("module_no_main", lastClass.getName()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> loadGoloFile(String goloFile, String module, GoloClassLoader loader) throws Throwable {
        File file = new File(goloFile);
        if (!file.exists()) {
            Messages.error(Messages.message("file_not_found", file));
            return null;
        }
        if (file.isDirectory()) {
            File[] directoryFiles = file.listFiles();
            if (directoryFiles == null) return null;
            Class<?> lastClass = null;
            File[] fileArray = directoryFiles;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File directoryFile = fileArray[n2];
                Class<?> loadedClass = this.loadGoloFile(directoryFile.getAbsolutePath(), module, loader);
                if (module == null || loadedClass != null && loadedClass.getCanonicalName().equals(module)) {
                    lastClass = loadedClass;
                }
                ++n2;
            }
            return lastClass;
        }
        if (!file.getName().endsWith(".golo")) return null;
        try (FileInputStream in = new FileInputStream(file);){
            Class<?> loadedClass = loader.load(file.getName(), in);
            if (module != null) {
                if (!loadedClass.getCanonicalName().equals(module)) return null;
            }
            Class<?> clazz = loadedClass;
            return clazz;
        }
        catch (IOException e) {
            Messages.error(Messages.message("file_not_found", file.getAbsolutePath()));
            return null;
        }
        catch (GoloCompilationException e) {
            this.handleCompilationException(e);
        }
        return null;
    }
}

