/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.CollectionLiteral;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public class CollectionComprehension
extends ExpressionStatement {
    private final CollectionLiteral.Type type;
    private ExpressionStatement expression;
    private final List<Block> loopBlocks = new LinkedList<Block>();

    CollectionComprehension(CollectionLiteral.Type type) {
        this.type = type;
    }

    @Override
    public CollectionComprehension ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    public CollectionComprehension expression(Object expression) {
        this.expression = (ExpressionStatement)expression;
        this.makeParentOf(this.expression);
        return this;
    }

    public CollectionComprehension loop(Object b) {
        Block theBlock = Block.of(b);
        this.loopBlocks.add(theBlock);
        this.makeParentOf(theBlock);
        return this;
    }

    public ExpressionStatement getExpression() {
        return this.expression;
    }

    public List<Block> getLoopBlocks() {
        return Collections.unmodifiableList(this.loopBlocks);
    }

    public CollectionLiteral.Type getType() {
        return this.type;
    }

    public CollectionLiteral.Type getMutableType() {
        return CollectionLiteral.Type.tuple.equals((Object)this.type) || CollectionLiteral.Type.array.equals((Object)this.type) ? CollectionLiteral.Type.list : this.type;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitCollectionComprehension(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.expression.accept(visitor);
        for (Block block : this.loopBlocks) {
            block.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (this.expression == original && newElement instanceof ExpressionStatement) {
            this.expression(newElement);
        } else if (newElement instanceof Block && this.loopBlocks.contains(original)) {
            this.loopBlocks.set(this.loopBlocks.indexOf(original), (Block)newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

