/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.FunctionContainer;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class NamedAugmentation
extends GoloElement
implements FunctionContainer {
    private final PackageAndClass name;
    private final Set<GoloFunction> functions = new LinkedHashSet<GoloFunction>();

    NamedAugmentation(PackageAndClass name) {
        this.name = name;
    }

    public String getName() {
        return this.name.toString();
    }

    public PackageAndClass getPackageAndClass() {
        return this.name;
    }

    @Override
    public NamedAugmentation ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    @Override
    public Set<GoloFunction> getFunctions() {
        return Collections.unmodifiableSet(this.functions);
    }

    @Override
    public void addFunction(GoloFunction func) {
        this.functions.add(func);
        this.makeParentOf(func);
    }

    @Override
    public void addFunctions(Collection<GoloFunction> funcs) {
        for (GoloFunction f : funcs) {
            this.addFunction(f);
        }
    }

    @Override
    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    public NamedAugmentation add(Object fun) {
        this.addFunction((GoloFunction)fun);
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitNamedAugmentation(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (GoloFunction fun : new LinkedList<GoloFunction>(this.functions)) {
            fun.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.functions.contains(original)) {
            throw this.cantReplace(original, newElement);
        }
        this.functions.remove(original);
        this.add(newElement);
    }
}

