/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.Member;
import org.eclipse.golo.compiler.ir.UnionValue;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class Union
extends GoloElement {
    private PackageAndClass moduleName;
    private final String name;
    private final Set<UnionValue> values = new LinkedHashSet<UnionValue>();

    Union(String name) {
        this.name = name;
    }

    @Override
    public Union ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PackageAndClass getPackageAndClass() {
        return this.moduleName.createSubPackage("types").createSubPackage(this.name);
    }

    public void setModuleName(PackageAndClass module) {
        this.moduleName = module;
    }

    public UnionValue createValue(String name) {
        return new UnionValue(this, name);
    }

    public boolean addValue(UnionValue value) {
        this.makeParentOf(value);
        return this.values.add(value);
    }

    public Collection<UnionValue> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public Union value(String name, Member ... members) {
        UnionValue value = new UnionValue(this, name);
        value.addMembers(Arrays.asList(members));
        this.values.add(value);
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitUnion(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (UnionValue value : this.getValues()) {
            value.accept(visitor);
        }
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.values.contains(original) || !(newElement instanceof UnionValue)) {
            throw this.cantReplace(original, newElement);
        }
        this.values.remove(original);
        this.addValue((UnionValue)newElement);
    }
}

