/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import gololang.FunctionReference;
import gololang.Predefined;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.eclipse.golo.doc.AbstractProcessor;
import org.eclipse.golo.doc.DocIndex;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.ModuleDocumentation;

public class HtmlProcessor
extends AbstractProcessor {
    private Path srcFile;
    private final DocIndex globalIndex = new DocIndex();

    @Override
    protected String fileExtension() {
        return "html";
    }

    public DocIndex globalIndex() {
        return this.globalIndex;
    }

    public String linkToDoc(String src, DocumentationElement dst) {
        Path out = this.outputFile(src);
        if (out.getParent() != null) {
            out = out.getParent();
        }
        return out.relativize(this.docFile(dst)).toString() + (dst.id().isEmpty() ? "" : "#" + dst.id());
    }

    @Override
    public String render(ModuleDocumentation documentation) throws Throwable {
        FunctionReference template = this.template("template", this.fileExtension());
        this.globalIndex.update(documentation);
        this.addModule(documentation);
        Path doc = this.docFile(documentation);
        if (doc.getParent() != null) {
            doc = doc.getParent();
        }
        return (String)template.invoke(this, documentation, doc.relativize(this.srcFile));
    }

    @Override
    public void process(Map<String, ModuleDocumentation> docs, Path targetFolder) throws Throwable {
        this.setTargetFolder(targetFolder);
        for (Map.Entry<String, ModuleDocumentation> doc : docs.entrySet()) {
            this.renderModule(doc.getKey(), doc.getValue());
        }
        this.renderIndex("index");
        this.renderIndex("index-all");
    }

    private void renderModule(String sourceFile, ModuleDocumentation doc) throws Throwable {
        String moduleName = doc.moduleName();
        this.srcFile = this.outputFile(moduleName + "-src");
        Predefined.textToFile(this.renderSource(moduleName, sourceFile), this.srcFile);
        Predefined.textToFile(this.render(doc), this.outputFile(moduleName));
    }

    private String renderSource(String moduleName, String filename) throws Throwable {
        FunctionReference template = this.template("src", this.fileExtension());
        String content = (String)Predefined.fileToText(filename, "UTF-8");
        int nbLines = 0;
        for (int i = 0; i < content.length(); ++i) {
            if (content.charAt(i) != '\n') continue;
            ++nbLines;
        }
        return (String)template.invoke(moduleName, content, nbLines);
    }

    public static BlockEmitter blockHighlighter() {
        return new BlockEmitter(){

            public void emitBlock(StringBuilder out, List<String> lines, String meta) {
                String language = "".equals(meta) ? "golo" : meta;
                out.append("<pre class=\"listing\">");
                out.append(String.format("<code class=\"lang-%s\" data-lang=\"%s\">", language, language));
                for (String rawLine : lines) {
                    String line = rawLine.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
                    out.append(line);
                    out.append('\n');
                }
                out.append("</code></pre>");
                out.append('\n');
            }
        };
    }

    public static String sectionTitle(int level, DocumentationElement doc, Path src) {
        String permalink = String.format("<a class=\"permalink\" href=\"#%s\" title=\"link to this section\">&#182;</a>", doc.id());
        String srclink = src == null ? "" : String.format("<nav class=\"srclink\"><a href=\"%s#l-%s\" rel=\"source\" title=\"Link to the corresponding source\">Source</a></nav>", src, doc.line());
        return String.format("<h%s id=\"%s\">%s%s</h%s>%s", level, doc.id(), doc.label(), permalink, level, srclink);
    }

    public static String tocItem(DocumentationElement doc) {
        return String.format("<a href=\"#%s\">%s</a>", doc.id(), doc.label());
    }

    public static String process(String documentation, int rootLevel, Configuration configuration) {
        return Processor.process((String)AbstractProcessor.adaptSections(documentation, rootLevel), (Configuration)configuration);
    }
}

