/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.AbstractRange;
import gololang.Range;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class BigIntegerRange
extends AbstractRange<BigInteger> {
    BigIntegerRange(BigInteger from, BigInteger to) {
        super(from, to);
    }

    BigIntegerRange(BigInteger to) {
        super(to);
    }

    private BigInteger _increment() {
        return BigInteger.valueOf(this.increment());
    }

    @Override
    BigInteger defaultValue() {
        return BigInteger.ZERO;
    }

    @Override
    public Range<BigInteger> reversed() {
        return new BigIntegerRange((BigInteger)this.to(), (BigInteger)this.from()).decrementBy(this.increment());
    }

    @Override
    public int size() {
        if (((BigInteger)this.to()).equals(this.from())) {
            return 0;
        }
        int theSize = ((BigInteger)this.to()).subtract((BigInteger)this.from()).divide(this._increment()).intValue();
        if (theSize < 0) {
            return 0;
        }
        if (theSize == 0) {
            return 1;
        }
        return theSize;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof BigInteger)) {
            return false;
        }
        BigInteger obj = (BigInteger)o;
        return this.encloses(obj) && obj.subtract((BigInteger)this.from()).remainder(this._increment()).equals(BigInteger.ZERO);
    }

    @Override
    public Range<BigInteger> tail() {
        if (this.isEmpty()) {
            return this;
        }
        return new BigIntegerRange(((BigInteger)this.from()).add(this._increment()), (BigInteger)this.to()).incrementBy(this.increment());
    }

    @Override
    public Iterator<BigInteger> iterator() {
        return new AbstractRange.RangeIterator<BigInteger>(){
            private boolean started = false;
            private BigInteger current = (BigInteger)BigIntegerRange.this.from();
            private final BigInteger to = (BigInteger)BigIntegerRange.this.to();
            private final BigInteger inc = BigIntegerRange.access$000(BigIntegerRange.this);

            @Override
            public boolean hasNext() {
                return this.to.compareTo(this.current) * BigIntegerRange.this.cmp() > 0;
            }

            @Override
            public BigInteger next() {
                BigInteger value = this.current;
                if (this.started) {
                    if (this.hasNext()) {
                        this.current = this.current.add(this.inc);
                        return value;
                    }
                    throw new NoSuchElementException("iteration has finished");
                }
                this.started = true;
                this.current = this.current.add(this.inc);
                return value;
            }
        };
    }

    static /* synthetic */ BigInteger access$000(BigIntegerRange x0) {
        return x0._increment();
    }
}

