/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.Messages;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import java.util.Collections;
import java.util.List;

public final class NamedArgument
extends ExpressionStatement<NamedArgument> {
    private final String name;
    private ExpressionStatement<?> expression;

    private NamedArgument(String name, ExpressionStatement<?> expression) {
        this.name = name;
        this.setExpression(expression);
    }

    public static NamedArgument of(String name, Object value) {
        return new NamedArgument(name, ExpressionStatement.of(value));
    }

    @Override
    protected NamedArgument self() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ExpressionStatement<?> expression() {
        return this.expression;
    }

    private void setExpression(ExpressionStatement<?> value) {
        this.expression = this.makeParentOf(value);
    }

    @Override
    public NamedArgument with(Object a) {
        throw new UnsupportedOperationException(Messages.message("invalid_local_definition", this.getClass().getName()));
    }

    @Override
    public boolean hasLocalDeclarations() {
        return false;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitNamedArgument(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        return Collections.singletonList(this.expression);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (this.expression != original) {
            throw this.doesNotContain(original);
        }
        this.setExpression(ExpressionStatement.of(newElement));
    }
}

