/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Union;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.golo.runtime.MethodFinder;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.RegularMethodFinder;
import org.eclipse.golo.runtime.TypeMatching;

class PropertyMethodFinder
extends MethodFinder {
    private static final MethodHandle FLUENT_SETTER;
    private final String propertyName;

    private static Object fluentSetter(Object o, Object notUsedSetterReturnValue) {
        return o;
    }

    PropertyMethodFinder(MethodInvocation invocation, MethodHandles.Lookup lookup) {
        super(invocation, lookup);
        this.propertyName = PropertyMethodFinder.capitalize(invocation.name());
    }

    private MethodHandle findMethodForGetter() {
        if (Union.class.isAssignableFrom(this.invocation.receiverClass())) {
            return null;
        }
        MethodHandle target = new RegularMethodFinder(this.invocation.withName("get" + this.propertyName), this.lookup).find();
        if (target != null) {
            return target;
        }
        return new RegularMethodFinder(this.invocation.withName("is" + this.propertyName), this.lookup).find();
    }

    private MethodHandle fluentMethodHandle(Method candidate) {
        Objects.requireNonNull(candidate);
        MethodHandle target = this.toMethodHandle(candidate).orElse(null);
        if (target != null && !TypeMatching.returnsValue(candidate)) {
            Object receiver = this.invocation.arguments()[0];
            MethodHandle fluent = FLUENT_SETTER.bindTo(receiver);
            target = MethodHandles.filterReturnValue(target, fluent);
        }
        return target;
    }

    private MethodHandle findMethodForSetter() {
        return new RegularMethodFinder(this.invocation.withName("set" + this.propertyName), this.lookup).findInMethods().filter(method -> !Union.class.isAssignableFrom(method.getDeclaringClass())).map(this::fluentMethodHandle).findFirst().orElse(null);
    }

    @Override
    public MethodHandle find() {
        if (this.invocation.arity() == 1) {
            return this.findMethodForGetter();
        }
        return this.findMethodForSetter();
    }

    private static String capitalize(String word) {
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }

    static {
        try {
            FLUENT_SETTER = MethodHandles.lookup().findStatic(PropertyMethodFinder.class, "fluentSetter", MethodType.methodType(Object.class, Object.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error("Could not bootstrap the required fluent method handles", e);
        }
    }
}

