/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialException;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.sqlite.SQLiteEdge;
import org.eclipse.hawk.sqlite.SQLiteNode;
import org.eclipse.hawk.sqlite.SQLiteNodeIndex;
import org.eclipse.hawk.sqlite.SQLiteTransaction;
import org.eclipse.hawk.sqlite.iteration.StatementGraphNodeIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteDatabase
implements IGraphDatabase {
    private static final String SQLITE_FILE = "hawk.sqlite";
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteDatabase.class);
    private IGraphDatabase.Mode currentMode = IGraphDatabase.Mode.TX_MODE;
    private File storageFolder;
    private File tempFolder;
    private SQLiteConnection conn;

    public String getHumanReadableName() {
        return "SQLite Database";
    }

    public String getPath() {
        return this.storageFolder.getAbsolutePath();
    }

    public void run(File parentfolder, IConsole c) {
        this.storageFolder = parentfolder;
        this.tempFolder = new File(this.storageFolder, "temp");
        if (!this.tempFolder.exists()) {
            this.tempFolder.mkdirs();
        }
        try {
            Connection db = DriverManager.getConnection("jdbc:sqlite:" + new File(this.storageFolder, SQLITE_FILE).getAbsolutePath());
            db.setAutoCommit(false);
            this.conn = new SQLiteConnection(db);
            this.createSchema();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void createSchema() throws SQLException {
        SQLiteConnection connection = this.conn;
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stmt = connection.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS nodes (label VARCHAR NOT NULL);");
            stmt.execute("CREATE INDEX IF NOT EXISTS nodes_by_label ON nodes (label);");
            stmt.execute("CREATE TABLE IF NOT EXISTS nodeprops (nodeid INTEGER NOT NULL, key VARCHAR NOT NULL, type VARCHAR NOT NULL, value);");
            stmt.execute("CREATE INDEX IF NOT EXISTS nodeprops_by_id ON nodeprops (nodeid);");
            stmt.execute("CREATE UNIQUE INDEX IF NOT EXISTS nodeprops_by_id_key ON nodeprops (nodeid, key);");
            stmt.execute("CREATE TABLE IF NOT EXISTS edges (label VARCHAR NOT NULL, startId INTEGER NOT NULL, endId INTEGER NOT NULL);");
            stmt.execute("CREATE UNIQUE INDEX IF NOT EXISTS edges_unique ON edges (label, startId, endId);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edges_label_start ON edges (label, startId);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edges_label_end ON edges (label, endId);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edges_start ON edges (startId);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edges_end ON edges (endId);");
            stmt.execute("CREATE TABLE IF NOT EXISTS edgeprops (edgeid INTEGER NOT NULL, key VARCHAR NOT NULL, type VARCHAR NOT NULL, value);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edgeprops_by_id ON edgeprops (edgeid);");
            stmt.execute("CREATE UNIQUE INDEX IF NOT EXISTS edgeprops_by_id_key ON edgeprops (edgeid, key);");
            stmt.execute("CREATE TABLE IF NOT EXISTS nodeindices (name UNIQUE NOT NULL);");
            connection.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void shutdown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public void delete() throws Exception {
        this.shutdown();
        SQLiteDatabase.deleteRecursively(this.storageFolder);
    }

    public IGraphNodeIndex getOrCreateNodeIndex(String name) {
        try {
            PreparedStatement stmt = this.conn.getUpsertNodeIndexStatement(name);
            int rowCount = stmt.executeUpdate();
            if (rowCount > 0) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Statement ddl = this.conn.createStatement();){
                    ddl.execute(String.format("CREATE TABLE IF NOT EXISTS `idx_%s` (key VARCHAR NOT NULL, nodeId INTEGER NOT NULL, value);", name));
                    ddl.execute(String.format("CREATE INDEX IF NOT EXISTS `idx_%s_key` ON `idx_%s` (key);", name, name));
                    ddl.execute(String.format("CREATE INDEX IF NOT EXISTS `idx_%s_node` ON `idx_%s` (nodeId);", name, name));
                    ddl.execute(String.format("CREATE INDEX IF NOT EXISTS `idx_%s_val` ON `idx_%s` (value);", name, name));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return new SQLiteNodeIndex(this, name);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public IGraphNodeIndex getMetamodelIndex() {
        return this.getOrCreateNodeIndex("_hawk_metamodels");
    }

    public IGraphNodeIndex getFileIndex() {
        return this.getOrCreateNodeIndex("_hawk_files");
    }

    public IGraphTransaction beginTransaction() throws Exception {
        return new SQLiteTransaction(this);
    }

    public boolean isTransactional() {
        return true;
    }

    public void enterBatchMode() {
        this.currentMode = IGraphDatabase.Mode.NO_TX_MODE;
    }

    public void exitBatchMode() {
        this.currentMode = IGraphDatabase.Mode.TX_MODE;
    }

    public IGraphIterable<? extends IGraphNode> allNodes(String label) {
        return new StatementGraphNodeIterable(this, () -> this.conn.getNodeIDsByLabelStatement(label), () -> this.conn.getNodeCountByLabelStatement(label), () -> this.conn.getFirstNodeIDByLabelStatement(label));
    }

    public IGraphNode createNode(Map<String, Object> props, String label) {
        try {
            PreparedStatement insertNodeStmt = this.conn.getInsertNodeStatement();
            insertNodeStmt.setString(1, label);
            int rowCount = insertNodeStmt.executeUpdate();
            assert (rowCount == 1) : "A row should have been inserted for the node";
            int nodeId = insertNodeStmt.getGeneratedKeys().getInt(1);
            SQLiteNode node = new SQLiteNode(this, nodeId);
            if (props != null) {
                for (Map.Entry<String, Object> e : props.entrySet()) {
                    node.setProperty(e.getKey(), e.getValue());
                }
            }
            return node;
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public IGraphEdge createRelationship(IGraphNode start, IGraphNode end, String type, Map<String, Object> props) {
        int startId = (Integer)start.getId();
        int endId = (Integer)end.getId();
        try {
            PreparedStatement stmt = this.conn.getInsertEdgeStatement(startId, endId, type);
            int rowCount = stmt.executeUpdate();
            assert (rowCount == 1) : "One row should have been inserted for the edge";
            int edgeId = stmt.getGeneratedKeys().getInt(1);
            SQLiteEdge edge = new SQLiteEdge(this, edgeId, startId, endId, type);
            if (props != null) {
                for (Map.Entry<String, Object> e : props.entrySet()) {
                    edge.setProperty(e.getKey(), e.getValue());
                }
            }
            return edge;
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public SQLiteConnection getGraph() {
        return this.conn;
    }

    public IGraphNode getNodeById(Object id) {
        if (id instanceof String) {
            return new SQLiteNode(this, Integer.parseInt((String)id));
        }
        return new SQLiteNode(this, (Integer)id);
    }

    public String getTempDir() {
        return this.tempFolder.getAbsolutePath();
    }

    public IGraphDatabase.Mode currentMode() {
        return this.currentMode;
    }

    public Set<String> getNodeIndexNames() {
        try {
            PreparedStatement stmt = this.conn.getAllNodeIndices();
            stmt.execute();
            return this.conn.getStrings(stmt);
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return Collections.emptySet();
        }
    }

    protected SQLiteConnection getConnection() {
        return this.conn;
    }

    private static void deleteRecursively(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        Files.walkFileTree(f.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected class SQLiteConnection
    implements AutoCloseable {
        public static final String TYPE_BLOB_BASE64 = "blobBase64";
        private final Connection rawConn;
        private final Set<String> dropIndicesOnCommit = new HashSet<String>();
        private PreparedStatement stmtInsertNode;
        private PreparedStatement stmtDeleteNode;
        private PreparedStatement stmtNodeIDsByLabel;
        private PreparedStatement stmtNodeCountByLabel;
        private PreparedStatement stmtFirstNodeIDByLabel;
        private PreparedStatement stmtGetNodePropKeys;
        private PreparedStatement stmtGetNodePropValue;
        private PreparedStatement stmtUpsertNodeProperty;
        private PreparedStatement stmtDeleteNodeProperty;
        private PreparedStatement stmtDeleteNodeProperties;
        private PreparedStatement stmtInsertEdge;
        private PreparedStatement stmtDeleteEdge;
        private PreparedStatement stmtDeleteEdgesForNode;
        private PreparedStatement stmtGetOutgoingEdgesWithType;
        private PreparedStatement stmtGetIncomingEdgesWithType;
        private PreparedStatement stmtGetIncomingEdges;
        private PreparedStatement stmtGetOutgoingEdges;
        private PreparedStatement stmtGetEdges;
        private PreparedStatement stmtGetEdgesWithType;
        private PreparedStatement stmtGetEdgePropKeys;
        private PreparedStatement stmtGetEdgePropValue;
        private PreparedStatement stmtUpsertEdgeProperty;
        private PreparedStatement stmtDeleteEdgeProperty;
        private PreparedStatement stmtDeleteEdgeProperties;
        private PreparedStatement stmtDeleteEdgePropsForNode;
        private PreparedStatement stmtUpsertNodeIndex;
        private PreparedStatement stmtDeleteNodeIndex;
        private PreparedStatement stmtGetAllNodeIndices;
        private Map<String, PreparedStatement> stmtAddNodeIndexEntry = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtRemoveNodeIndexEntry = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtRemoveNodeFromIndex = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtRemoveNodeFieldFromIndex = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtRemoveNodeValueFromIndex = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexValuePattern = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexValuePatternCount = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexValuePatternSingle = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexValueExact = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexValueExactCount = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexValueExactSingle = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexAllValues = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexAllValuesCount = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexAllValuesSingle = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexAllPairs = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexAllPairsCount = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexAllPairsSingle = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexNumberRange = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexNumberRangeCount = new HashMap<String, PreparedStatement>();
        private Map<String, PreparedStatement> stmtQueryIndexNumberRangeSingle = new HashMap<String, PreparedStatement>();

        public SQLiteConnection(Connection rawConn) {
            this.rawConn = rawConn;
        }

        @Override
        public void close() throws SQLException {
            this.rawConn.close();
        }

        public Statement createStatement() throws SQLException {
            return this.rawConn.createStatement();
        }

        public void commit() throws SQLException {
            for (String idx : this.dropIndicesOnCommit) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (Statement stmt = this.createStatement();){
                    stmt.execute(this.getDropNodeIndexTableSQL(idx));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.dropIndicesOnCommit.clear();
            this.rawConn.commit();
        }

        public void rollback() throws SQLException {
            this.dropIndicesOnCommit.clear();
            this.rawConn.rollback();
        }

        public PreparedStatement getInsertNodeStatement() throws SQLException {
            if (this.stmtInsertNode == null) {
                this.stmtInsertNode = this.rawConn.prepareStatement("INSERT INTO nodes (label) VALUES (?);");
            }
            return this.stmtInsertNode;
        }

        public PreparedStatement getNodeIDsByLabelStatement(String label) throws SQLException {
            if (this.stmtNodeIDsByLabel == null) {
                this.stmtNodeIDsByLabel = this.rawConn.prepareStatement("SELECT rowid FROM nodes WHERE label = ?;");
            }
            this.stmtNodeIDsByLabel.setString(1, label);
            return this.stmtNodeIDsByLabel;
        }

        public PreparedStatement getNodeCountByLabelStatement(String label) throws SQLException {
            if (this.stmtNodeCountByLabel == null) {
                this.stmtNodeCountByLabel = this.rawConn.prepareStatement("SELECT COUNT(1) FROM nodes WHERE label = ?;");
            }
            this.stmtNodeCountByLabel.setString(1, label);
            return this.stmtNodeCountByLabel;
        }

        public PreparedStatement getFirstNodeIDByLabelStatement(String label) throws SQLException {
            if (this.stmtFirstNodeIDByLabel == null) {
                this.stmtFirstNodeIDByLabel = this.rawConn.prepareStatement("SELECT rowid FROM nodes WHERE label = ? LIMIT 1;");
            }
            this.stmtFirstNodeIDByLabel.setString(1, label);
            return this.stmtFirstNodeIDByLabel;
        }

        public PreparedStatement getNodePropKeysStatement(int nodeId) throws SQLException {
            if (this.stmtGetNodePropKeys == null) {
                this.stmtGetNodePropKeys = this.rawConn.prepareStatement("SELECT key FROM nodeprops WHERE nodeid = ?;");
            }
            this.stmtGetNodePropKeys.setInt(1, nodeId);
            return this.stmtGetNodePropKeys;
        }

        public PreparedStatement getNodePropValueStatement() throws SQLException {
            if (this.stmtGetNodePropValue == null) {
                this.stmtGetNodePropValue = this.rawConn.prepareStatement("SELECT type, value FROM nodeprops WHERE nodeid = ? AND key = ? LIMIT 1;");
            }
            return this.stmtGetNodePropValue;
        }

        public PreparedStatement getUpsertNodePropStatement(int nodeId, String key, Object value) throws SQLException, IOException {
            if (this.stmtUpsertNodeProperty == null) {
                this.stmtUpsertNodeProperty = this.rawConn.prepareStatement("INSERT INTO nodeprops (nodeid, key, type, value) VALUES (?, ?, ?, ?) ON CONFLICT (nodeid, key) DO UPDATE SET value = ?;");
            }
            this.setUpsertPropParameters(this.stmtUpsertNodeProperty, nodeId, key, value);
            return this.stmtUpsertNodeProperty;
        }

        protected void setUpsertPropParameters(PreparedStatement stmt, int nodeOrEdgeId, String key, Object value) throws SQLException, IOException {
            stmt.setInt(1, nodeOrEdgeId);
            stmt.setString(2, key);
            if (value instanceof Blob) {
                stmt.setString(3, TYPE_BLOB_BASE64);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.copy(((Blob)value).getBinaryStream(), bos);
                String base64String = Base64.encodeBase64String((byte[])bos.toByteArray());
                stmt.setString(4, base64String);
                stmt.setString(5, base64String);
            } else {
                stmt.setString(3, this.getPropertyType(value));
                stmt.setObject(4, value);
                stmt.setObject(5, value);
            }
        }

        private void copy(InputStream source, OutputStream target) throws IOException {
            int length;
            byte[] buf = new byte[8192];
            while ((length = source.read(buf)) > 0) {
                target.write(buf, 0, length);
            }
        }

        protected String getPropertyType(Object value) {
            return value == null ? "unknown" : value.getClass().getSimpleName();
        }

        public PreparedStatement getDeleteNodePropStatement(int nodeId, String key) throws SQLException {
            if (this.stmtDeleteNodeProperty == null) {
                this.stmtDeleteNodeProperty = this.rawConn.prepareStatement("DELETE FROM nodeprops WHERE nodeid = ? AND key = ?;");
            }
            this.stmtDeleteNodeProperty.setInt(1, nodeId);
            this.stmtDeleteNodeProperty.setString(2, key);
            return this.stmtDeleteNodeProperty;
        }

        public PreparedStatement getDeleteNodeStatement(int nodeId) throws SQLException {
            if (this.stmtDeleteNode == null) {
                this.stmtDeleteNode = this.rawConn.prepareStatement("DELETE FROM nodes WHERE rowid = ?;");
            }
            this.stmtDeleteNode.setInt(1, nodeId);
            return this.stmtDeleteNode;
        }

        public PreparedStatement getDeleteNodePropsStatement(int nodeId) throws SQLException {
            if (this.stmtDeleteNodeProperties == null) {
                this.stmtDeleteNodeProperties = this.rawConn.prepareStatement("DELETE FROM nodeprops WHERE nodeid = ?;");
            }
            this.stmtDeleteNodeProperties.setInt(1, nodeId);
            return this.stmtDeleteNodeProperties;
        }

        public PreparedStatement getInsertEdgeStatement(int startId, int endId, String label) throws SQLException {
            if (this.stmtInsertEdge == null) {
                this.stmtInsertEdge = this.rawConn.prepareStatement("INSERT INTO edges (startId, endId, label) VALUES (?, ?, ?);");
            }
            this.stmtInsertEdge.setInt(1, startId);
            this.stmtInsertEdge.setInt(2, endId);
            this.stmtInsertEdge.setString(3, label);
            return this.stmtInsertEdge;
        }

        public PreparedStatement getDeleteEdgeStatement(int edgeId) throws SQLException {
            if (this.stmtDeleteEdge == null) {
                this.stmtDeleteEdge = this.rawConn.prepareStatement("DELETE FROM edges WHERE rowid = ?;");
            }
            this.stmtDeleteEdge.setInt(1, edgeId);
            return this.stmtDeleteEdge;
        }

        public PreparedStatement getOutgoingEdgesWithTypeStatement(int fromId, String type) throws SQLException {
            if (this.stmtGetOutgoingEdgesWithType == null) {
                this.stmtGetOutgoingEdgesWithType = this.rawConn.prepareStatement("SELECT rowid, endId FROM edges WHERE label = ? AND startId = ?;");
            }
            this.stmtGetOutgoingEdgesWithType.setString(1, type);
            this.stmtGetOutgoingEdgesWithType.setInt(2, fromId);
            return this.stmtGetOutgoingEdgesWithType;
        }

        public PreparedStatement getOutgoingEdgesStatement(int fromId) throws SQLException {
            if (this.stmtGetOutgoingEdges == null) {
                this.stmtGetOutgoingEdges = this.rawConn.prepareStatement("SELECT rowid, endId, label FROM edges WHERE startId = ?;");
            }
            this.stmtGetOutgoingEdges.setInt(1, fromId);
            return this.stmtGetOutgoingEdges;
        }

        public PreparedStatement getIncomingEdgesWithTypeStatement(int endId, String type) throws SQLException {
            if (this.stmtGetIncomingEdgesWithType == null) {
                this.stmtGetIncomingEdgesWithType = this.rawConn.prepareStatement("SELECT rowid, startId FROM edges WHERE label = ? AND endId = ?;");
            }
            this.stmtGetIncomingEdgesWithType.setString(1, type);
            this.stmtGetIncomingEdgesWithType.setInt(2, endId);
            return this.stmtGetIncomingEdgesWithType;
        }

        public PreparedStatement getIncomingEdgesStatement(int endId) throws SQLException {
            if (this.stmtGetIncomingEdges == null) {
                this.stmtGetIncomingEdges = this.rawConn.prepareStatement("SELECT rowid, startId, label FROM edges WHERE endId = ?;");
            }
            this.stmtGetIncomingEdges.setInt(1, endId);
            return this.stmtGetIncomingEdges;
        }

        public PreparedStatement getEdgesStatement(int startOrEndId) throws SQLException {
            if (this.stmtGetEdges == null) {
                this.stmtGetEdges = this.rawConn.prepareStatement("SELECT rowid, startId, endId, label FROM edges WHERE startId = ? OR endId = ?;");
            }
            this.stmtGetEdges.setInt(1, startOrEndId);
            this.stmtGetEdges.setInt(2, startOrEndId);
            return this.stmtGetEdges;
        }

        public PreparedStatement getEdgesByTypeStatement(int startOrEndId, String type) throws SQLException {
            if (this.stmtGetEdgesWithType == null) {
                this.stmtGetEdgesWithType = this.rawConn.prepareStatement("SELECT rowid, startId, endid FROM edges WHERE startId = ? OR endId = ?;");
            }
            this.stmtGetEdgesWithType.setInt(1, startOrEndId);
            this.stmtGetEdgesWithType.setInt(2, startOrEndId);
            return this.stmtGetEdgesWithType;
        }

        public PreparedStatement getEdgePropKeysStatement(int edgeId) throws SQLException {
            if (this.stmtGetEdgePropKeys == null) {
                this.stmtGetEdgePropKeys = this.rawConn.prepareStatement("SELECT key FROM edgeprops WHERE edgeid = ?;");
            }
            this.stmtGetEdgePropKeys.setInt(1, edgeId);
            return this.stmtGetEdgePropKeys;
        }

        public PreparedStatement getEdgePropValueStatement(int edgeId, String key) throws SQLException {
            if (this.stmtGetEdgePropValue == null) {
                this.stmtGetEdgePropValue = this.rawConn.prepareStatement("SELECT type, value FROM edgeprops WHERE edgeid = ? AND key = ? LIMIT 1;");
            }
            this.stmtGetEdgePropValue.setInt(1, edgeId);
            this.stmtGetEdgePropValue.setString(2, key);
            return this.stmtGetEdgePropValue;
        }

        public PreparedStatement getUpsertEdgePropStatement(int edgeId, String key, Object value) throws SQLException, IOException {
            if (this.stmtUpsertEdgeProperty == null) {
                this.stmtUpsertEdgeProperty = this.rawConn.prepareStatement("INSERT INTO edgeprops (edgeid, key, type, value) VALUES (?, ?, ?, ?) ON CONFLICT (edgeid, key) DO UPDATE SET value = ?;");
            }
            this.setUpsertPropParameters(this.stmtUpsertEdgeProperty, edgeId, key, value);
            return this.stmtUpsertEdgeProperty;
        }

        public PreparedStatement getDeleteEdgePropStatement(int edgeId, String key) throws SQLException {
            if (this.stmtDeleteEdgeProperty == null) {
                this.stmtDeleteEdgeProperty = this.rawConn.prepareStatement("DELETE FROM edgeprops WHERE edgeId = ? AND key = ?;");
            }
            this.stmtDeleteEdgeProperty.setInt(1, edgeId);
            this.stmtDeleteEdgeProperty.setString(2, key);
            return this.stmtDeleteEdgeProperty;
        }

        public PreparedStatement getDeleteEdgePropertiesStatement(int edgeId) throws SQLException {
            if (this.stmtDeleteEdgeProperties == null) {
                this.stmtDeleteEdgeProperties = this.rawConn.prepareStatement("DELETE FROM edgeprops WHERE edgeId = ?;");
            }
            this.stmtDeleteEdgeProperties.setInt(1, edgeId);
            return this.stmtDeleteEdgeProperties;
        }

        public PreparedStatement getDeleteEdgePropsForNodeStatement(int nodeId) throws SQLException {
            if (this.stmtDeleteEdgePropsForNode == null) {
                this.stmtDeleteEdgePropsForNode = this.rawConn.prepareStatement("DELETE FROM edgeprops WHERE rowid IN (SELECT rowid FROM edges WHERE startId = ? OR endId = ?);");
            }
            this.stmtDeleteEdgePropsForNode.setInt(1, nodeId);
            this.stmtDeleteEdgePropsForNode.setInt(2, nodeId);
            return this.stmtDeleteEdgePropsForNode;
        }

        public PreparedStatement getDeleteEdgesForNodeStatement(int nodeId) throws SQLException {
            if (this.stmtDeleteEdgesForNode == null) {
                this.stmtDeleteEdgesForNode = this.rawConn.prepareStatement("DELETE FROM edges WHERE startId = ? OR endId = ?;");
            }
            this.stmtDeleteEdgesForNode.setInt(1, nodeId);
            this.stmtDeleteEdgesForNode.setInt(2, nodeId);
            return this.stmtDeleteEdgesForNode;
        }

        public PreparedStatement getUpsertNodeIndexStatement(String name) throws SQLException {
            if (this.stmtUpsertNodeIndex == null) {
                this.stmtUpsertNodeIndex = this.rawConn.prepareStatement("INSERT INTO nodeindices (name) VALUES (?) ON CONFLICT (name) DO NOTHING;");
            }
            this.stmtUpsertNodeIndex.setString(1, name);
            return this.stmtUpsertNodeIndex;
        }

        public PreparedStatement getDeleteNodeIndexStatement(String name) throws SQLException {
            if (this.stmtDeleteNodeIndex == null) {
                this.stmtDeleteNodeIndex = this.rawConn.prepareStatement("DELETE FROM nodeindices WHERE name = ?;");
            }
            this.stmtDeleteNodeIndex.setString(1, name);
            return this.stmtDeleteNodeIndex;
        }

        public PreparedStatement getAllNodeIndices() throws SQLException {
            if (this.stmtGetAllNodeIndices == null) {
                this.stmtGetAllNodeIndices = this.rawConn.prepareStatement("SELECT name FROM nodeindices;");
            }
            return this.stmtGetAllNodeIndices;
        }

        public PreparedStatement getAddNodeIndexEntryStatement(String indexName, int nodeId, String key, Object value) throws SQLException {
            PreparedStatement stmt = this.stmtAddNodeIndexEntry.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("INSERT INTO `idx_%s` (key, nodeId, value) VALUES (?, ?, ?);", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setInt(2, nodeId);
            stmt.setObject(3, value);
            return stmt;
        }

        public PreparedStatement getRemoveIndexEntryStatement(String indexName, int nodeId, String key, Object value) throws SQLException {
            PreparedStatement stmt = this.stmtRemoveNodeIndexEntry.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE key = ? AND nodeId = ? AND value = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setInt(2, nodeId);
            stmt.setObject(3, value);
            return stmt;
        }

        public PreparedStatement getRemoveNodeFromIndexStatement(String indexName, int nodeId) throws SQLException {
            PreparedStatement stmt = this.stmtRemoveNodeFromIndex.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE nodeId = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setInt(1, nodeId);
            return stmt;
        }

        public PreparedStatement getRemoveNodeFieldFromIndexStatement(String indexName, int nodeId, String key) throws SQLException {
            PreparedStatement stmt = this.stmtRemoveNodeFieldFromIndex.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE nodeId = ? AND key = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setInt(1, nodeId);
            stmt.setString(2, key);
            return stmt;
        }

        public PreparedStatement getRemoveNodeValueFromIndexStatement(String indexName, int nodeId, Object value) throws SQLException {
            PreparedStatement stmt = this.stmtRemoveNodeValueFromIndex.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("DELETE FROM `idx_%s` WHERE nodeId = ? AND value = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setInt(1, nodeId);
            stmt.setObject(2, value);
            return stmt;
        }

        public PreparedStatement getQueryIndexValuePatternStatement(String indexName, String key, String valueGlob) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexValuePattern.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value GLOB ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setString(2, valueGlob);
            return stmt;
        }

        public PreparedStatement getQueryIndexValuePatternCountStatement(String indexName, String key, String valueGlob) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexValuePatternCount.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT DISTINCT COUNT(1) FROM `idx_%s` WHERE key = ? AND value GLOB ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setString(2, valueGlob);
            return stmt;
        }

        public PreparedStatement getQueryIndexValuePatternSingleStatement(String indexName, String key, String valueGlob) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexValuePatternSingle.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? AND value GLOB ? LIMIT 1;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setString(2, valueGlob);
            return stmt;
        }

        public PreparedStatement getQueryIndexValueExactStatement(String indexName, String key, Object value) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexValueExact.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND value = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setObject(2, value);
            return stmt;
        }

        public PreparedStatement getQueryIndexValueExactCountStatement(String indexName, String key, Object value) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexValueExactCount.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND value = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setObject(2, value);
            return stmt;
        }

        public PreparedStatement getQueryIndexValueExactSingleStatement(String indexName, String key, Object value) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexValueExactSingle.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? AND value = ? LIMIT 1;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            stmt.setObject(2, value);
            return stmt;
        }

        public PreparedStatement getQueryIndexValueAllValuesStatement(String indexName, String key) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexAllValues.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            return stmt;
        }

        public PreparedStatement getQueryIndexValueAllValuesCountStatement(String indexName, String key) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexAllValuesCount.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ?;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            return stmt;
        }

        public PreparedStatement getQueryIndexValueAllValuesSingleStatement(String indexName, String key) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexAllValuesSingle.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? LIMIT 1;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            stmt.setString(1, key);
            return stmt;
        }

        public PreparedStatement getQueryIndexValueAllPairsStatement(String indexName) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexAllPairs.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s`;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            return stmt;
        }

        public PreparedStatement getQueryIndexValueAllPairsCountStatement(String indexName) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexAllPairsCount.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s`;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            return stmt;
        }

        public PreparedStatement getQueryIndexValueAllPairsSingleStatement(String indexName) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexAllPairsSingle.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` LIMIT 1;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            return stmt;
        }

        public PreparedStatement getQueryIndexNumberRangeStatement(String indexName, String key, Number from, Number to, boolean fromInclusive, boolean toInclusive) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexNumberRange.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT DISTINCT nodeId FROM `idx_%s` WHERE key = ? AND (? AND value >= ? OR value > ?)  AND (? AND value <= ? OR value < ?) ;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            this.setNumberRangeParameters(key, from, to, fromInclusive, toInclusive, stmt);
            return stmt;
        }

        public PreparedStatement getQueryIndexNumberRangeCountStatement(String indexName, String key, Number from, Number to, boolean fromInclusive, boolean toInclusive) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexNumberRangeCount.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT COUNT(DISTINCT nodeId) FROM `idx_%s` WHERE key = ? AND (? AND value >= ? OR value > ?)  AND (? AND value <= ? OR value < ?) ;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            this.setNumberRangeParameters(key, from, to, fromInclusive, toInclusive, stmt);
            return stmt;
        }

        public PreparedStatement getQueryIndexNumberRangeSingleStatement(String indexName, String key, Number from, Number to, boolean fromInclusive, boolean toInclusive) throws SQLException {
            PreparedStatement stmt = this.stmtQueryIndexNumberRangeSingle.computeIfAbsent(indexName, name -> {
                try {
                    return this.rawConn.prepareStatement(String.format("SELECT nodeId FROM `idx_%s` WHERE key = ? AND (? AND value >= ? OR value > ?)  AND (? AND value <= ? OR value < ?) LIMIT 1;", name));
                }
                catch (SQLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
            this.setNumberRangeParameters(key, from, to, fromInclusive, toInclusive, stmt);
            return stmt;
        }

        private void setNumberRangeParameters(String key, Number from, Number to, boolean fromInclusive, boolean toInclusive, PreparedStatement stmt) throws SQLException {
            stmt.setString(1, key);
            stmt.setBoolean(2, fromInclusive);
            stmt.setObject(3, from);
            stmt.setObject(4, from);
            stmt.setBoolean(5, toInclusive);
            stmt.setObject(6, to);
            stmt.setObject(7, to);
        }

        protected Object preprocessPropertyValue(Object value) throws IOException, SerialException, SQLException {
            if (value.getClass().isArray()) {
                ByteArrayOutputStream bOS = new ByteArrayOutputStream();
                Throwable throwable = null;
                Object var4_5 = null;
                try (ObjectOutputStream oOS = new ObjectOutputStream(bOS);){
                    oOS.writeObject(value);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                value = new SerialBlob(bOS.toByteArray());
            }
            return value;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Object getPropertyValue(PreparedStatement stmt) throws SQLException, IOException, ClassNotFoundException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ResultSet rs = stmt.getResultSet();){
                String type;
                if (!rs.next()) return null;
                switch (type = rs.getString(1)) {
                    case "Boolean": {
                        return rs.getInt(2) == 1;
                    }
                    case "blobBase64": {
                        byte[] bytes = Base64.decodeBase64((String)rs.getString(2));
                        Throwable throwable2 = null;
                        Object var9_12 = null;
                        ObjectInputStream oIS = new ObjectInputStream(new ByteArrayInputStream(bytes));
                        Object object = oIS.readObject();
                        if (oIS == null) return object;
                        oIS.close();
                        return object;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (oIS == null) throw throwable3;
                                    oIS.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                        throw throwable2;
                                    } else {
                                        if (throwable2 == throwable4) throw throwable2;
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                    }
                }
                return rs.getObject(2);
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }

        protected Set<String> getStrings(PreparedStatement stmt) throws SQLException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ResultSet rs = stmt.getResultSet();){
                HashSet<String> results = new HashSet<String>();
                while (rs.next()) {
                    results.add(rs.getString(1));
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public String getClearNodeIndexTableSQL(String name) {
            return String.format("DELETE FROM `idx_%s`;", name);
        }

        public String getDropNodeIndexTableSQL(String name) {
            return String.format("DROP TABLE `idx_%s`;", name);
        }

        public void dropIndexTableOnCommit(String name) {
            this.dropIndicesOnCommit.add(name);
        }
    }
}

