/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

import java.util.Iterator;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.graph.ModelElementNode;

public class FileNode {
    public static final String FILE_NODE_LABEL = "file";
    public static final String PROP_REPOSITORY = "repository";
    private final IGraphNode node;

    public FileNode(IGraphNode node) {
        this.node = node;
    }

    public IGraphNode getNode() {
        return this.node;
    }

    public String getFilePath() {
        return (String)this.node.getProperty("_hawkid");
    }

    public String getRepositoryURL() {
        return (String)this.node.getProperty(PROP_REPOSITORY);
    }

    public Iterable<ModelElementNode> getModelElements() {
        final Iterable incomingWithType = this.node.getIncomingWithType("_hawkFile");
        if (incomingWithType instanceof IGraphIterable) {
            return new IGraphIterable<ModelElementNode>(){

                public Iterator<ModelElementNode> iterator() {
                    return new EdgeIterator(incomingWithType.iterator());
                }

                public int size() {
                    return ((IGraphIterable)incomingWithType).size();
                }

                public ModelElementNode getSingle() {
                    return new ModelElementNode(((IGraphEdge)incomingWithType.iterator().next()).getStartNode());
                }
            };
        }
        return new Iterable<ModelElementNode>(){

            @Override
            public Iterator<ModelElementNode> iterator() {
                return new EdgeIterator(incomingWithType.iterator());
            }
        };
    }

    public boolean isRoot(ModelElementNode men) {
        for (ModelElementNode root : this.getRootModelElements()) {
            if (!root.getNodeId().equals(men.getNodeId())) continue;
            return true;
        }
        return false;
    }

    public Iterable<ModelElementNode> getRootModelElements() {
        IGraphNodeIndex rootDictionary = this.node.getGraph().getOrCreateNodeIndex("rootdictionary");
        if (rootDictionary instanceof ITimeAwareGraphNodeIndex) {
            ITimeAwareGraphNodeIndex taDict = (ITimeAwareGraphNodeIndex)rootDictionary;
            rootDictionary = taDict.travelInTime(((ITimeAwareGraphNode)this.node).getTime());
        }
        IGraphIterable roots = rootDictionary.get(FILE_NODE_LABEL, (Object)this.node.getId().toString());
        return new Iterable<ModelElementNode>((Iterable)roots){
            private final /* synthetic */ Iterable val$roots;
            {
                this.val$roots = iterable;
            }

            @Override
            public Iterator<ModelElementNode> iterator() {
                final Iterator it = this.val$roots.iterator();
                return new Iterator<ModelElementNode>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public ModelElementNode next() {
                        return new ModelElementNode((IGraphNode)it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        return "FileNode [node=" + this.node + ", fileName=" + this.getFilePath() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileNode other = (FileNode)obj;
        return !(this.node == null ? other.node != null : !this.node.equals((Object)other.node));
    }

    protected static class EdgeIterator
    implements Iterator<ModelElementNode> {
        private final Iterator<IGraphEdge> it;

        protected EdgeIterator(Iterator<IGraphEdge> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ModelElementNode next() {
            return new ModelElementNode(this.it.next().getStartNode());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

