/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.scopes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.queries.operations.scopes.AbstractTimeAwareNodeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhenNodeWrapper
extends AbstractTimeAwareNodeWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(WhenNodeWrapper.class);
    private final List<Long> matchingVersions;
    private final int matchingVersionPosition;

    public WhenNodeWrapper(ITimeAwareGraphNode original, List<Long> matchingVersions) {
        this(original, matchingVersions, matchingVersions.size() - 1);
    }

    protected WhenNodeWrapper(ITimeAwareGraphNode original, List<Long> matchingVersions, int position) {
        super(original);
        this.matchingVersions = matchingVersions;
        this.matchingVersionPosition = position;
        assert (!matchingVersions.isEmpty()) : "At least one matching version should exist";
        assert (matchingVersions.get(position).longValue() == original.getTime()) : "Wrapped node should have the expected time from its position in the matched timepoints list";
    }

    public List<Long> getAllInstants() {
        return this.matchingVersions;
    }

    public long getEarliestInstant() {
        return this.matchingVersions.get(this.matchingVersions.size() - 1);
    }

    public long getPreviousInstant() {
        if (this.matchingVersionPosition + 1 < this.matchingVersions.size()) {
            return this.matchingVersionPosition + 1;
        }
        return -1L;
    }

    public long getLatestInstant() {
        return this.matchingVersions.get(0);
    }

    public long getNextInstant() {
        if (this.matchingVersionPosition > 0) {
            return this.matchingVersions.get(this.matchingVersionPosition - 1);
        }
        return -1L;
    }

    public ITimeAwareGraphNode travelInTime(long time) {
        block5: {
            if (time >= this.getEarliestInstant()) break block5;
            return null;
        }
        try {
            int position = this.matchingVersions.size() - 1;
            if (this.matchingVersions.size() > 1) {
                int i = this.matchingVersions.size() - 2;
                while (i >= 0) {
                    long candidate = this.matchingVersions.get(i);
                    if (candidate > time) break;
                    position = i--;
                }
            }
            long timepoint = this.matchingVersions.get(position);
            return new WhenNodeWrapper(this.original.travelInTime(timepoint), this.matchingVersions, position);
        }
        catch (Exception ex) {
            LOGGER.error("Could not travel in time", (Throwable)ex);
            return null;
        }
    }

    public List<Long> getInstantsBetween(long fromInclusive, long toInclusive) {
        int iStart = 0;
        int iEnd = this.matchingVersions.size();
        while (iStart < this.matchingVersions.size() && this.matchingVersions.get(iStart) > toInclusive) {
            ++iStart;
        }
        while (iEnd > 0 && this.matchingVersions.get(iEnd - 1) < fromInclusive) {
            --iEnd;
        }
        return this.matchingVersions.subList(iStart, iEnd);
    }

    public List<Long> getInstantsFrom(long fromInclusive) {
        return this.getInstantsBetween(fromInclusive, this.getLatestInstant());
    }

    public List<Long> getInstantsUpTo(long toInclusive) {
        return this.getInstantsBetween(this.getEarliestInstant(), toInclusive);
    }

    public List<ITimeAwareGraphNode> getAllVersions() throws Exception {
        ArrayList<ITimeAwareGraphNode> taNodes = new ArrayList<ITimeAwareGraphNode>(this.matchingVersions.size());
        int i = 0;
        while (i < this.matchingVersions.size()) {
            ITimeAwareGraphNode version = this.original.travelInTime(this.matchingVersions.get(i).longValue());
            WhenNodeWrapper wrapped = new WhenNodeWrapper(version, this.matchingVersions, i);
            taNodes.add(wrapped);
            ++i;
        }
        return taNodes;
    }

    public ITimeAwareGraphNode getEarliest() throws Exception {
        ITimeAwareGraphNode version = this.original.travelInTime(this.getEarliestInstant());
        return new WhenNodeWrapper(version, this.matchingVersions, this.matchingVersions.size() - 1);
    }

    public ITimeAwareGraphNode getPrevious() {
        if (this.matchingVersionPosition + 1 < this.matchingVersions.size()) {
            ITimeAwareGraphNode version = this.original.travelInTime(this.matchingVersions.get(this.matchingVersionPosition + 1).longValue());
            return new WhenNodeWrapper(version, this.matchingVersions, this.matchingVersionPosition + 1);
        }
        return null;
    }

    public ITimeAwareGraphNode getLatest() {
        ITimeAwareGraphNode version = this.original.travelInTime(this.getLatestInstant());
        return new WhenNodeWrapper(version, this.matchingVersions, 0);
    }

    public ITimeAwareGraphNode getNext() throws Exception {
        if (this.matchingVersionPosition > 0) {
            ITimeAwareGraphNode version = this.original.travelInTime(this.matchingVersions.get(this.matchingVersionPosition - 1).longValue());
            return new WhenNodeWrapper(version, this.matchingVersions, this.matchingVersionPosition - 1);
        }
        return null;
    }

    public List<ITimeAwareGraphNode> getVersionsBetween(long fromInclusive, long toInclusive) throws Exception {
        ArrayList<ITimeAwareGraphNode> results = new ArrayList<ITimeAwareGraphNode>();
        int i = 0;
        while (i < this.matchingVersions.size()) {
            long instant = this.matchingVersions.get(i);
            if (instant <= toInclusive) {
                if (instant < fromInclusive) break;
                ITimeAwareGraphNode version = this.original.travelInTime(instant);
                results.add(new WhenNodeWrapper(version, this.matchingVersions, i));
            }
            ++i;
        }
        return results;
    }

    public List<ITimeAwareGraphNode> getVersionsFrom(long fromInclusive) throws Exception {
        return this.getVersionsBetween(fromInclusive, this.getLatestInstant());
    }

    public List<ITimeAwareGraphNode> getVersionsUpTo(long toInclusive) throws Exception {
        return this.getVersionsBetween(this.getEarliestInstant(), toInclusive);
    }
}

