/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTypeNodeReference;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.wrappers.MetamodelNodeWrapper;
import org.eclipse.hawk.epsilon.emc.wrappers.SlotWrapper;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;

public class TypeNodeWrapper
implements IGraphTypeNodeReference {
    private final TypeNode typeNode;
    private final EOLQueryEngine model;

    public TypeNodeWrapper(TypeNode node, EOLQueryEngine model) {
        this.typeNode = node;
        this.model = model;
    }

    public String getId() {
        return this.typeNode.getNode().getId().toString();
    }

    public IGraphNode getNode() {
        return this.typeNode.getNode();
    }

    public IQueryEngine getContainerModel() {
        return this.model;
    }

    public String getTypeName() {
        return "_hawkTypeNode";
    }

    public String getName() {
        return this.typeNode.getTypeName();
    }

    public Collection<Object> getAll() {
        return this.model.getAllOf(this.typeNode.getNode(), "_hawkOfKind");
    }

    public List<SlotWrapper> getAttributes() {
        ArrayList<SlotWrapper> attributes = new ArrayList<SlotWrapper>();
        for (Slot s : this.typeNode.getSlots().values()) {
            if (!s.isAttribute()) continue;
            attributes.add(new SlotWrapper(s, this.model));
        }
        return attributes;
    }

    public List<SlotWrapper> getReferences() {
        ArrayList<SlotWrapper> attributes = new ArrayList<SlotWrapper>();
        for (Slot s : this.typeNode.getSlots().values()) {
            if (!s.isReference()) continue;
            attributes.add(new SlotWrapper(s, this.model));
        }
        return attributes;
    }

    public Collection<Slot> getFeatures() {
        return this.typeNode.getSlots().values();
    }

    public MetamodelNodeWrapper getMetamodel() {
        return new MetamodelNodeWrapper(this.typeNode.getMetamodel(), this.model);
    }

    public List<TypeNodeWrapper> getAllSupertypes() {
        return this.typeNode.getAllSupertypes().stream().map(e -> new TypeNodeWrapper((TypeNode)e, this.model)).collect(Collectors.toList());
    }

    public List<TypeNodeWrapper> getAllSubtypes() {
        return this.typeNode.getAllSubtypes().stream().map(e -> new TypeNodeWrapper((TypeNode)e, this.model)).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("TNW|id:%s|type:%s", this.getId(), this.getTypeName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.typeNode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeNodeWrapper other = (TypeNodeWrapper)obj;
        return Objects.equals((Object)this.model, (Object)other.model) && Objects.equals(this.typeNode, other.typeNode);
    }
}

