/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IMetaModelUpdater;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.core.runtime.ModelIndexerImpl;
import org.eclipse.hawk.core.security.FileBasedCredentialsStore;
import org.eclipse.hawk.core.util.DefaultConsole;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.graph.updater.GraphMetaModelUpdater;
import org.eclipse.hawk.graph.updater.GraphModelUpdater;
import org.eclipse.hawk.integration.tests.ScheduledTask;
import org.eclipse.hawk.localfolder.LocalFolder;
import org.eclipse.hawk.workspace.Workspace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ModelIndexingTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public TestName testName = new TestName();
    protected DefaultConsole console;
    protected IModelIndexer indexer;
    protected EOLQueryEngine queryEngine;
    protected IGraphDatabase db;
    protected final File baseDir;
    private IGraphDatabaseFactory dbFactory;
    private IModelSupportFactory msFactory;

    public ModelIndexingTest(File baseDir, IGraphDatabaseFactory dbFactory, IModelSupportFactory msFactory) {
        this.baseDir = baseDir;
        this.dbFactory = dbFactory;
        this.msFactory = msFactory;
    }

    @Before
    public void setup() throws Throwable {
        if (this.indexer != null) {
            return;
        }
        File indexerFolder = this.tempFolder.getRoot();
        File dbFolder = new File(indexerFolder, "test_" + this.testName.getMethodName());
        dbFolder.mkdir();
        this.console = new DefaultConsole();
        this.db = this.dbFactory.create();
        this.db.run(dbFolder, (IConsole)this.console);
        FileBasedCredentialsStore credStore = new FileBasedCredentialsStore(new File("keystore"), "admin".toCharArray());
        this.indexer = this.createIndexer(indexerFolder, credStore);
        this.indexer.addMetaModelResourceFactory(this.msFactory.createMetaModelResourceFactory());
        this.indexer.addModelResourceFactory(this.msFactory.createModelResourceFactory());
        this.queryEngine = new EOLQueryEngine();
        this.indexer.addQueryEngine((IQueryEngine)this.queryEngine);
        this.indexer.setMetaModelUpdater((IMetaModelUpdater)new GraphMetaModelUpdater());
        this.indexer.addModelUpdater((IModelUpdater)this.createModelUpdater());
        this.indexer.setDB(this.db, true);
        this.indexer.init(0, 0);
    }

    protected IModelIndexer createIndexer(File indexerFolder, FileBasedCredentialsStore credStore) {
        return new ModelIndexerImpl("test", indexerFolder, (ICredentialsStore)credStore, (IConsole)this.console);
    }

    protected GraphModelUpdater createModelUpdater() {
        return new GraphModelUpdater();
    }

    @After
    public void teardown() throws Exception {
        this.indexer.shutdown(IModelIndexer.ShutdownRequestType.ALWAYS);
        this.db.delete();
    }

    protected void scheduleAndWait() throws Throwable {
        this.scheduleAndWait(() -> null);
    }

    protected void scheduleAndWait(Callable<?> r) throws Throwable {
        Semaphore sem = new Semaphore(0);
        ScheduledTask task = new ScheduledTask(r, sem);
        this.indexer.scheduleTask(task, 0L);
        if (!sem.tryAcquire(1200L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Synchronization timed out");
        } else if (task.getThrowable() != null) {
            throw task.getThrowable();
        }
    }

    protected LocalFolder requestFolderIndex(File folder) throws Exception {
        LocalFolder vcs = new LocalFolder();
        vcs.init(folder.getCanonicalPath(), this.indexer);
        vcs.run();
        this.indexer.addVCSManager((IVcsManager)vcs, true);
        return vcs;
    }

    protected void requestWorkspaceIndex() throws Exception {
        Workspace vcs = new Workspace();
        vcs.init("/", this.indexer);
        vcs.run();
        this.indexer.addVCSManager((IVcsManager)vcs, true);
    }

    protected void assertNoErrors(SyncValidationListener listener) {
        List errors = listener.getErrors();
        if (!errors.isEmpty()) {
            System.err.println("ERRORS DURING VALIDATION");
            for (SyncValidationListener.ValidationError e : errors) {
                System.err.println("- " + e.getMessage());
                System.err.println();
            }
            Assert.fail((String)"Errors during validation");
        }
    }

    protected Object eol(String eolQuery) throws InvalidQueryException, QueryExecutionException {
        return this.eol(eolQuery, null);
    }

    protected Object eol(String eolQuery, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
        return this.queryEngine.query(this.indexer, eolQuery, context);
    }

    protected Object eolWorkspace(String query) throws InvalidQueryException, QueryExecutionException {
        return this.eol(query, Collections.singletonMap("REPOSITORY", "platform:/resource"));
    }

    protected IProject openProject(File projectFolder) throws CoreException {
        File projectFile = new File(projectFolder, ".project");
        Path projectPath = new Path(projectFile.getAbsolutePath());
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProjectDescription description = ws.loadProjectDescription((IPath)projectPath);
        IProject project = ws.getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        return project;
    }

    public static class GraphChangeListenerRule<T extends IGraphChangeListener>
    extends ExternalResource {
        private T listener;
        final /* synthetic */ ModelIndexingTest this$0;

        public T getListener() {
            return this.listener;
        }

        public GraphChangeListenerRule(T listener) {
            this.this$0 = var1_1;
            this.listener = listener;
        }

        protected void before() throws Throwable {
            if (this.this$0.indexer == null) {
                this.this$0.setup();
            }
            this.this$0.indexer.addGraphChangeListener(this.listener);
            this.listener.setModelIndexer(this.this$0.indexer);
        }

        protected void after() {
            this.this$0.indexer.removeGraphChangeListener(this.listener);
        }
    }

    public static interface IModelSupportFactory {
        public IMetaModelResourceFactory createMetaModelResourceFactory();

        public IModelResourceFactory createModelResourceFactory();
    }
}

