/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.proton.ProtonClientOptionsConverter;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject(generateConverter=true, publicConverter=false)
public class ProtonClientOptions
extends NetClientOptions {
    private Set<String> enabledSaslMechanisms = new LinkedHashSet<String>();
    private int heartbeat;
    private int maxFrameSize;
    private String virtualHost;
    private String sniServerName;

    public ProtonClientOptions() {
        this.setHostnameVerificationAlgorithm("HTTPS");
    }

    public ProtonClientOptions(ProtonClientOptions other) {
        super(other);
        this.enabledSaslMechanisms = new LinkedHashSet<String>(other.enabledSaslMechanisms);
        this.heartbeat = other.heartbeat;
        this.maxFrameSize = other.maxFrameSize;
        this.virtualHost = other.virtualHost;
        this.sniServerName = other.sniServerName;
    }

    public ProtonClientOptions(JsonObject json) {
        super(json);
        ProtonClientOptionsConverter.fromJson(json, this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ProtonClientOptionsConverter.toJson(this, json);
        return json;
    }

    public Set<String> getEnabledSaslMechanisms() {
        return this.enabledSaslMechanisms;
    }

    public ProtonClientOptions addEnabledSaslMechanism(String saslMechanism) {
        Objects.requireNonNull(saslMechanism, "Mechanism must not be null");
        this.enabledSaslMechanisms.add(saslMechanism);
        return this;
    }

    @Override
    public ProtonClientOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public ProtonClientOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public ProtonClientOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public ProtonClientOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public ProtonClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public ProtonClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public ProtonClientOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public ProtonClientOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public ProtonClientOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        super.setIdleTimeoutUnit(idleTimeoutUnit);
        return this;
    }

    @Override
    public ProtonClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public ProtonClientOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public ProtonClientOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    @Override
    public ProtonClientOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    @Override
    public ProtonClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    @Override
    public ProtonClientOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public ProtonClientOptions setReconnectAttempts(int attempts) {
        super.setReconnectAttempts(attempts);
        return this;
    }

    @Override
    public ProtonClientOptions setReconnectInterval(long interval) {
        super.setReconnectInterval(interval);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.enabledSaslMechanisms);
        result = 31 * result + this.heartbeat;
        result = 31 * result + this.maxFrameSize;
        result = 31 * result + (this.virtualHost != null ? this.virtualHost.hashCode() : 0);
        result = 31 * result + (this.sniServerName != null ? this.sniServerName.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ProtonClientOptions other = (ProtonClientOptions)obj;
        if (!Objects.equals(this.enabledSaslMechanisms, other.enabledSaslMechanisms)) {
            return false;
        }
        if (this.heartbeat != other.heartbeat) {
            return false;
        }
        if (this.maxFrameSize != other.maxFrameSize) {
            return false;
        }
        if (!Objects.equals(this.virtualHost, other.virtualHost)) {
            return false;
        }
        return Objects.equals(this.sniServerName, other.sniServerName);
    }

    @Override
    public ProtonClientOptions setUseAlpn(boolean useAlpn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProtonClientOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    @Override
    public ProtonClientOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        return this;
    }

    @Override
    public ProtonClientOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions setLogActivity(boolean logEnabled) {
        super.setLogActivity(logEnabled);
        return this;
    }

    @Override
    public ProtonClientOptions setMetricsName(String metricsName) {
        super.setMetricsName(metricsName);
        return this;
    }

    @Override
    public ProtonClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        super.setProxyOptions(proxyOptions);
        return this;
    }

    @Override
    public ProtonClientOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    @Override
    public ProtonClientOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        super.setJdkSslEngineOptions(sslEngineOptions);
        return this;
    }

    @Override
    public ProtonClientOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        super.setOpenSslEngineOptions(sslEngineOptions);
        return this;
    }

    @Override
    public ProtonClientOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    @Override
    public ProtonClientOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        super.setSslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    @Override
    public ProtonClientOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
        return this;
    }

    @Override
    public ProtonClientOptions setLocalAddress(String localAddress) {
        super.setLocalAddress(localAddress);
        return this;
    }

    @Override
    public ProtonClientOptions setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    @Override
    public ProtonClientOptions setTcpCork(boolean tcpCork) {
        super.setTcpCork(tcpCork);
        return this;
    }

    @Override
    public ProtonClientOptions setTcpFastOpen(boolean tcpFastOpen) {
        super.setTcpFastOpen(tcpFastOpen);
        return this;
    }

    @Override
    public ProtonClientOptions setTcpQuickAck(boolean tcpQuickAck) {
        super.setTcpQuickAck(tcpQuickAck);
        return this;
    }

    @Override
    public ProtonClientOptions removeEnabledSecureTransportProtocol(String protocol) {
        super.removeEnabledSecureTransportProtocol(protocol);
        return this;
    }

    @Override
    public ProtonClientOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        super.setEnabledSecureTransportProtocols((Set)enabledSecureTransportProtocols);
        return this;
    }

    public ProtonClientOptions setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
        return this;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public ProtonClientOptions setSniServerName(String sniServerName) {
        this.sniServerName = sniServerName;
        return this;
    }

    public String getSniServerName() {
        return this.sniServerName;
    }

    public ProtonClientOptions setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public ProtonClientOptions setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize < 0 ? -1 : maxFrameSize;
        return this;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }
}

