/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.config;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.hono.config.SignatureSupportingOptions;

public class SignatureSupportingConfigProperties {
    private String sharedSecret = null;
    private String keyPath = null;
    private long tokenExpiration = 600L;
    private String certPath = null;

    public SignatureSupportingConfigProperties() {
    }

    public SignatureSupportingConfigProperties(SignatureSupportingOptions options) {
        this.certPath = options.certPath().orElse(null);
        this.keyPath = options.keyPath().orElse(null);
        this.sharedSecret = options.sharedSecret().orElse(null);
        this.tokenExpiration = options.tokenExpiration();
    }

    public final String getSharedSecret() {
        return this.sharedSecret;
    }

    public final void setSharedSecret(String secret) {
        if (Objects.requireNonNull(secret).getBytes(StandardCharsets.UTF_8).length < 32) {
            throw new IllegalArgumentException("shared secret must be at least 32 bytes");
        }
        this.sharedSecret = secret;
    }

    public final void setKeyPath(String keyPath) {
        this.keyPath = Objects.requireNonNull(keyPath);
    }

    public final String getKeyPath() {
        return this.keyPath;
    }

    public final long getTokenExpiration() {
        return this.tokenExpiration;
    }

    public final void setTokenExpiration(long seconds) {
        if (seconds <= 0L) {
            throw new IllegalArgumentException("token expiration must be > 0");
        }
        this.tokenExpiration = seconds;
    }

    public final void setCertPath(String certPath) {
        this.certPath = Objects.requireNonNull(certPath);
    }

    public final String getCertPath() {
        return this.certPath;
    }

    public final boolean isAppropriateForCreating() {
        return this.sharedSecret != null || this.keyPath != null;
    }

    public final boolean isAppropriateForValidating() {
        return this.sharedSecret != null || this.certPath != null;
    }
}

