/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.util.JsonBackedValueObject;

public final class CredentialsObject
extends JsonBackedValueObject {
    public CredentialsObject() {
    }

    public CredentialsObject(String deviceId, String authId, String type) {
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(type);
        this.setDeviceId(deviceId);
        this.setType(type);
        this.setAuthId(authId);
    }

    @JsonAnySetter
    public CredentialsObject setProperty(String name, Object value) {
        this.json.put(Objects.requireNonNull(name), value);
        return this;
    }

    @JsonIgnore
    public String getDeviceId() {
        return this.getProperty("device-id", String.class);
    }

    @JsonIgnore
    public CredentialsObject setDeviceId(String deviceId) {
        this.setProperty("device-id", deviceId);
        return this;
    }

    @JsonIgnore
    public String getType() {
        return this.getProperty("type", String.class);
    }

    @JsonIgnore
    public CredentialsObject setType(String type) {
        this.setProperty("type", type);
        return this;
    }

    @JsonIgnore
    public String getAuthId() {
        return this.getProperty("auth-id", String.class);
    }

    @JsonIgnore
    public CredentialsObject setAuthId(String authId) {
        this.setProperty("auth-id", authId);
        return this;
    }

    @JsonIgnore
    public boolean isEnabled() {
        return this.getProperty("enabled", Boolean.class, true);
    }

    @JsonIgnore
    public CredentialsObject setEnabled(boolean enabled) {
        this.setProperty("enabled", enabled);
        return this;
    }

    @JsonIgnore
    public JsonArray getSecrets() {
        return Optional.ofNullable(this.getProperty("secrets", JsonArray.class)).orElseGet(() -> {
            JsonArray result = new JsonArray();
            this.setProperty("secrets", result);
            return result;
        });
    }

    public CredentialsObject addSecret(JsonObject secret) {
        if (secret != null) {
            this.getSecrets().add(secret);
        }
        return this;
    }

    public CredentialsObject addSecret(Map<String, Object> secret) {
        this.addSecret(new JsonObject(secret));
        return this;
    }

    public void checkValidity() {
        this.checkValidity((type, secret) -> {});
    }

    public void checkValidity(BiConsumer<String, JsonObject> secretValidator) {
        if (this.getDeviceId() == null) {
            throw new IllegalStateException("missing device ID");
        }
        if (this.getAuthId() == null) {
            throw new IllegalStateException("missing auth ID");
        }
        if (this.getType() == null) {
            throw new IllegalStateException("missing type");
        }
        this.checkSecrets(secretValidator);
    }

    public void checkSecrets() {
        this.checkSecrets((secretType, secret) -> {});
    }

    public void checkSecrets(BiConsumer<String, JsonObject> secretValidator) {
        Objects.requireNonNull(secretValidator);
        JsonArray secrets = this.getSecrets();
        if (secrets == null || secrets.isEmpty()) {
            throw new IllegalStateException("credentials object must contain at least one secret");
        }
        try {
            switch (this.getType()) {
                case "hashed-password": {
                    CredentialsObject.checkSecrets(secrets, secret -> {
                        CredentialsObject.checkHashedPassword(secret);
                        secretValidator.accept(this.getType(), (JsonObject)secret);
                    });
                    break;
                }
                default: {
                    CredentialsObject.checkSecrets(secrets, secret -> {});
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static void checkSecrets(JsonArray secrets, Consumer<JsonObject> secretValidator) {
        secrets.stream().filter(obj -> obj instanceof JsonObject).forEach(obj -> {
            JsonObject secret = (JsonObject)obj;
            CredentialsObject.checkValidityPeriod(secret);
            secretValidator.accept(secret);
        });
    }

    private static void checkHashedPassword(JsonObject secret) {
        Object hashFunction = secret.getValue("hash-function");
        if (!(hashFunction instanceof String)) {
            throw new IllegalStateException("missing/invalid hash function");
        }
        Object hashedPwd = secret.getValue("pwd-hash");
        if (!(hashedPwd instanceof String)) {
            throw new IllegalStateException("missing/invalid password hash");
        }
    }

    private static void checkValidityPeriod(JsonObject secret) {
        Instant notBefore = CredentialsObject.getTimestampIfPresentForField(secret, "not-before");
        Instant notAfter = CredentialsObject.getTimestampIfPresentForField(secret, "not-after");
        if (notBefore != null && notAfter != null && !notBefore.isBefore(notAfter)) {
            throw new IllegalStateException("not-before must be before not-after");
        }
    }

    private static Instant getTimestampIfPresentForField(JsonObject secret, String field) {
        String timestamp = secret.getString(field);
        if (timestamp == null) {
            return null;
        }
        Instant result = CredentialsObject.getInstant(timestamp);
        if (result == null) {
            throw new IllegalArgumentException("invalid " + field + " property");
        }
        return result;
    }

    @JsonIgnore
    public List<JsonObject> getCandidateSecrets() {
        return this.getCandidateSecrets(secret -> secret);
    }

    @JsonIgnore
    public <T> List<T> getCandidateSecrets(Function<JsonObject, T> projection) {
        Objects.requireNonNull(projection);
        return this.getSecrets().stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(CredentialsObject::isSecretEnabled).filter(secret -> CredentialsObject.isInValidityPeriod(secret, Instant.now())).map(projection).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean isInValidityPeriod(JsonObject secret, Instant instant) {
        Instant notBefore = CredentialsObject.getNotBefore(secret);
        Instant notAfter = CredentialsObject.getNotAfter(secret);
        return !(notBefore != null && !instant.isAfter(notBefore) || notAfter != null && !instant.isBefore(notAfter));
    }

    public static Instant getNotBefore(JsonObject secret) {
        if (secret == null) {
            return null;
        }
        return CredentialsObject.getInstant(secret, "not-before");
    }

    public static Instant getNotAfter(JsonObject secret) {
        if (secret == null) {
            return null;
        }
        return CredentialsObject.getInstant(secret, "not-after");
    }

    private static Instant getInstant(JsonObject secret, String field) {
        Object value = secret.getValue(field);
        if (String.class.isInstance(value)) {
            return CredentialsObject.getInstant((String)value);
        }
        return null;
    }

    private static Instant getInstant(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        try {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, OffsetDateTime::from).toInstant();
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    private static boolean isSecretEnabled(JsonObject secret) {
        Objects.requireNonNull(secret);
        return CredentialsObject.getProperty(secret, "enabled", Boolean.class, true);
    }

    public static JsonObject emptySecret(Instant notBefore, Instant notAfter) {
        if (notBefore != null && notAfter != null && !notBefore.isBefore(notAfter)) {
            throw new IllegalArgumentException("not before must be before not after");
        }
        JsonObject secret = new JsonObject();
        if (notBefore != null) {
            secret.put("not-before", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(notBefore.atOffset(ZoneOffset.UTC)));
        }
        if (notAfter != null) {
            secret.put("not-after", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(notAfter.atOffset(ZoneOffset.UTC)));
        }
        return secret;
    }

    public static CredentialsObject fromHashedPassword(String deviceId, String username, String passwordHash, String hashAlgorithm, Instant notBefore, Instant notAfter, byte[] salt) {
        Objects.requireNonNull(passwordHash);
        Objects.requireNonNull(hashAlgorithm);
        CredentialsObject result = new CredentialsObject(deviceId, username, "hashed-password");
        result.addSecret(CredentialsObject.hashedPasswordSecretForPasswordHash(passwordHash, hashAlgorithm, notBefore, notAfter, salt));
        return result;
    }

    public static CredentialsObject fromClearTextPassword(String deviceId, String username, String clearTextPassword, Instant notBefore, Instant notAfter) {
        Objects.requireNonNull(clearTextPassword);
        CredentialsObject result = new CredentialsObject(deviceId, username, "hashed-password");
        result.addSecret(CredentialsObject.hashedPasswordSecretForClearTextPassword(clearTextPassword, notBefore, notAfter));
        return result;
    }

    public static JsonObject hashedPasswordSecretForPasswordHash(String passwordHash, String hashAlgorithm, Instant notBefore, Instant notAfter, byte[] salt) {
        return CredentialsObject.hashedPasswordSecretForPasswordHash(passwordHash, hashAlgorithm, notBefore, notAfter, Optional.ofNullable(salt).map(s -> Base64.getEncoder().encodeToString((byte[])s)).orElse(null));
    }

    public static JsonObject hashedPasswordSecretForPasswordHash(String passwordHash, String hashAlgorithm, Instant notBefore, Instant notAfter, String encodedSalt) {
        Objects.requireNonNull(passwordHash);
        Objects.requireNonNull(hashAlgorithm);
        JsonObject secret = CredentialsObject.emptySecret(notBefore, notAfter);
        secret.put("hash-function", hashAlgorithm);
        if (encodedSalt != null) {
            secret.put("salt", encodedSalt);
        }
        secret.put("pwd-hash", passwordHash);
        return secret;
    }

    public static JsonObject hashedPasswordSecretForClearTextPassword(String clearTextpassword, Instant notBefore, Instant notAfter) {
        Objects.requireNonNull(clearTextpassword);
        JsonObject secret = CredentialsObject.emptySecret(notBefore, notAfter);
        secret.put("pwd-plain", clearTextpassword);
        return secret;
    }

    public static CredentialsObject fromPresharedKey(String deviceId, String authId, byte[] key, Instant notBefore, Instant notAfter) {
        Objects.requireNonNull(key);
        CredentialsObject result = new CredentialsObject(deviceId, authId, "psk");
        JsonObject secret = CredentialsObject.emptySecret(notBefore, notAfter);
        secret.put("key", Base64.getEncoder().encodeToString(key));
        result.addSecret(secret);
        return result;
    }

    public static CredentialsObject fromClientCertificate(String deviceId, X509Certificate certificate, Instant notBefore, Instant notAfter) {
        Objects.requireNonNull(certificate);
        return CredentialsObject.fromSubjectDn(deviceId, certificate.getSubjectX500Principal(), notBefore, notAfter);
    }

    public static CredentialsObject fromSubjectDn(String deviceId, X500Principal subjectDn, Instant notBefore, Instant notAfter) {
        Objects.requireNonNull(subjectDn);
        String authId = subjectDn.getName("RFC2253");
        CredentialsObject result = new CredentialsObject(deviceId, authId, "x509-cert");
        JsonObject secret = CredentialsObject.emptySecret(notBefore, notAfter);
        result.addSecret(secret);
        return result;
    }
}

