/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class QueueHandler
extends ExtHandler {
    private final Deque<ExtLogRecord> buffer = new ArrayDeque<ExtLogRecord>();
    private int limit = 10;

    public QueueHandler() {
    }

    public QueueHandler(int limit) {
        if (limit < 1) {
            throw QueueHandler.badQueueLength();
        }
        this.limit = limit;
    }

    @Override
    public void publish(ExtLogRecord record) {
        if (this.isEnabled() && record != null) {
            this.doPublish(record);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isEnabled() && record != null) {
            this.doPublish(ExtLogRecord.wrap(record));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(ExtLogRecord record) {
        Deque<ExtLogRecord> deque = this.buffer;
        synchronized (deque) {
            if (this.isLoggable(record)) {
                if (this.isCallerCalculationRequired()) {
                    record.copyAll();
                } else {
                    record.disableCallerCalculation();
                    record.copyMdc();
                }
                if (this.buffer.size() == this.limit) {
                    this.buffer.removeFirst();
                }
                this.buffer.addLast(record);
            }
            this.publishToNestedHandlers(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLimit() {
        Deque<ExtLogRecord> deque = this.buffer;
        synchronized (deque) {
            return this.limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(int limit) {
        if (limit < 1) {
            throw QueueHandler.badQueueLength();
        }
        Deque<ExtLogRecord> deque = this.buffer;
        synchronized (deque) {
            this.limit = limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtLogRecord[] getQueue() {
        Deque<ExtLogRecord> deque = this.buffer;
        synchronized (deque) {
            return this.buffer.toArray(new ExtLogRecord[this.buffer.size()]);
        }
    }

    public String[] getQueueAsStrings() {
        ExtLogRecord[] queue = this.getQueue();
        int length = queue.length;
        String[] strings = new String[length];
        Formatter formatter = this.getFormatter();
        int i = 0;
        for (int j = 0; j < length; ++j) {
            try {
                String formatted = formatter.format(queue[j]);
                if (formatted.length() <= 0) continue;
                strings[i++] = this.getFormatter().format(queue[j]);
                continue;
            }
            catch (Exception ex) {
                this.reportError("Formatting error", ex, 5);
            }
        }
        return strings;
    }

    public void replay() {
        Handler[] handlers = this.getHandlers();
        if (handlers.length > 0) {
            for (ExtLogRecord record : this.getQueue()) {
                this.publishToNestedHandlers(record);
            }
        }
    }

    private static IllegalArgumentException badQueueLength() {
        return new IllegalArgumentException("Queue length must be at least 1");
    }
}

