/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Predicate;

public final class MultiSelectFirstWhileOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiSelectFirstWhileOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        ParameterValidation.nonNullNpe(subscriber, "subscriber");
        this.upstream.subscribe(new MultiSelectFirstWhileProcessor<T>(subscriber, this.predicate));
    }

    static final class MultiSelectFirstWhileProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;

        MultiSelectFirstWhileProcessor(MultiSubscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        @Override
        public void onItem(T t) {
            boolean pass;
            if (this.isDone()) {
                return;
            }
            try {
                pass = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            MultiSubscriber subscriber = this.downstream;
            if (!pass) {
                this.cancel();
                subscriber.onCompletion();
                return;
            }
            subscriber.onItem(t);
        }
    }
}

