/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerResponse;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.observability.HttpRequest;

abstract class Http2ServerStream
extends VertxHttp2Stream<Http2ServerConnection> {
    protected final Http2Headers headers;
    protected final HttpMethod method;
    protected final String uri;
    protected final String host;
    protected final Http2ServerResponse response;
    private Object metric;
    private boolean requestEnded;
    private boolean responseEnded;

    Http2ServerStream(Http2ServerConnection conn, ContextInternal context, String contentEncoding, HttpMethod method, String uri) {
        super(conn, context);
        this.headers = null;
        this.method = method;
        this.uri = uri;
        this.host = null;
        this.response = new Http2ServerResponse(conn, this, true, contentEncoding, null);
    }

    Http2ServerStream(Http2ServerConnection conn, ContextInternal context, Http2Headers headers, String contentEncoding, String serverOrigin) {
        super(conn, context);
        String host;
        String string = host = headers.get(":authority") != null ? ((CharSequence)headers.get(":authority")).toString() : null;
        if (host == null) {
            int idx = serverOrigin.indexOf("://");
            host = serverOrigin.substring(idx + 3);
        }
        this.headers = headers;
        this.host = host;
        this.uri = headers.get(":path") != null ? ((CharSequence)headers.get(":path")).toString() : null;
        this.method = headers.get(":method") != null ? HttpMethod.valueOf(((CharSequence)headers.get(":method")).toString()) : null;
        this.response = new Http2ServerResponse(conn, this, false, contentEncoding, host);
    }

    void registerMetrics() {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            this.metric = this.response.isPush() ? metrics.responsePushed(((Http2ServerConnection)this.conn).metric(), this.method(), this.uri, this.response) : metrics.requestBegin(((Http2ServerConnection)this.conn).metric(), (HttpRequest)((Object)this));
        }
    }

    @Override
    void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
        if (streamPriority != null) {
            this.priority(streamPriority);
        }
        this.registerMetrics();
        CharSequence value = (CharSequence)headers.get(HttpHeaderNames.EXPECT);
        if (((Http2ServerConnection)this.conn).options.isHandle100ContinueAutomatically() && (value != null && HttpHeaderValues.CONTINUE.equals(value) || headers.contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE))) {
            this.response.writeContinue();
        }
        this.dispatch(((Http2ServerConnection)this.conn).requestHandler);
    }

    @Override
    void onEnd(MultiMap trailers) {
        HttpServerMetrics metrics;
        this.requestEnded = true;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.requestEnd(this.metric, (HttpRequest)((Object)this), this.bytesRead());
        }
        super.onEnd(trailers);
    }

    abstract void dispatch(Handler<HttpServerRequest> var1);

    @Override
    void doWriteHeaders(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && !end && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.responseBegin(this.metric, this.response);
        }
        super.doWriteHeaders(headers, end, handler);
    }

    @Override
    void handleWritabilityChanged(boolean writable) {
        if (this.response != null) {
            this.response.handlerWritabilityChanged(writable);
        }
    }

    public HttpMethod method() {
        return this.method;
    }

    @Override
    protected void endWritten() {
        HttpServerMetrics metrics;
        this.responseEnded = true;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.responseEnd(this.metric, this.response, this.bytesWritten());
        }
    }

    @Override
    void handleClose(HttpClosedException ex) {
        HttpServerMetrics metrics;
        super.handleClose(ex);
        if (!(!Metrics.METRICS_ENABLED || (metrics = ((Http2ServerConnection)this.conn).metrics()) == null || this.requestEnded && this.responseEnded)) {
            metrics.requestReset(this.metric);
        }
    }

    public Object metric() {
        return this.metric;
    }

    HttpServerRequest routed(String route) {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null && !this.responseEnded) {
            metrics.requestRouted(this.metric, route);
        }
        return null;
    }
}

