/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConfigurationException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class RuntimeConfigSource
implements ConfigSourceProvider {
    private final String configSourceClassName;

    public RuntimeConfigSource(String configSourceClassName) {
        this.configSourceClassName = configSourceClassName;
    }

    @Override
    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        try {
            Class<?> configSourceClass = forClassLoader.loadClass(this.configSourceClassName);
            ConfigSource configSource = (ConfigSource)configSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return Collections.singleton(configSource);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException(e);
        }
    }
}

