/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ResourceLimitsPeriod {
    static final ResourceLimitsPeriod DEFAULT_PERIOD = new ResourceLimitsPeriod(PeriodMode.monthly);
    private final PeriodMode mode;
    @JsonProperty(value="no-of-days")
    private int noOfDays;

    public ResourceLimitsPeriod(@JsonProperty(value="mode", required=true) PeriodMode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    @JsonProperty(value="mode")
    public final PeriodMode getMode() {
        return this.mode;
    }

    public final int getNoOfDays() {
        return this.noOfDays;
    }

    public final ResourceLimitsPeriod setNoOfDays(int noOfDays) {
        if (noOfDays < 0) {
            throw new IllegalArgumentException("Number of days property must be  set to value >= 0");
        }
        this.noOfDays = noOfDays;
        return this;
    }

    public final Duration getElapsedAccountingPeriodDuration(Instant start, Instant end) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        if (end.isBefore(start)) {
            return Duration.ZERO;
        }
        ZonedDateTime targetZonedDateTime = ZonedDateTime.ofInstant(end, ZoneOffset.UTC);
        ZonedDateTime beginningOfMostRecentAccountingPeriod = this.getBeginningOfMostRecentAccountingPeriod(ZonedDateTime.ofInstant(start, ZoneOffset.UTC), targetZonedDateTime, this.mode, this.noOfDays);
        return Duration.between(beginningOfMostRecentAccountingPeriod, targetZonedDateTime);
    }

    private ZonedDateTime getBeginningOfMostRecentAccountingPeriod(ZonedDateTime effectiveSince, ZonedDateTime targetDateTime, PeriodMode periodMode, long periodLength) {
        switch (periodMode) {
            case monthly: {
                YearMonth targetYearMonth = YearMonth.from(targetDateTime);
                if (targetYearMonth.equals(YearMonth.from(effectiveSince))) {
                    return effectiveSince;
                }
                return ZonedDateTime.of(targetYearMonth.getYear(), targetYearMonth.getMonthValue(), 1, 0, 0, 0, 0, ZoneOffset.UTC);
            }
            case days: {
                Duration overall = Duration.between(effectiveSince, targetDateTime);
                Duration accountingPeriodLength = Duration.ofDays(periodLength);
                if (overall.compareTo(accountingPeriodLength) <= 0) {
                    return effectiveSince;
                }
                long totalPeriodsElapsed = overall.toDays() / periodLength;
                return effectiveSince.plus(accountingPeriodLength.multipliedBy(totalPeriodsElapsed));
            }
        }
        return targetDateTime;
    }

    public static enum PeriodMode {
        days,
        monthly,
        unknown;

    }
}

