/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.quarkus.runtime.configuration.ConfigSourceFactoryProvider;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.DotEnvConfigSourceProvider;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.NameIterator;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class ConfigUtils {
    static final String UUID_KEY = "quarkus.uuid";

    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, true, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean addDiscovered, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, false, addDiscovered, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean bootstrap, boolean addDiscovered, LaunchMode launchMode) {
        SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
        if (launchMode.isDevOrTest() && (runTime || bootstrap)) {
            builder.withSources(new RuntimeOverrideConfigSource(Thread.currentThread().getContextClassLoader()));
        }
        if (runTime || bootstrap) {
            builder.withDefaultValue(UUID_KEY, UUID.randomUUID().toString());
        }
        if (addDiscovered) {
            builder.addDiscoveredSources();
        }
        return builder;
    }

    public static SmallRyeConfigBuilder emptyConfigBuilder() {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        final LaunchMode launchMode = ProfileManager.getLaunchMode();
        builder.withDefaultValue(launchMode.getProfileKey(), launchMode.getDefaultProfile());
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(Map.of("smallrye.config.profile", launchMode.getProfileKey()));
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3190);
            }
        });
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                final HashMap<String, String> relocations = new HashMap<String, String>();
                relocations.put("smallrye.config.locations", "quarkus.config.locations");
                relocations.put("smallrye.config.profile.parent", "quarkus.config.profile.parent");
                return new RelocateConfigSourceInterceptor(new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        String relocate = (String)relocations.get(name);
                        if (relocate != null) {
                            return relocate;
                        }
                        if (name.startsWith("%") && name.endsWith("smallrye.config.locations")) {
                            NameIterator ni = new NameIterator(name);
                            return ni.getNextSegment() + ".quarkus.config.locations";
                        }
                        if (name.startsWith("%") && name.endsWith("smallrye.config.profile.parent")) {
                            NameIterator ni = new NameIterator(name);
                            return ni.getNextSegment() + ".quarkus.config.profile.parent";
                        }
                        return name;
                    }
                });
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3195);
            }
        });
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<String, String> fallbacks = new HashMap<String, String>();
                fallbacks.put("quarkus.profile", "smallrye.config.profile");
                fallbacks.put("quarkus.config.locations", "smallrye.config.locations");
                fallbacks.put("quarkus.config.profile.parent", "smallrye.config.profile.parent");
                return new FallbackConfigSourceInterceptor(fallbacks);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        });
        builder.withMappingIgnore("quarkus.**");
        builder.forClassLoader(Thread.currentThread().getContextClassLoader()).addDiscoveredConverters().addDefaultInterceptors().addDiscoveredInterceptors().addDiscoveredSecretKeysHandlers().addDefaultSources().withSources(new ApplicationPropertiesConfigSourceLoader.InFileSystem()).withSources(new ApplicationPropertiesConfigSourceLoader.InClassPath()).withSources(new DotEnvConfigSourceProvider());
        return builder;
    }

    public static SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder, List<String> configBuildersNames) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ArrayList<ConfigBuilder> configBuilders = new ArrayList<ConfigBuilder>();
            for (String configBuilderName : configBuildersNames) {
                Class<?> configBuilderClass = contextClassLoader.loadClass(configBuilderName);
                configBuilders.add((ConfigBuilder)configBuilderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            configBuilders.sort(ConfigBuilderComparator.INSTANCE);
            for (ConfigBuilder configBuilder : configBuilders) {
                builder = configBuilder.configBuilder(builder);
                if (builder != null) continue;
                throw new ConfigurationException(configBuilder.getClass().getName() + " returned a null builder");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException(e);
        }
        return builder;
    }

    public static void addSourceProvider(SmallRyeConfigBuilder builder, ConfigSourceProvider provider) {
        Iterable<ConfigSource> sources = provider.getConfigSources(Thread.currentThread().getContextClassLoader());
        for (ConfigSource source : sources) {
            builder.withSources(source);
        }
    }

    public static void addSourceProviders(SmallRyeConfigBuilder builder, Collection<ConfigSourceProvider> providers) {
        for (ConfigSourceProvider provider : providers) {
            ConfigUtils.addSourceProvider(builder, provider);
        }
    }

    public static void addSourceFactoryProvider(SmallRyeConfigBuilder builder, ConfigSourceFactoryProvider provider) {
        builder.withSources(provider.getConfigSourceFactory(Thread.currentThread().getContextClassLoader()));
    }

    public static List<String> getProfiles() {
        return ConfigProvider.getConfig().unwrap(SmallRyeConfig.class).getProfiles();
    }

    public static boolean isProfileActive(String profile) {
        return ConfigUtils.getProfiles().contains(profile);
    }

    public static boolean isPropertyPresent(String propertyName) {
        return ConfigProvider.getConfig().unwrap(SmallRyeConfig.class).isPropertyPresent(propertyName);
    }

    public static boolean isAnyPropertyPresent(Collection<String> propertyNames) {
        for (String propertyName : propertyNames) {
            if (!ConfigUtils.isPropertyPresent(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> getFirstOptionalValue(List<String> propertyNames, Class<T> propertyType) {
        Config config = ConfigProvider.getConfig();
        for (String propertyName : propertyNames) {
            Optional<T> value = config.getOptionalValue(propertyName, propertyType);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    private static class ConfigBuilderComparator
    implements Comparator<ConfigBuilder> {
        private static final ConfigBuilderComparator INSTANCE = new ConfigBuilderComparator();

        private ConfigBuilderComparator() {
        }

        @Override
        public int compare(ConfigBuilder o1, ConfigBuilder o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    }
}

