/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigProducerUtil;
import io.smallrye.config.inject.SecuritySupport;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class ConfigProducer {
    @Produces
    protected SmallRyeConfig getConfig() {
        return ConfigProvider.getConfig(SecuritySupport.getContextClassLoader()).unwrap(SmallRyeConfig.class);
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected String produceStringConfigProperty(InjectionPoint ip) {
        return (String)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Long getLongValue(InjectionPoint ip) {
        return (Long)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Integer getIntegerValue(InjectionPoint ip) {
        return (Integer)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Float produceFloatConfigProperty(InjectionPoint ip) {
        return (Float)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Double produceDoubleConfigProperty(InjectionPoint ip) {
        return (Double)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Boolean produceBooleanConfigProperty(InjectionPoint ip) {
        return (Boolean)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Short produceShortConfigProperty(InjectionPoint ip) {
        return (Short)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Byte produceByteConfigProperty(InjectionPoint ip) {
        return (Byte)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected Character produceCharacterConfigProperty(InjectionPoint ip) {
        return (Character)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected <T> Optional<T> produceOptionalConfigProperty(InjectionPoint ip) {
        return (Optional)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected <T> Supplier<T> produceSupplierConfigProperty(InjectionPoint ip) {
        return () -> ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected <T> Set<T> producesSetConfigProperty(InjectionPoint ip) {
        return (Set)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected <T> List<T> producesListConfigProperty(InjectionPoint ip) {
        return (List)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected <K, V> Map<K, V> producesMapConfigProperty(InjectionPoint ip) {
        return (Map)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected OptionalInt produceOptionalIntConfigProperty(InjectionPoint ip) {
        return (OptionalInt)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected OptionalLong produceOptionalLongConfigProperty(InjectionPoint ip) {
        return (OptionalLong)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected OptionalDouble produceOptionalDoubleConfigProperty(InjectionPoint ip) {
        return (OptionalDouble)ConfigProducerUtil.getValue(ip, this.getConfig());
    }

    @Dependent
    @Produces
    @ConfigProperty
    protected ConfigValue produceConfigValue(InjectionPoint ip) {
        return ConfigProducerUtil.getConfigValue(ip, this.getConfig());
    }

    public static boolean isClassHandledByConfigProducer(Type requiredType) {
        return requiredType == String.class || requiredType == Boolean.class || requiredType == Boolean.TYPE || requiredType == Integer.class || requiredType == Integer.TYPE || requiredType == Long.class || requiredType == Long.TYPE || requiredType == Float.class || requiredType == Float.TYPE || requiredType == Double.class || requiredType == Double.TYPE || requiredType == Short.class || requiredType == Short.TYPE || requiredType == Byte.class || requiredType == Byte.TYPE || requiredType == Character.class || requiredType == Character.TYPE || requiredType == OptionalInt.class || requiredType == OptionalLong.class || requiredType == OptionalDouble.class || requiredType == Supplier.class || requiredType == ConfigValue.class || requiredType == org.eclipse.microprofile.config.ConfigValue.class;
    }
}

