package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.NamespaceImportedMemberMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.NamespaceImportedMemberQuerySpecification;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.namespaceImportedMember pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link NamespaceImportedMemberMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (self.importMembers(elementImport.importedElement-{@literal >}asSet()-{@literal >}union(packageImport.importedPackage-{@literal >}collect(p | p.visibleMembers()))-{@literal >}asSet()))
 * 
 * {@literal @}Surrogate(feature = "importedMember")
 * pattern namespaceImportedMember(namespace: Namespace, importedMember: PackageableElement) {
 * 	Namespace.elementImport(namespace, elementImport);
 * 	ElementImport.importedElement(elementImport, importedMember);
 * } or {
 * 	Namespace.packageImport(namespace, packageImport);
 * 	PackageImport.importedPackage(packageImport, importedPackage);
 * 	find packageVisibleMember(importedPackage, importedMember);
 * }
 * </pre></code>
 * 
 * @see NamespaceImportedMemberMatch
 * @see NamespaceImportedMemberProcessor
 * @see NamespaceImportedMemberQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class NamespaceImportedMemberMatcher extends BaseMatcher<NamespaceImportedMemberMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static NamespaceImportedMemberMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    NamespaceImportedMemberMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new NamespaceImportedMemberMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_NAMESPACE = 0;
  
  private final static int POSITION_IMPORTEDMEMBER = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(NamespaceImportedMemberMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public NamespaceImportedMemberMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public NamespaceImportedMemberMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @return matches represented as a NamespaceImportedMemberMatch object.
   * 
   */
  public Collection<NamespaceImportedMemberMatch> getAllMatches(final Namespace pNamespace, final PackageableElement pImportedMember) {
    return rawGetAllMatches(new Object[]{pNamespace, pImportedMember});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @return a match represented as a NamespaceImportedMemberMatch object, or null if no match is found.
   * 
   */
  public NamespaceImportedMemberMatch getOneArbitraryMatch(final Namespace pNamespace, final PackageableElement pImportedMember) {
    return rawGetOneArbitraryMatch(new Object[]{pNamespace, pImportedMember});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Namespace pNamespace, final PackageableElement pImportedMember) {
    return rawHasMatch(new Object[]{pNamespace, pImportedMember});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Namespace pNamespace, final PackageableElement pImportedMember) {
    return rawCountMatches(new Object[]{pNamespace, pImportedMember});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Namespace pNamespace, final PackageableElement pImportedMember, final IMatchProcessor<? super NamespaceImportedMemberMatch> processor) {
    rawForEachMatch(new Object[]{pNamespace, pImportedMember}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Namespace pNamespace, final PackageableElement pImportedMember, final IMatchProcessor<? super NamespaceImportedMemberMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pNamespace, pImportedMember}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public NamespaceImportedMemberMatch newMatch(final Namespace pNamespace, final PackageableElement pImportedMember) {
    return NamespaceImportedMemberMatch.newMatch(pNamespace, pImportedMember);
  }
  
  /**
   * Retrieve the set of values that occur in matches for namespace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Namespace> rawAccumulateAllValuesOfnamespace(final Object[] parameters) {
    Set<Namespace> results = new HashSet<Namespace>();
    rawAccumulateAllValues(POSITION_NAMESPACE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for namespace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Namespace> getAllValuesOfnamespace() {
    return rawAccumulateAllValuesOfnamespace(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for namespace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Namespace> getAllValuesOfnamespace(final NamespaceImportedMemberMatch partialMatch) {
    return rawAccumulateAllValuesOfnamespace(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for namespace.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Namespace> getAllValuesOfnamespace(final PackageableElement pImportedMember) {
    return rawAccumulateAllValuesOfnamespace(new Object[]{
    null, 
    pImportedMember
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for importedMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<PackageableElement> rawAccumulateAllValuesOfimportedMember(final Object[] parameters) {
    Set<PackageableElement> results = new HashSet<PackageableElement>();
    rawAccumulateAllValues(POSITION_IMPORTEDMEMBER, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for importedMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfimportedMember() {
    return rawAccumulateAllValuesOfimportedMember(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for importedMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfimportedMember(final NamespaceImportedMemberMatch partialMatch) {
    return rawAccumulateAllValuesOfimportedMember(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for importedMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfimportedMember(final Namespace pNamespace) {
    return rawAccumulateAllValuesOfimportedMember(new Object[]{
    pNamespace, 
    null
    });
  }
  
  @Override
  protected NamespaceImportedMemberMatch tupleToMatch(final Tuple t) {
    try {
    	return NamespaceImportedMemberMatch.newMatch((org.eclipse.uml2.uml.Namespace) t.get(POSITION_NAMESPACE), (org.eclipse.uml2.uml.PackageableElement) t.get(POSITION_IMPORTEDMEMBER));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NamespaceImportedMemberMatch arrayToMatch(final Object[] match) {
    try {
    	return NamespaceImportedMemberMatch.newMatch((org.eclipse.uml2.uml.Namespace) match[POSITION_NAMESPACE], (org.eclipse.uml2.uml.PackageableElement) match[POSITION_IMPORTEDMEMBER]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected NamespaceImportedMemberMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return NamespaceImportedMemberMatch.newMutableMatch((org.eclipse.uml2.uml.Namespace) match[POSITION_NAMESPACE], (org.eclipse.uml2.uml.PackageableElement) match[POSITION_IMPORTEDMEMBER]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<NamespaceImportedMemberMatcher> querySpecification() throws IncQueryException {
    return NamespaceImportedMemberQuerySpecification.instance();
  }
}
