/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime.annotation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.incquery.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.ListValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.patternlanguage.validation.IIssueCallback;

public class ConstraintAnnotationValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.incquery.livevalidation.";
    public static final String SEVERITY_ISSUE_CODE = "org.eclipse.incquery.livevalidation.severity";
    @Inject
    private AnnotationExpressionValidator expressionValidator;

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        Pattern pattern = (Pattern)annotation.eContainer();
        this.validateMessage(annotation, validator, pattern);
        this.validateSeverity(annotation, validator);
        List<String> keyList = this.validateKeys(annotation, validator, pattern);
        this.validateSymmetry(annotation, validator, pattern, keyList);
    }

    private void validateSymmetry(Annotation annotation, IIssueCallback validator, Pattern pattern, List<String> keyList) {
        Collection symmetricLists = CorePatternLanguageHelper.getAnnotationParameters((Annotation)annotation, (String)"symmetric");
        for (ValueReference symmetry : symmetricLists) {
            Iterable<String> symmetryParameters = this.transformStringList(symmetry);
            ArrayList symmetricKeys = Lists.newArrayList();
            ArrayList symmetricProperties = Lists.newArrayList();
            ArrayList invalidSymmetries = Lists.newArrayList();
            for (String key : symmetryParameters) {
                Variable parameterByName = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)key);
                if (keyList.contains(key)) {
                    symmetricKeys.add(key);
                    continue;
                }
                if (parameterByName != null) {
                    symmetricProperties.add(key);
                    continue;
                }
                invalidSymmetries.add(key);
            }
            if (!invalidSymmetries.isEmpty()) {
                validator.error("Symmetric parameters " + ((Object)invalidSymmetries).toString() + " are not pattern parameters!", (EObject)symmetry, null, SEVERITY_ISSUE_CODE, new String[0]);
            }
            if (symmetricKeys.isEmpty() || symmetricProperties.isEmpty()) continue;
            validator.error("Symmetric parameters " + symmetryParameters.toString() + " contains both key and non-key parameters!", (EObject)symmetry, null, SEVERITY_ISSUE_CODE, new String[0]);
        }
    }

    private List<String> validateKeys(Annotation annotation, IIssueCallback validator, final Pattern pattern) {
        ArrayList keyList = Lists.newArrayList();
        ValueReference locationRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"location");
        ValueReference keyRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"key");
        if (locationRef != null && keyRef != null) {
            validator.error("Cannot use both location and key!", (EObject)keyRef, null, SEVERITY_ISSUE_CODE, new String[0]);
        }
        if (locationRef instanceof VariableValue) {
            String locationVarName = ((VariableValue)locationRef).getValue().getVariable().getName();
            keyList.add(locationVarName);
        }
        if (keyRef instanceof ListValue) {
            Iterable<String> keyParamList = this.transformStringList(keyRef);
            ArrayList invalidKeys = Lists.newArrayList();
            for (String key : keyParamList) {
                Variable parameterByName = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)key);
                if (parameterByName == null) {
                    invalidKeys.add(key);
                    continue;
                }
                keyList.add(key);
            }
            if (!invalidKeys.isEmpty()) {
                validator.error("Keys " + ((Object)invalidKeys).toString() + " are not pattern parameters!", (EObject)keyRef, null, SEVERITY_ISSUE_CODE, new String[0]);
            }
        }
        if (keyList.isEmpty()) {
            validator.error("No key defined!", (EObject)keyRef, null, SEVERITY_ISSUE_CODE, new String[0]);
        } else {
            boolean atLeastOneEClassKey = Iterables.any((Iterable)keyList, (Predicate)new Predicate<String>(){

                public boolean apply(String key) {
                    Variable firstKeyParameter = CorePatternLanguageHelper.getParameterByName((Pattern)pattern, (String)key);
                    Type sourceType = firstKeyParameter.getType();
                    return sourceType instanceof ClassType && ((ClassType)sourceType).getClassname() instanceof EClass;
                }
            });
            if (!atLeastOneEClassKey) {
                validator.warning("At least one key should be EClass to make location possible!", (EObject)keyRef, null, SEVERITY_ISSUE_CODE, new String[0]);
            }
        }
        return keyList;
    }

    private Iterable<String> transformStringList(ValueReference listParameter) {
        EList listValues = ((ListValue)listParameter).getValues();
        Iterable keyStringValues = Iterables.filter((Iterable)listValues, StringValue.class);
        Iterable keyParamList = Iterables.transform((Iterable)keyStringValues, (Function)new Function<StringValue, String>(){

            public String apply(StringValue ref) {
                return ref.getValue();
            }
        });
        return keyParamList;
    }

    private void validateSeverity(Annotation annotation, IIssueCallback validator) {
        String value;
        ValueReference severityRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"severity");
        if (severityRef instanceof StringValue && !(value = ((StringValue)severityRef).getValue()).equals("error") && !value.equals("warning") && !value.equals("info")) {
            validator.error("Severity must be either 'error','warning' or 'info'.", (EObject)severityRef, null, SEVERITY_ISSUE_CODE, new String[0]);
        }
    }

    private void validateMessage(Annotation annotation, IIssueCallback validator, Pattern pattern) {
        ValueReference messageRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"message");
        if (messageRef instanceof StringValue) {
            String value = ((StringValue)messageRef).getValue();
            this.expressionValidator.validateStringExpression(value, pattern, messageRef, validator);
        }
    }
}

