/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.patternlanguage.emf.jvmmodel;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrer;
import org.eclipse.incquery.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.patternlanguage.emf.specification.GenericQuerySpecification;
import org.eclipse.incquery.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.incquery.patternlanguage.emf.specification.XBaseEvaluator;
import org.eclipse.incquery.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.emf.util.IErrorFeedback;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedQuerySpecification;
import org.eclipse.incquery.runtime.context.EMFPatternMatcherContext;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.psystem.IValueProvider;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeBinary;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/**
 * {@link IQuerySpecification} implementation inferrer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternQuerySpecificationClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private ITypeProvider _iTypeProvider;
  
  @Inject
  @Extension
  private TypeReferences types;
  
  @Inject
  private IErrorFeedback feedback;
  
  @Inject
  private Logger logger;
  
  /**
   * Infers the {@link IQuerySpecification} implementation class from {@link Pattern}.
   */
  public JvmDeclaredType inferQuerySpecificationClass(final Pattern pattern, final boolean isPrelinkingPhase, final String querySpecificationPackageName, final JvmTypeReference matcherClassRef) {
    String _querySpecificationClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        it.setPackageName(querySpecificationPackageName);
        CharSequence _javadocQuerySpecificationClass = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationClass(pattern);
        String _string = _javadocQuerySpecificationClass.toString();
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
        it.setFinal(true);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _cloneWithProxies = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.cloneWithProxies(matcherClassRef);
        JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, BaseGeneratedQuerySpecification.class, _cloneWithProxies);
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
      }
    };
    final JvmGenericType querySpecificationClass = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationClassName, _function);
    return querySpecificationClass;
  }
  
  public void initializePublicSpecification(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmTypeReference matcherClassRef, final JvmTypeReference matchClassRef, final SpecificationBuilder builder) {
    this.inferQuerySpecificationMethods(querySpecificationClass, pattern, matcherClassRef, matchClassRef, true, builder);
    this.inferQuerySpecificationInnerClasses(querySpecificationClass, pattern, true);
    this.inferExpressions(querySpecificationClass, pattern);
  }
  
  public void initializePrivateSpecification(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmTypeReference matcherClassRef, final JvmTypeReference matchClassRef, final SpecificationBuilder builder) {
    querySpecificationClass.setVisibility(JvmVisibility.DEFAULT);
    this.inferQuerySpecificationMethods(querySpecificationClass, pattern, matcherClassRef, matchClassRef, false, builder);
    this.inferQuerySpecificationInnerClasses(querySpecificationClass, pattern, false);
    this.inferExpressions(querySpecificationClass, pattern);
  }
  
  /**
   * Infers methods for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationMethods(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmTypeReference matcherClassRef, final JvmTypeReference matchClassRef, final boolean isPublic, final SpecificationBuilder builder) {
    boolean _xblockexpression = false;
    {
      final EMFPatternMatcherContext context = new EMFPatternMatcherContext(this.logger);
      EList<JvmMember> _members = querySpecificationClass.getMembers();
      JvmParameterizedTypeReference _createTypeRef = this.types.createTypeRef(querySpecificationClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          it.setStatic(true);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef);
          CharSequence _javadocQuerySpecificationInstanceMethod = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationInstanceMethod(pattern);
          String _string = _javadocQuerySpecificationInstanceMethod.toString();
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return ");
              String _querySpecificationHolderClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationHolderClassName(pattern);
              _builder.append(_querySpecificationHolderClassName, "");
              _builder.append(".INSTANCE;");
              _builder.newLineIfNotEmpty();
              it.append(_builder);
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "instance", _createTypeRef, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = querySpecificationClass.getMembers();
      JvmTypeReference _cloneWithProxies = this._eMFJvmTypesBuilder.cloneWithProxies(matcherClassRef);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PROTECTED);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(querySpecificationClass, Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryEngine.class);
          JvmFormalParameter _parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(querySpecificationClass, "engine", _newTypeRef);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _newTypeRef_1 = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef_1);
          Procedure1<ITreeAppendable> _xifexpression = null;
          if (isPublic) {
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                String _matcherClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
                _builder.append(_matcherClassName, "");
                _builder.append(".on(engine);");
                it.append(_builder);
              }
            };
            _xifexpression = _function;
          } else {
            final Procedure1<ITreeAppendable> _function_1 = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("throw new ");
                it.append(_builder);
                PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, UnsupportedOperationException.class);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("();");
                it.append(_builder_1);
              }
            };
            _xifexpression = _function_1;
          }
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _xifexpression);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "instantiate", _cloneWithProxies, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      EList<JvmMember> _members_2 = querySpecificationClass.getMembers();
      JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(querySpecificationClass, Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return \"");
              String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
              _builder.append(_fullyQualifiedName, "");
              _builder.append("\";");
              _builder.newLineIfNotEmpty();
              it.append(_builder);
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "getFullyQualifiedName", _newTypeRef, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
      EList<JvmMember> _members_3 = querySpecificationClass.getMembers();
      JvmTypeReference _newTypeRef_1 = this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
      JvmTypeReference _newTypeRef_2 = this._eMFJvmTypesBuilder.newTypeRef(pattern, List.class, _newTypeRef_1);
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(querySpecificationClass, Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return ");
              it.append(_builder);
              PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, Arrays.class);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append(".asList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable param : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder_1.appendImmediate(",", "");
                  }
                  _builder_1.append("\"");
                  String _name = param.getName();
                  _builder_1.append(_name, "");
                  _builder_1.append("\"");
                }
              }
              _builder_1.append(");");
              it.append(_builder_1);
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "getParameterNames", _newTypeRef_2, _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
      EList<JvmMember> _members_4 = querySpecificationClass.getMembers();
      JvmTypeReference _newTypeRef_3 = this._eMFJvmTypesBuilder.newTypeRef(pattern, PParameter.class);
      JvmTypeReference _newTypeRef_4 = this._eMFJvmTypesBuilder.newTypeRef(pattern, List.class, _newTypeRef_3);
      final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(querySpecificationClass, Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return ");
              it.append(_builder);
              PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, Arrays.class);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append(".asList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable param : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder_1.appendImmediate(",", "");
                  }
                  CharSequence _parameterInstantiation = PatternQuerySpecificationClassInferrer.this.parameterInstantiation(param);
                  _builder_1.append(_parameterInstantiation, "");
                }
              }
              _builder_1.append(");");
              it.append(_builder_1);
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_4 = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "getParameters", _newTypeRef_4, _function_4);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_4);
      EList<JvmMember> _members_5 = querySpecificationClass.getMembers();
      JvmTypeReference _xifexpression = null;
      if (isPublic) {
        _xifexpression = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassRef);
      } else {
        _xifexpression = this._eMFJvmTypesBuilder.newTypeRef(pattern, IPatternMatch.class);
      }
      final Procedure1<JvmOperation> _function_5 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(querySpecificationClass, Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              if (isPublic) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                String _matchClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                _builder.append(_matchClassName, "");
                _builder.append(".newEmptyMatch();");
                it.append(_builder);
              } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("throw new ");
                it.append(_builder_1);
                PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, UnsupportedOperationException.class);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("();");
                it.append(_builder_2);
              }
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_5 = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "newEmptyMatch", _xifexpression, _function_5);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_5, _method_5);
      EList<JvmMember> _members_6 = querySpecificationClass.getMembers();
      JvmTypeReference _xifexpression_1 = null;
      if (isPublic) {
        _xifexpression_1 = this._eMFJvmTypesBuilder.cloneWithProxies(matchClassRef);
      } else {
        _xifexpression_1 = this._eMFJvmTypesBuilder.newTypeRef(pattern, IPatternMatch.class);
      }
      final Procedure1<JvmOperation> _function_6 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(querySpecificationClass, Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
          JvmTypeReference _addArrayTypeDimension = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.addArrayTypeDimension(_newTypeRef);
          JvmFormalParameter _parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(querySpecificationClass, "parameters", _addArrayTypeDimension);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          it.setVarArgs(true);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              if (isPublic) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                String _matchClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                _builder.append(_matchClassName, "");
                _builder.append(".newMatch(");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable p : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    _builder.append("(");
                    JvmTypeReference _calculateType = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(p);
                    String _qualifiedName = _calculateType.getQualifiedName();
                    _builder.append(_qualifiedName, "");
                    _builder.append(") parameters[");
                    EList<Variable> _parameters_1 = pattern.getParameters();
                    int _indexOf = _parameters_1.indexOf(p);
                    _builder.append(_indexOf, "");
                    _builder.append("]");
                  }
                }
                _builder.append(");");
                it.append(_builder);
              } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("throw new ");
                it.append(_builder_1);
                PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, UnsupportedOperationException.class);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("();");
                it.append(_builder_2);
              }
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_6 = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "newMatch", _xifexpression_1, _function_6);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_6, _method_6);
      EList<JvmMember> _members_7 = querySpecificationClass.getMembers();
      JvmTypeReference _newTypeRef_5 = this._eMFJvmTypesBuilder.newTypeRef(pattern, PBody.class);
      JvmTypeReference _newTypeRef_6 = this._eMFJvmTypesBuilder.newTypeRef(pattern, Set.class, _newTypeRef_5);
      final Procedure1<JvmOperation> _function_7 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(querySpecificationClass, Override.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable appender) {
              IQuerySpecification<?> genericSpecification = null;
              try {
                IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> _orCreateSpecification = builder.getOrCreateSpecification(pattern, true);
                genericSpecification = _orCreateSpecification;
                boolean _or = false;
                boolean _equals = Objects.equal(genericSpecification, null);
                if (_equals) {
                  _or = true;
                } else {
                  PQuery.PQueryStatus _status = genericSpecification.getStatus();
                  boolean _equals_1 = Objects.equal(_status, PQuery.PQueryStatus.ERROR);
                  _or = _equals_1;
                }
                if (_or) {
                  PatternQuerySpecificationClassInferrer.this.feedback.reportError(pattern, "Error building generic query specification", 
                    EMFPatternLanguageJvmModelInferrer.SPECIFICATION_BUILDER_CODE, Severity.ERROR, 
                    IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
                }
              } catch (final Throwable _t) {
                if (_t instanceof Exception) {
                  final Exception e = (Exception)_t;
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("addError(new ");
                  appender.append(_builder);
                  PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, PProblem.class);
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("(\"Inconsistent pattern definition threw exception ");
                  Class<? extends Exception> _class = e.getClass();
                  String _simpleName = _class.getSimpleName();
                  _builder_1.append(_simpleName, "");
                  _builder_1.append("  with message: ");
                  String _message = e.getMessage();
                  String _escapeToQuotedString = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.escapeToQuotedString(_message);
                  _builder_1.append(_escapeToQuotedString, "");
                  _builder_1.append("\"));");
                  appender.append(_builder_1);
                  PatternQuerySpecificationClassInferrer.this.logger.warn("Error while building PBodies", e);
                  return;
                } else {
                  throw Exceptions.sneakyThrow(_t);
                }
              }
              boolean _notEquals = (!Objects.equal(genericSpecification, null));
              if (_notEquals) {
                PatternQuerySpecificationClassInferrer.this.inferBodies(appender, pattern, genericSpecification, context);
                PatternQuerySpecificationClassInferrer.this.inferAnnotations(appender, pattern, genericSpecification);
                List<PProblem> _pProblems = genericSpecification.getPProblems();
                final Procedure1<PProblem> _function = new Procedure1<PProblem>() {
                  public void apply(final PProblem it) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("addError(new ");
                    appender.append(_builder);
                    PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, PProblem.class);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("(\"");
                    String _shortMessage = it.getShortMessage();
                    String _escapeToQuotedString = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.escapeToQuotedString(_shortMessage);
                    _builder_1.append(_escapeToQuotedString, "");
                    _builder_1.append("\"));");
                    appender.append(_builder_1);
                  }
                };
                IterableExtensions.<PProblem>forEach(_pProblems, _function);
              } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("addError(new ");
                appender.append(_builder_2);
                PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, PProblem.class);
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("(\"Could not initialize query specification from the pattern definition\"));");
                appender.append(_builder_3);
              }
              StringConcatenation _builder_4 = new StringConcatenation();
              _builder_4.append("return bodies;");
              appender.append(_builder_4);
            }
          };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_7 = this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "doGetContainedBodies", _newTypeRef_6, _function_7);
      _xblockexpression = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_7, _method_7);
    }
    return _xblockexpression;
  }
  
  public void inferBodies(final ITreeAppendable appender, final Pattern pattern, final IQuerySpecification<?> genericSpecification, final EMFPatternMatcherContext context) {
    JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, PBody.class);
    this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, Set.class, _newTypeRef);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    _builder.append("bodies = ");
    appender.append(_builder);
    this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, Sets.class);
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append(".newLinkedHashSet();");
    appender.append(_builder_1);
    appender.newLine();
    PDisjunction _disjunctBodies = genericSpecification.getDisjunctBodies();
    Set<PBody> _bodies = _disjunctBodies.getBodies();
    for (final PBody pBody : _bodies) {
      {
        appender.increaseIndentation();
        appender.append("{");
        appender.newLine();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("PBody body = new PBody(this);");
        appender.append(_builder_2);
        appender.newLine();
        Set<PVariable> _uniqueVariables = pBody.getUniqueVariables();
        for (final PVariable variable : _uniqueVariables) {
          {
            this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, PVariable.class);
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(" ");
            String _escapedName = this.escapedName(variable);
            _builder_3.append(_escapedName, " ");
            _builder_3.append(" = body.getOrCreateVariableByName(\"");
            String _name = variable.getName();
            _builder_3.append(_name, " ");
            _builder_3.append("\");");
            appender.append(_builder_3);
            appender.newLine();
          }
        }
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("body.setExportedParameters(");
        appender.append(_builder_3);
        this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, Arrays.class);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append(".<");
        appender.append(_builder_4);
        this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, ExportedParameter.class);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append(">asList(");
        appender.append(_builder_5);
        appender.increaseIndentation();
        appender.newLine();
        List<ExportedParameter> _symbolicParameters = pBody.getSymbolicParameters();
        final Iterator<ExportedParameter> exportIt = _symbolicParameters.iterator();
        boolean _hasNext = exportIt.hasNext();
        boolean _while = _hasNext;
        while (_while) {
          {
            ExportedParameter _next = exportIt.next();
            this.inferExportedParameterConstraint(_next, pBody, pattern, appender);
            boolean _hasNext_1 = exportIt.hasNext();
            if (_hasNext_1) {
              StringConcatenation _builder_6 = new StringConcatenation();
              _builder_6.append(", ");
              appender.append(_builder_6);
              appender.newLine();
            }
          }
          boolean _hasNext_1 = exportIt.hasNext();
          _while = _hasNext_1;
        }
        appender.decreaseIndentation();
        appender.newLine();
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("));");
        appender.append(_builder_6);
        appender.newLine();
        Set<PConstraint> _constraints = pBody.getConstraints();
        final Procedure1<PConstraint> _function = new Procedure1<PConstraint>() {
          public void apply(final PConstraint it) {
            PatternQuerySpecificationClassInferrer.this.inferConstraint(it, pBody, pattern, appender);
          }
        };
        IterableExtensions.<PConstraint>forEach(_constraints, _function);
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("bodies.add(body);");
        appender.append(_builder_7);
        appender.decreaseIndentation();
        appender.newLine();
        appender.append("}");
        appender.newLine();
      }
    }
  }
  
  /**
   * Infers inner class for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationInnerClasses(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final boolean isPublic) {
    EList<JvmMember> _members = querySpecificationClass.getMembers();
    String _querySpecificationHolderClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationHolderClassName(pattern);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        it.setVisibility(JvmVisibility.PRIVATE);
        it.setStatic(true);
        EList<JvmMember> _members = it.getMembers();
        JvmParameterizedTypeReference _createTypeRef = PatternQuerySpecificationClassInferrer.this.types.createTypeRef(querySpecificationClass);
        final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
          public void apply(final JvmField it) {
            it.setFinal(true);
            it.setStatic(true);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("make()");
                it.append(_builder);
              }
            };
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _function);
          }
        };
        JvmField _field = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toField(querySpecificationClass, "INSTANCE", _createTypeRef, _function);
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
        EList<JvmMember> _members_1 = it.getMembers();
        JvmParameterizedTypeReference _createTypeRef_1 = PatternQuerySpecificationClassInferrer.this.types.createTypeRef(querySpecificationClass);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return new ");
                String _querySpecificationClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
                _builder.append(_querySpecificationClassName, "");
                _builder.append("();\t\t\t\t\t");
                _builder.newLineIfNotEmpty();
                it.append(_builder);
              }
            };
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(querySpecificationClass, "make", _createTypeRef_1, _function_1);
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      }
    };
    JvmGenericType _class = this._eMFJvmTypesBuilder.toClass(querySpecificationClass, _querySpecificationHolderClassName, _function);
    return this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members, _class);
  }
  
  public String escapedName(final PVariable variable) {
    String _xifexpression = null;
    boolean _equals = Objects.equal(variable, null);
    if (_equals) {
      _xifexpression = "var_";
    } else {
      String _name = variable.getName();
      String _replaceAll = _name.replaceAll("[\\.\\{\\}<>]", "_");
      _xifexpression = ("var_" + _replaceAll);
    }
    return _xifexpression;
  }
  
  public ITreeAppendable inferExportedParameterConstraint(final ExportedParameter constraint, final PBody body, final Pattern pattern, final ITreeAppendable appender) {
    ITreeAppendable _xblockexpression = null;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("new ");
      appender.append(_builder);
      this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, ExportedParameter.class);
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("(body, ");
      PVariable _parameterVariable = constraint.getParameterVariable();
      String _escapedName = this.escapedName(_parameterVariable);
      _builder_1.append(_escapedName, "");
      _builder_1.append(", \"");
      String _parameterName = constraint.getParameterName();
      _builder_1.append(_parameterName, "");
      _builder_1.append("\")");
      _xblockexpression = appender.append(_builder_1);
    }
    return _xblockexpression;
  }
  
  public ITreeAppendable inferConstraint(final PConstraint constraint, final PBody body, final Pattern pattern, final ITreeAppendable appender) {
    ITreeAppendable _xblockexpression = null;
    {
      boolean _matched = false;
      if (!_matched) {
        if (constraint instanceof ExportedParameter) {
          _matched=true;
        }
      }
      if (!_matched) {
        if (constraint instanceof Equality) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, Equality.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, ");
          PVariable _who = ((Equality)constraint).getWho();
          String _escapedName = this.escapedName(_who);
          _builder_1.append(_escapedName, "");
          _builder_1.append(", ");
          PVariable _withWhom = ((Equality)constraint).getWithWhom();
          String _escapedName_1 = this.escapedName(_withWhom);
          _builder_1.append(_escapedName_1, "");
          _builder_1.append(");");
          appender.append(_builder_1);
        }
      }
      if (!_matched) {
        if (constraint instanceof Inequality) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, Inequality.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          appender.append(_builder_1);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(body, ");
          PVariable _who = ((Inequality)constraint).getWho();
          String _escapedName = this.escapedName(_who);
          _builder_2.append(_escapedName, "");
          _builder_2.append(", ");
          PVariable _withWhom = ((Inequality)constraint).getWithWhom();
          String _escapedName_1 = this.escapedName(_withWhom);
          _builder_2.append(_escapedName_1, "");
          _builder_2.append(");");
          appender.append(_builder_2);
        }
      }
      if (!_matched) {
        if (constraint instanceof TypeUnary) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, TypeUnary.class);
          Object _supplierKey = ((TypeUnary)constraint).getSupplierKey();
          final EClassifier literal = ((EClassifier) _supplierKey);
          EPackage _ePackage = literal.getEPackage();
          final String packageNsUri = _ePackage.getNsURI();
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, ");
          Tuple _variablesTuple = ((TypeUnary)constraint).getVariablesTuple();
          String _output = this.output(_variablesTuple);
          _builder_1.append(_output, "");
          _builder_1.append(", getClassifierLiteral(\"");
          _builder_1.append(packageNsUri, "");
          _builder_1.append("\", \"");
          String _name = literal.getName();
          _builder_1.append(_name, "");
          _builder_1.append("\"), \"");
          String _typeString = ((TypeUnary)constraint).getTypeString();
          _builder_1.append(_typeString, "");
          _builder_1.append("\");");
          appender.append(_builder_1);
        }
      }
      if (!_matched) {
        if (constraint instanceof TypeBinary) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, TypeBinary.class);
          Object _supplierKey = ((TypeBinary)constraint).getSupplierKey();
          final EStructuralFeature literal = ((EStructuralFeature) _supplierKey);
          final EClass container = literal.getEContainingClass();
          EPackage _ePackage = container.getEPackage();
          final String packageNsUri = _ePackage.getNsURI();
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, CONTEXT, ");
          Tuple _variablesTuple = ((TypeBinary)constraint).getVariablesTuple();
          String _output = this.output(_variablesTuple);
          _builder_1.append(_output, "");
          _builder_1.append(", getFeatureLiteral(\"");
          _builder_1.append(packageNsUri, "");
          _builder_1.append("\", \"");
          String _name = container.getName();
          _builder_1.append(_name, "");
          _builder_1.append("\", \"");
          String _name_1 = literal.getName();
          _builder_1.append(_name_1, "");
          _builder_1.append("\"), \"");
          String _typeString = ((TypeBinary)constraint).getTypeString();
          _builder_1.append(_typeString, "");
          _builder_1.append("\");");
          appender.append(_builder_1);
        }
      }
      if (!_matched) {
        if (constraint instanceof ConstantValue) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, ConstantValue.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, ");
          Tuple _variablesTuple = ((ConstantValue)constraint).getVariablesTuple();
          String _output = this.output(_variablesTuple);
          _builder_1.append(_output, "");
          _builder_1.append(", ");
          Object _supplierKey = ((ConstantValue)constraint).getSupplierKey();
          CharSequence _outputConstant = this.outputConstant(_supplierKey);
          _builder_1.append(_outputConstant, "");
          _builder_1.append(");");
          appender.append(_builder_1);
        }
      }
      if (!_matched) {
        if (constraint instanceof PositivePatternCall) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, PositivePatternCall.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          appender.append(_builder_1);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          Tuple _variablesTuple = ((PositivePatternCall)constraint).getVariablesTuple();
          String _output = this.output(_variablesTuple);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          appender.append(_builder_2);
          PQuery _referredQuery = ((PositivePatternCall)constraint).getReferredQuery();
          this.referSpecification(appender, _referredQuery, pattern);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(");");
          appender.append(_builder_3);
        }
      }
      if (!_matched) {
        if (constraint instanceof NegativePatternCall) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, NegativePatternCall.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          appender.append(_builder_1);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          Tuple _actualParametersTuple = ((NegativePatternCall)constraint).getActualParametersTuple();
          String _output = this.output(_actualParametersTuple);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          appender.append(_builder_2);
          PQuery _referredQuery = ((NegativePatternCall)constraint).getReferredQuery();
          this.referSpecification(appender, _referredQuery, pattern);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(".instance());");
          appender.append(_builder_3);
        }
      }
      if (!_matched) {
        if (constraint instanceof BinaryTransitiveClosure) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, BinaryTransitiveClosure.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          appender.append(_builder_1);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          Tuple _variablesTuple = ((BinaryTransitiveClosure)constraint).getVariablesTuple();
          String _output = this.output(_variablesTuple);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          appender.append(_builder_2);
          PQuery _supplierKey = ((BinaryTransitiveClosure)constraint).getSupplierKey();
          this.referSpecification(appender, _supplierKey, pattern);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(".instance());");
          appender.append(_builder_3);
        }
      }
      if (!_matched) {
        if (constraint instanceof PatternMatchCounter) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, PatternMatchCounter.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          appender.append(_builder_1);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, FlatTuple.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("(");
          Tuple _actualParametersTuple = ((PatternMatchCounter)constraint).getActualParametersTuple();
          String _output = this.output(_actualParametersTuple);
          _builder_2.append(_output, "");
          _builder_2.append("), ");
          appender.append(_builder_2);
          PQuery _referredQuery = ((PatternMatchCounter)constraint).getReferredQuery();
          this.referSpecification(appender, _referredQuery, pattern);
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append(".instance(), ");
          PVariable _resultVariable = ((PatternMatchCounter)constraint).getResultVariable();
          String _escapedName = this.escapedName(_resultVariable);
          _builder_3.append(_escapedName, "");
          _builder_3.append(");");
          appender.append(_builder_3);
        }
      }
      if (!_matched) {
        if (constraint instanceof ExpressionEvaluation) {
          _matched=true;
          IExpressionEvaluator _evaluator = ((ExpressionEvaluation)constraint).getEvaluator();
          final XBaseEvaluator evaluator = ((XBaseEvaluator) _evaluator);
          Iterable<String> _inputParameterNames = evaluator.getInputParameterNames();
          boolean _isEmpty = IterableExtensions.isEmpty(_inputParameterNames);
          if (_isEmpty) {
            XExpression _expression = evaluator.getExpression();
            this.feedback.reportError(_expression, "No parameters defined", EMFPatternLanguageJvmModelInferrer.SPECIFICATION_BUILDER_CODE, Severity.WARNING, IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
          }
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("new ");
          appender.append(_builder);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, ExpressionEvaluation.class);
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("(body, new ");
          appender.append(_builder_1);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, IExpressionEvaluator.class);
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("() {");
          appender.append(_builder_2);
          appender.increaseIndentation();
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.newLine();
          _builder_3.append("@Override");
          _builder_3.newLine();
          _builder_3.append("public String getShortDescription() {");
          _builder_3.newLine();
          _builder_3.append("\t");
          _builder_3.append("return \"Expression evaluation from pattern ");
          String _name = pattern.getName();
          _builder_3.append(_name, "\t");
          _builder_3.append("\";");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("}");
          _builder_3.newLine();
          _builder_3.newLine();
          _builder_3.append("@Override");
          _builder_3.newLine();
          _builder_3.append("public Iterable<String> getInputParameterNames() {");
          _builder_3.newLine();
          _builder_3.append("\t");
          _builder_3.append("return ");
          appender.append(_builder_3);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, Arrays.class);
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append(".asList(");
          {
            Iterable<String> _inputParameterNames_1 = evaluator.getInputParameterNames();
            boolean _hasElements = false;
            for(final String name : _inputParameterNames_1) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder_4.appendImmediate(", ", "");
              }
              _builder_4.append("\"");
              _builder_4.append(name, "");
              _builder_4.append("\"");
            }
          }
          _builder_4.append(");");
          appender.append(_builder_4);
          StringConcatenation _builder_5 = new StringConcatenation();
          _builder_5.newLine();
          _builder_5.append("}");
          _builder_5.newLine();
          _builder_5.newLine();
          _builder_5.append("@Override");
          _builder_5.newLine();
          _builder_5.append("public Object evaluateExpression(");
          appender.append(_builder_5);
          this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, IValueProvider.class);
          appender.append(" ");
          StringConcatenation _builder_6 = new StringConcatenation();
          _builder_6.append("provider) throws Exception {");
          _builder_6.newLine();
          _builder_6.append("\t");
          XExpression _expression_1 = evaluator.getExpression();
          final List<Variable> variables = this.variables(_expression_1);
          _builder_6.newLineIfNotEmpty();
          {
            for(final Variable variable : variables) {
              _builder_6.append("\t");
              JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
              String _qualifiedName = _calculateType.getQualifiedName();
              _builder_6.append(_qualifiedName, "\t");
              _builder_6.append(" ");
              String _name_1 = variable.getName();
              _builder_6.append(_name_1, "\t");
              _builder_6.append(" = (");
              JvmTypeReference _calculateType_1 = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
              String _qualifiedName_1 = _calculateType_1.getQualifiedName();
              _builder_6.append(_qualifiedName_1, "\t");
              _builder_6.append(") provider.getValue(\"");
              String _name_2 = variable.getName();
              _builder_6.append(_name_2, "\t");
              _builder_6.append("\");");
              _builder_6.newLineIfNotEmpty();
            }
          }
          _builder_6.append("\t");
          _builder_6.append("return ");
          XExpression _expression_2 = evaluator.getExpression();
          String _expressionMethodName = this.expressionMethodName(_expression_2);
          _builder_6.append(_expressionMethodName, "\t");
          _builder_6.append("(");
          {
            boolean _hasElements_1 = false;
            for(final Variable variable_1 : variables) {
              if (!_hasElements_1) {
                _hasElements_1 = true;
              } else {
                _builder_6.appendImmediate(", ", "\t");
              }
              String _name_3 = variable_1.getName();
              _builder_6.append(_name_3, "\t");
            }
          }
          _builder_6.append(");");
          _builder_6.newLineIfNotEmpty();
          _builder_6.append("}");
          _builder_6.newLine();
          _builder_6.newLine();
          appender.append(_builder_6);
          appender.decreaseIndentation();
          StringConcatenation _builder_7 = new StringConcatenation();
          _builder_7.append("}, ");
          {
            PVariable _outputVariable = ((ExpressionEvaluation)constraint).getOutputVariable();
            boolean _notEquals = (!Objects.equal(_outputVariable, null));
            if (_notEquals) {
              _builder_7.append(" ");
              PVariable _outputVariable_1 = ((ExpressionEvaluation)constraint).getOutputVariable();
              String _escapedName = this.escapedName(_outputVariable_1);
              _builder_7.append(_escapedName, "");
              _builder_7.append(" ");
            } else {
              _builder_7.append(" null");
            }
          }
          _builder_7.append("); ");
          appender.append(_builder_7);
        }
      }
      if (!_matched) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//TODO error in code generation");
        _builder.newLine();
        _builder.append("Unsupported constraint ");
        Class<? extends PConstraint> _class = constraint.getClass();
        String _simpleName = _class.getSimpleName();
        _builder.append(_simpleName, "");
        appender.append(_builder);
      }
      _xblockexpression = appender.newLine();
    }
    return _xblockexpression;
  }
  
  public String output(final Tuple tuple) {
    Joiner _on = Joiner.on(", ");
    Object[] _elements = tuple.getElements();
    final Function1<Object, String> _function = new Function1<Object, String>() {
      public String apply(final Object it) {
        return PatternQuerySpecificationClassInferrer.this.escapedName(((PVariable) it));
      }
    };
    List<String> _map = ListExtensions.<Object, String>map(((List<Object>)Conversions.doWrapArray(_elements)), _function);
    return _on.join(_map);
  }
  
  public CharSequence outputConstant(final Object constant) {
    CharSequence _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (constant instanceof EEnumLiteral) {
        _matched=true;
        CharSequence _xblockexpression = null;
        {
          final EEnum enumeration = ((EEnumLiteral)constant).getEEnum();
          final EPackage ePackage = enumeration.getEPackage();
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("getEnumLiteral(\"");
          String _nsURI = ePackage.getNsURI();
          _builder.append(_nsURI, "");
          _builder.append("\", \"");
          String _name = enumeration.getName();
          _builder.append(_name, "");
          _builder.append("\", \"");
          String _name_1 = ((EEnumLiteral)constant).getName();
          _builder.append(_name_1, "");
          _builder.append("\").getInstance()");
          _xblockexpression = _builder;
        }
        _switchResult = _xblockexpression;
      }
    }
    if (!_matched) {
      if (constant instanceof Enumerator) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        Class<? extends Enumerator> _class = ((Enumerator)constant).getClass();
        String _canonicalName = _class.getCanonicalName();
        _builder.append(_canonicalName, "");
        _builder.append(".get(\"");
        String _literal = ((Enumerator)constant).getLiteral();
        _builder.append(_literal, "");
        _builder.append("\")");
        _switchResult = _builder;
      }
    }
    if (!_matched) {
      if (constant instanceof String) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        _builder.append(((String)constant), "");
        _builder.append("\"");
        _switchResult = _builder;
      }
    }
    if (!_matched) {
      _switchResult = constant.toString();
    }
    return _switchResult;
  }
  
  public ITreeAppendable referSpecification(final ITreeAppendable appender, final PQuery referredQuery, final Pattern callerPattern) {
    ITreeAppendable _xifexpression = null;
    Pattern _pattern = ((GenericQuerySpecification) referredQuery).getPattern();
    boolean _equals = Objects.equal(_pattern, callerPattern);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("this");
      _xifexpression = appender.append(_builder);
    } else {
      ITreeAppendable _xblockexpression = null;
      {
        JvmGenericType _findGeneratedSpecification = this.findGeneratedSpecification(referredQuery);
        this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, callerPattern, _findGeneratedSpecification);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(".instance()");
        _xblockexpression = appender.append(_builder_1);
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  public JvmGenericType findGeneratedSpecification(final PQuery query) {
    Pattern _pattern = ((GenericQuerySpecification) query).getPattern();
    return this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(_pattern);
  }
  
  public String expressionMethodName(final XExpression ex) {
    String _expressionPostfix = this.getExpressionPostfix(ex);
    return ("evaluateExpression_" + _expressionPostfix);
  }
  
  public String getExpressionPostfix(final XExpression xExpression) {
    final Pattern pattern = EcoreUtil2.<Pattern>getContainerOfType(xExpression, Pattern.class);
    boolean _notEquals = (!Objects.equal(pattern, null));
    Preconditions.checkArgument(_notEquals, "Expression is not inside a pattern");
    int bodyNo = 0;
    EList<PatternBody> _bodies = pattern.getBodies();
    for (final PatternBody patternBody : _bodies) {
      {
        bodyNo = (bodyNo + 1);
        int exNo = 0;
        Collection<XExpression> _allTopLevelXBaseExpressions = CorePatternLanguageHelper.getAllTopLevelXBaseExpressions(patternBody);
        for (final XExpression xExpression2 : _allTopLevelXBaseExpressions) {
          {
            exNo = (exNo + 1);
            boolean _equals = xExpression.equals(xExpression2);
            if (_equals) {
              String _plus = (Integer.valueOf(bodyNo) + "_");
              return (_plus + Integer.valueOf(exNo));
            }
          }
        }
      }
    }
    throw new RuntimeException("Expression not found in pattern");
  }
  
  public List<Variable> variables(final XExpression ex) {
    List<Variable> _xblockexpression = null;
    {
      final PatternBody body = EcoreUtil2.<PatternBody>getContainerOfType(ex, PatternBody.class);
      TreeIterator<EObject> _eAllContents = ex.eAllContents();
      List<XExpression> _newImmutableList = CollectionLiterals.<XExpression>newImmutableList(ex);
      Iterator<XExpression> _iterator = _newImmutableList.iterator();
      Iterator<EObject> _plus = Iterators.<EObject>concat(_eAllContents, _iterator);
      Iterator<XFeatureCall> _filter = Iterators.<XFeatureCall>filter(_plus, XFeatureCall.class);
      final Function1<XFeatureCall, String> _function = new Function1<XFeatureCall, String>() {
        public String apply(final XFeatureCall it) {
          return it.getConcreteSyntaxFeatureName();
        }
      };
      Iterator<String> _map = IteratorExtensions.<XFeatureCall, String>map(_filter, _function);
      final List<String> valNames = IteratorExtensions.<String>toList(_map);
      EList<Variable> _variables = body.getVariables();
      final Function1<Variable, Boolean> _function_1 = new Function1<Variable, Boolean>() {
        public Boolean apply(final Variable it) {
          String _name = it.getName();
          return Boolean.valueOf(valNames.contains(_name));
        }
      };
      Iterable<Variable> _filter_1 = IterableExtensions.<Variable>filter(_variables, _function_1);
      final Function1<Variable, String> _function_2 = new Function1<Variable, String>() {
        public String apply(final Variable it) {
          return it.getName();
        }
      };
      _xblockexpression = IterableExtensions.<Variable, String>sortBy(_filter_1, _function_2);
    }
    return _xblockexpression;
  }
  
  public void inferExpressions(final JvmDeclaredType querySpecificationClass, final Pattern pattern) {
    EList<PatternBody> _bodies = pattern.getBodies();
    final Function1<PatternBody, Collection<XExpression>> _function = new Function1<PatternBody, Collection<XExpression>>() {
      public Collection<XExpression> apply(final PatternBody it) {
        return CorePatternLanguageHelper.getAllTopLevelXBaseExpressions(it);
      }
    };
    List<Collection<XExpression>> _map = ListExtensions.<PatternBody, Collection<XExpression>>map(_bodies, _function);
    Iterable<XExpression> _flatten = Iterables.<XExpression>concat(_map);
    final Procedure1<XExpression> _function_1 = new Procedure1<XExpression>() {
      public void apply(final XExpression ex) {
        EList<JvmMember> _members = querySpecificationClass.getMembers();
        String _expressionMethodName = PatternQuerySpecificationClassInferrer.this.expressionMethodName(ex);
        JvmTypeReference _inferredType = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.inferredType(ex);
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            List<Variable> _variables = PatternQuerySpecificationClassInferrer.this.variables(ex);
            for (final Variable variable : _variables) {
              {
                String _name = variable.getName();
                JvmTypeReference _calculateType = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                final JvmFormalParameter parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _name, _calculateType);
                EList<JvmFormalParameter> _parameters = it.getParameters();
                PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, parameter);
              }
            }
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, ex);
          }
        };
        JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(ex, _expressionMethodName, _inferredType, _function);
        PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      }
    };
    IterableExtensions.<XExpression>forEach(_flatten, _function_1);
  }
  
  public CharSequence parameterInstantiation(final Variable variable) {
    CharSequence _xblockexpression = null;
    {
      final JvmTypeReference ref = this._iTypeProvider.getTypeForIdentifiable(variable);
      String _xifexpression = null;
      boolean _or = false;
      boolean _equals = Objects.equal(ref, null);
      if (_equals) {
        _or = true;
      } else {
        _or = (ref instanceof JvmUnknownTypeReference);
      }
      if (_or) {
        _xifexpression = "";
      } else {
        JvmType _type = ref.getType();
        _xifexpression = _type.getQualifiedName();
      }
      final String clazz = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("new PParameter(\"");
      String _name = variable.getName();
      _builder.append(_name, "");
      _builder.append("\", \"");
      _builder.append(clazz, "");
      _builder.append("\")");
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public void inferAnnotations(final ITreeAppendable appender, final Pattern pattern, final IQuerySpecification<?> genericSpecification) {
    List<PAnnotation> _allAnnotations = genericSpecification.getAllAnnotations();
    final Procedure1<PAnnotation> _function = new Procedure1<PAnnotation>() {
      public void apply(final PAnnotation it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        appender.append(_builder);
        appender.increaseIndentation();
        appender.newLine();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("PAnnotation annotation = new ");
        appender.append(_builder_1);
        PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, pattern, PAnnotation.class);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("(\"");
        String _name = it.getName();
        _builder_2.append(_name, "");
        _builder_2.append("\");");
        appender.append(_builder_2);
        appender.newLine();
        Collection<Map.Entry<String, Object>> _allValues = it.getAllValues();
        final Procedure1<Map.Entry<String, Object>> _function = new Procedure1<Map.Entry<String, Object>>() {
          public void apply(final Map.Entry<String, Object> it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("annotation.addAttribute(\"");
            String _key = it.getKey();
            _builder.append(_key, "");
            _builder.append("\",");
            appender.append(_builder);
            Object _value = it.getValue();
            PatternQuerySpecificationClassInferrer.this.outputAnnotationParameter(appender, pattern, _value);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(");");
            appender.append(_builder_1);
            appender.newLine();
          }
        };
        IterableExtensions.<Map.Entry<String, Object>>forEach(_allValues, _function);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("addAnnotation(annotation);");
        appender.append(_builder_3);
        appender.decreaseIndentation();
        appender.newLine();
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("}");
        appender.append(_builder_4);
        appender.newLine();
      }
    };
    IterableExtensions.<PAnnotation>forEach(_allAnnotations, _function);
  }
  
  public void outputAnnotationParameter(final ITreeAppendable appender, final Pattern ctx, final Object value) {
    boolean _matched = false;
    if (!_matched) {
      if (value instanceof List) {
        _matched=true;
        this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, ctx, Arrays.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".asList(new Object[] {");
        appender.append(_builder);
        final Iterator<?> iterator = ((List<?>)value).iterator();
        boolean _hasNext = iterator.hasNext();
        boolean _while = _hasNext;
        while (_while) {
          {
            Object _next = iterator.next();
            this.outputAnnotationParameter(appender, ctx, _next);
            boolean _hasNext_1 = iterator.hasNext();
            if (_hasNext_1) {
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append(", ");
              appender.append(_builder_1);
            }
          }
          boolean _hasNext_1 = iterator.hasNext();
          _while = _hasNext_1;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("})");
        appender.append(_builder_1);
      }
    }
    if (!_matched) {
      if (value instanceof ParameterReference) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        appender.append(_builder);
        this._eMFPatternLanguageJvmModelInferrerUtil.referClass(appender, ctx, ParameterReference.class);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("(\"");
        String _name = ((ParameterReference)value).getName();
        _builder_1.append(_name, "");
        _builder_1.append("\")");
        appender.append(_builder_1);
      }
    }
    if (!_matched) {
      if (value instanceof String) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        _builder.append(((String)value), "");
        _builder.append("\"");
        appender.append(_builder);
      }
    }
    if (!_matched) {
      String _string = value.toString();
      appender.append(_string);
    }
  }
}
