/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.base.api.BaseIndexOptions;
import org.eclipse.incquery.runtime.base.api.DataTypeListener;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.IEClassifierProcessor;
import org.eclipse.incquery.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.incquery.runtime.base.api.IIndexingErrorListener;
import org.eclipse.incquery.runtime.base.api.IncQueryBaseIndexChangeListener;
import org.eclipse.incquery.runtime.base.api.InstanceListener;
import org.eclipse.incquery.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.base.core.NavigationHelperContentAdapter;
import org.eclipse.incquery.runtime.base.core.NavigationHelperSetting;
import org.eclipse.incquery.runtime.base.core.NavigationHelperVisitor;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;

public class NavigationHelperImpl
implements NavigationHelper {
    protected boolean inWildcardMode;
    protected Notifier notifier;
    protected Set<Notifier> modelRoots;
    private boolean expansionAllowed;
    protected NavigationHelperContentAdapter contentAdapter;
    private final Logger logger;
    protected Set<Object> directlyObservedClasses = new HashSet<Object>();
    protected Set<Object> allObservedClasses = null;
    protected Set<Object> observedDataTypes;
    protected Set<Object> observedFeatures;
    protected Set<Object> ignoreResolveNotificationFeatures;
    protected boolean delayTraversals = false;
    protected Set<Object> delayedClasses;
    protected Set<Object> delayedFeatures;
    protected Set<Object> delayedDataTypes;
    protected Multimap<EObject, EReference> delayedProxyResolutions = LinkedHashMultimap.create();
    protected Set<Resource> resolutionDelayingResources = new HashSet<Resource>();
    private final Set<IncQueryBaseIndexChangeListener> baseIndexChangeListeners;
    private final Map<LightweightEObjectObserver, Collection<EObject>> lightweightObservers;
    private final Map<InstanceListener, Set<EClass>> subscribedInstanceListeners;
    private final Map<FeatureListener, Set<EStructuralFeature>> subscribedFeatureListeners;
    private final Map<DataTypeListener, Set<EDataType>> subscribedDataTypeListeners;
    private Table<Object, InstanceListener, Set<EClass>> instanceListeners;
    private Table<Object, FeatureListener, Set<EStructuralFeature>> featureListeners;
    private Table<Object, DataTypeListener, Set<EDataType>> dataTypeListeners;
    private final Set<IIndexingErrorListener> errorListeners;
    private final BaseIndexOptions baseIndexOptions;
    private EMFModelComprehension comprehension;

    <T> Set<T> setMinus(Collection<? extends T> a, Collection<T> b) {
        HashSet<T> result = new HashSet<T>(a);
        result.removeAll(b);
        return result;
    }

    <T extends EObject> Set<T> resolveAllInternal(Set<? extends T> a) {
        if (a == null) {
            a = Collections.emptySet();
        }
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject eObject : a) {
            if (eObject.eIsProxy()) {
                result.add(EcoreUtil.resolve((EObject)eObject, null));
                continue;
            }
            result.add(eObject);
        }
        return result;
    }

    Set<Object> resolveClassifiersToKey(Set<? extends EClassifier> classes) {
        Set<? extends EClassifier> resolveds = this.resolveAllInternal(classes);
        HashSet<Object> result = new HashSet<Object>();
        for (EClassifier eClassifier : resolveds) {
            result.add(this.toKey(eClassifier));
        }
        return result;
    }

    Set<Object> resolveFeaturesToKey(Set<? extends EStructuralFeature> features) {
        Set<? extends EStructuralFeature> resolveds = this.resolveAllInternal(features);
        HashSet<Object> result = new HashSet<Object>();
        for (EStructuralFeature eStructuralFeature : resolveds) {
            result.add(this.toKey(eStructuralFeature));
        }
        return result;
    }

    @Override
    public boolean isInWildcardMode() {
        return this.baseIndexOptions.isWildcardMode();
    }

    @Override
    public boolean isInDynamicEMFMode() {
        return this.baseIndexOptions.isDynamicEMFMode();
    }

    public BaseIndexOptions getBaseIndexOptions() {
        return this.baseIndexOptions.copy();
    }

    public EMFModelComprehension getComprehension() {
        return this.comprehension;
    }

    public NavigationHelperImpl(Notifier emfRoot, BaseIndexOptions options, Logger logger) throws IncQueryBaseException {
        this.baseIndexOptions = options.copy();
        this.logger = logger;
        assert (logger != null);
        this.comprehension = new EMFModelComprehension(this.baseIndexOptions);
        this.subscribedInstanceListeners = new HashMap<InstanceListener, Set<EClass>>();
        this.subscribedFeatureListeners = new HashMap<FeatureListener, Set<EStructuralFeature>>();
        this.subscribedDataTypeListeners = new HashMap<DataTypeListener, Set<EDataType>>();
        this.lightweightObservers = new HashMap<LightweightEObjectObserver, Collection<EObject>>();
        this.observedFeatures = new HashSet<Object>();
        this.ignoreResolveNotificationFeatures = new HashSet<Object>();
        this.observedDataTypes = new HashSet<Object>();
        this.contentAdapter = new NavigationHelperContentAdapter(this);
        this.baseIndexChangeListeners = new HashSet<IncQueryBaseIndexChangeListener>();
        this.errorListeners = new LinkedHashSet<IIndexingErrorListener>();
        this.notifier = emfRoot;
        this.modelRoots = new HashSet<Notifier>();
        this.expansionAllowed = false;
        if (emfRoot != null) {
            this.addRootInternal(emfRoot);
        }
    }

    public NavigationHelperContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    public Set<Object> getObservedFeaturesInternal() {
        return this.observedFeatures;
    }

    public boolean isFeatureResolveIgnored(EStructuralFeature feature) {
        return this.ignoreResolveNotificationFeatures.contains(this.toKey(feature));
    }

    @Override
    public void dispose() {
        this.ensureNoListenersForDispose();
        for (Notifier root : this.modelRoots) {
            this.contentAdapter.removeAdapter(root);
        }
    }

    @Override
    public Set<Object> getDataTypeInstances(EDataType type) {
        Object typeKey = this.toKey((EClassifier)type);
        Map<Object, Integer> valMap = this.contentAdapter.getDataTypeMap(typeKey);
        if (valMap != null) {
            return Collections.unmodifiableSet(valMap.keySet());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        for (Map.Entry entry : valMap.entrySet()) {
            for (EObject holder : (Set)entry.getValue()) {
                EStructuralFeature feature = this.contentAdapter.getKnownFeatureForKey(entry.getKey());
                retSet.add(new NavigationHelperSetting(feature, holder, value));
            }
        }
        return retSet;
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value, Collection<EAttribute> attributes) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        for (EAttribute attr : attributes) {
            Object feature = this.toKey((EStructuralFeature)attr);
            if (valMap.get(feature) == null) continue;
            for (EObject holder : (Set)valMap.get(feature)) {
                retSet.add(new NavigationHelperSetting((EStructuralFeature)attr, holder, value));
            }
        }
        return retSet;
    }

    @Override
    public Set<EObject> findByAttributeValue(Object value, EAttribute attribute) {
        Object feature;
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        if (valMap.get(feature = this.toKey((EStructuralFeature)attribute)) == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)valMap.get(feature));
    }

    @Override
    public void processAllFeatureInstances(EStructuralFeature feature, IEStructuralFeatureProcessor processor) {
        Map instanceMap = this.contentAdapter.getValueToFeatureToHolderMap().column(this.toKey(feature));
        for (Map.Entry entry : instanceMap.entrySet()) {
            for (EObject src : (Set)entry.getValue()) {
                processor.process(feature, src, entry.getKey());
            }
        }
    }

    @Override
    public void processDirectInstances(EClass type, IEClassifierProcessor.IEClassProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        this.processDirectInstancesInternal(type, processor, typeKey);
    }

    @Override
    public void processAllInstances(EClass type, IEClassifierProcessor.IEClassProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.contentAdapter.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                this.processDirectInstancesInternal(type, processor, subTypeKey);
            }
        }
        this.processDirectInstancesInternal(type, processor, typeKey);
    }

    @Override
    public void processDataTypeInstances(EDataType type, IEClassifierProcessor.IEDataTypeProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        Map<Object, Integer> valMap = this.contentAdapter.getDataTypeMap(typeKey);
        if (valMap == null) {
            return;
        }
        for (Object value : valMap.keySet()) {
            processor.process(type, value);
        }
    }

    private void processDirectInstancesInternal(EClass type, IEClassifierProcessor.IEClassProcessor processor, Object typeKey) {
        Set<EObject> instances = this.contentAdapter.getInstanceSet(typeKey);
        if (instances != null) {
            for (EObject eObject : instances) {
                processor.process(type, eObject);
            }
        }
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row((Object)target);
        for (Map.Entry entry : valMap.entrySet()) {
            for (EObject source : (Set)entry.getValue()) {
                EStructuralFeature feature = this.contentAdapter.getKnownFeatureForKey(entry.getKey());
                retSet.add(new NavigationHelperSetting(feature, source, target));
            }
        }
        return retSet;
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target, Collection<EReference> references) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row((Object)target);
        for (EReference ref : references) {
            Object feature = this.toKey((EStructuralFeature)ref);
            if (valMap.get(feature) == null) continue;
            for (EObject source : (Set)valMap.get(feature)) {
                retSet.add(new NavigationHelperSetting((EStructuralFeature)ref, source, target));
            }
        }
        return retSet;
    }

    @Override
    public Set<EObject> getInverseReferences(EObject target, EReference reference) {
        Object feature = this.toKey((EStructuralFeature)reference);
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row((Object)target);
        if (valMap.get(feature) == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)valMap.get(feature));
    }

    @Override
    public Set<EObject> getReferenceValues(EObject source, EReference reference) {
        Set<Object> targets = this.getFeatureTargets(source, (EStructuralFeature)reference);
        return targets;
    }

    @Override
    public Set<Object> getFeatureTargets(EObject source, EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        Set valSet = (Set)this.contentAdapter.getHolderToFeatureToValueMap().get((Object)source, feature);
        if (valSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(valSet);
    }

    @Override
    public Map<EObject, Set<Object>> getFeatureInstances(EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        Map valMap = this.contentAdapter.getHolderToFeatureToValueMap().column(feature);
        if (valMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(valMap);
    }

    @Override
    public Set<EObject> getDirectInstances(EClass type) {
        Object typeKey = this.toKey((EClassifier)type);
        Set<EObject> valSet = this.contentAdapter.getInstanceSet(typeKey);
        if (valSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(valSet);
    }

    private Object toKey(EClassifier eClassifier) {
        return this.contentAdapter.toKey(eClassifier);
    }

    private Object toKey(EStructuralFeature feature) {
        return this.contentAdapter.toKey(feature);
    }

    @Override
    public Set<EObject> getAllInstances(EClass type) {
        Set<EObject> instances;
        HashSet<EObject> retSet = new HashSet<EObject>();
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.contentAdapter.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                Set<EObject> instances2 = this.contentAdapter.getInstanceSet(subTypeKey);
                if (instances2 == null) continue;
                retSet.addAll(instances2);
            }
        }
        if ((instances = this.contentAdapter.getInstanceSet(typeKey)) != null) {
            retSet.addAll(instances);
        }
        return retSet;
    }

    @Override
    public Set<EObject> findByFeatureValue(Object value, EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        HashSet<EObject> retSet = new HashSet<EObject>();
        Map valMap = this.contentAdapter.getValueToFeatureToHolderMap().row(value);
        if (valMap.get(feature) != null) {
            retSet.addAll((Collection)valMap.get(feature));
        }
        return retSet;
    }

    @Override
    public Set<EObject> getHoldersOfFeature(EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        Multiset<EObject> holders = this.contentAdapter.getFeatureToHolderMap().get(feature);
        if (holders == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(holders.elementSet());
    }

    @Override
    public void addInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        Set<EClass> delta;
        Set<EClass> registered = this.subscribedInstanceListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EClass>();
            this.subscribedInstanceListeners.put(listener, registered);
        }
        if (!(delta = this.setMinus(classes, registered)).isEmpty()) {
            registered.addAll(delta);
            if (this.instanceListeners != null) {
                for (EClass subscriptionType : delta) {
                    Object superElementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addInstanceListenerInternal(listener, subscriptionType, superElementTypeKey);
                    Set<Object> subTypeKeys = this.contentAdapter.getSubTypeMap().get(superElementTypeKey);
                    if (subTypeKeys == null) continue;
                    for (Object subTypeKey : subTypeKeys) {
                        this.addInstanceListenerInternal(listener, subscriptionType, subTypeKey);
                    }
                }
            }
        }
    }

    @Override
    public void removeInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        Set<EClass> restriction = this.subscribedInstanceListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(classes);
            if (restriction.size() == 0) {
                this.subscribedInstanceListeners.remove(listener);
            }
            if (changed) {
                this.instanceListeners = null;
            }
        }
    }

    @Override
    public void addFeatureListener(Collection<? extends EStructuralFeature> features, FeatureListener listener) {
        Set<EStructuralFeature> delta;
        Set<EStructuralFeature> registered = this.subscribedFeatureListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EStructuralFeature>();
            this.subscribedFeatureListeners.put(listener, registered);
        }
        if (!(delta = this.setMinus(features, registered)).isEmpty()) {
            registered.addAll(delta);
            if (this.featureListeners != null) {
                for (EStructuralFeature subscriptionType : delta) {
                    this.addFeatureListenerInternal(listener, subscriptionType, this.toKey(subscriptionType));
                }
            }
        }
    }

    @Override
    public void removeFeatureListener(Collection<? extends EStructuralFeature> features, FeatureListener listener) {
        Collection restriction = this.subscribedFeatureListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(features);
            if (restriction.size() == 0) {
                this.subscribedFeatureListeners.remove(listener);
            }
            if (changed) {
                this.featureListeners = null;
            }
        }
    }

    @Override
    public void addDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        Set<EDataType> delta;
        Set<EDataType> registered = this.subscribedDataTypeListeners.get(listener);
        if (registered == null) {
            registered = new HashSet<EDataType>();
            this.subscribedDataTypeListeners.put(listener, registered);
        }
        if (!(delta = this.setMinus(types, registered)).isEmpty()) {
            registered.addAll(delta);
            if (this.dataTypeListeners != null) {
                for (EDataType subscriptionType : delta) {
                    this.addDatatypeListenerInternal(listener, subscriptionType, this.toKey((EClassifier)subscriptionType));
                }
            }
        }
    }

    @Override
    public void removeDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        Collection restriction = this.subscribedDataTypeListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(types);
            if (restriction.size() == 0) {
                this.subscribedDataTypeListeners.remove(listener);
            }
            if (changed) {
                this.dataTypeListeners = null;
            }
        }
    }

    public Set<Object> getObservedDataTypesInternal() {
        return this.observedDataTypes;
    }

    @Override
    public void addLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        Collection<EObject> observedObjects = this.lightweightObservers.get(observer);
        if (observedObjects == null) {
            observedObjects = new HashSet<EObject>();
            this.lightweightObservers.put(observer, observedObjects);
        }
        observedObjects.add(observedObject);
    }

    @Override
    public void removeLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        Collection<EObject> observedObjects = this.lightweightObservers.get(observer);
        if (observedObjects != null) {
            observedObjects.remove(observedObject);
            if (observedObjects.isEmpty()) {
                this.lightweightObservers.remove(observer);
            }
        }
    }

    public Map<LightweightEObjectObserver, Collection<EObject>> getLightweightObservers() {
        return this.lightweightObservers;
    }

    protected void notifyBaseIndexChangeListeners(boolean baseIndexChanged) {
        if (!this.baseIndexChangeListeners.isEmpty()) {
            for (IncQueryBaseIndexChangeListener listener : new ArrayList<IncQueryBaseIndexChangeListener>(this.baseIndexChangeListeners)) {
                try {
                    if (listener.onlyOnIndexChange() && !baseIndexChanged) continue;
                    listener.notifyChanged(baseIndexChanged);
                }
                catch (Exception ex) {
                    this.notifyFatalListener("EMF-IncQuery Base encountered an error in delivering notifications about changes. ", ex);
                }
            }
        }
    }

    @Override
    public void addBaseIndexChangeListener(IncQueryBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        this.baseIndexChangeListeners.add(listener);
    }

    @Override
    public void removeBaseIndexChangeListener(IncQueryBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        this.baseIndexChangeListeners.remove(listener);
    }

    @Override
    public boolean addIndexingErrorListener(IIndexingErrorListener listener) {
        return this.errorListeners.add(listener);
    }

    @Override
    public boolean removeIndexingErrorListener(IIndexingErrorListener listener) {
        return this.errorListeners.remove(listener);
    }

    public void notifyErrorListener(String message, Throwable t) {
        this.logger.error((Object)message, t);
        for (IIndexingErrorListener listener : this.errorListeners) {
            listener.error(message, t);
        }
    }

    public void notifyFatalListener(String message, Throwable t) {
        this.logger.fatal((Object)message, t);
        for (IIndexingErrorListener listener : this.errorListeners) {
            listener.fatal(message, t);
        }
    }

    protected void considerForExpansion(EObject obj) {
        Resource eResource;
        if (this.expansionAllowed && (eResource = obj.eResource()) != null && eResource.getResourceSet() == null) {
            this.expandToAdditionalRoot((Notifier)eResource);
        }
    }

    protected void expandToAdditionalRoot(Notifier root) {
        if (this.modelRoots.add(root)) {
            if (root instanceof ResourceSet) {
                this.expansionAllowed = true;
            }
            this.contentAdapter.addAdapter(root);
            this.contentAdapter.notifyBaseIndexChangeListeners();
        }
    }

    public boolean isExpansionAllowed() {
        return this.expansionAllowed;
    }

    public Set<Object> getDirectlyObservedClassesInternal() {
        return this.directlyObservedClasses;
    }

    boolean isObservedInternal(Object clazzKey) {
        return this.inWildcardMode || this.getAllObservedClassesInternal().contains(clazzKey);
    }

    public Set<Object> getAllObservedClassesInternal() {
        if (this.allObservedClasses == null) {
            this.allObservedClasses = new HashSet<Object>();
            for (Object eClassKey : this.directlyObservedClasses) {
                this.allObservedClasses.add(eClassKey);
                Set<Object> subTypes = this.contentAdapter.getSubTypeMap().get(eClassKey);
                if (subTypes == null) continue;
                this.allObservedClasses.addAll(subTypes);
            }
        }
        return this.allObservedClasses;
    }

    Table<Object, InstanceListener, Set<EClass>> getInstanceListeners() {
        if (this.instanceListeners == null) {
            this.instanceListeners = HashBasedTable.create((int)100, (int)1);
            for (Map.Entry<InstanceListener, Set<EClass>> subscription : this.subscribedInstanceListeners.entrySet()) {
                InstanceListener listener = subscription.getKey();
                for (EClass subscriptionType : subscription.getValue()) {
                    Object superElementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addInstanceListenerInternal(listener, subscriptionType, superElementTypeKey);
                    Set<Object> subTypeKeys = this.contentAdapter.getSubTypeMap().get(superElementTypeKey);
                    if (subTypeKeys == null) continue;
                    for (Object subTypeKey : subTypeKeys) {
                        this.addInstanceListenerInternal(listener, subscriptionType, subTypeKey);
                    }
                }
            }
        }
        return this.instanceListeners;
    }

    Table<Object, InstanceListener, Set<EClass>> peekInstanceListeners() {
        return this.instanceListeners;
    }

    void addInstanceListenerInternal(InstanceListener listener, EClass subscriptionType, Object elementTypeKey) {
        HashSet<EClass> subscriptionTypes = (HashSet<EClass>)this.instanceListeners.get(elementTypeKey, (Object)listener);
        if (subscriptionTypes == null) {
            subscriptionTypes = new HashSet<EClass>();
            this.instanceListeners.put(elementTypeKey, (Object)listener, subscriptionTypes);
        }
        subscriptionTypes.add(subscriptionType);
    }

    Table<Object, FeatureListener, Set<EStructuralFeature>> getFeatureListeners() {
        if (this.featureListeners == null) {
            this.featureListeners = HashBasedTable.create((int)100, (int)1);
            for (Map.Entry<FeatureListener, Set<EStructuralFeature>> subscription : this.subscribedFeatureListeners.entrySet()) {
                FeatureListener listener = subscription.getKey();
                for (EStructuralFeature subscriptionType : subscription.getValue()) {
                    Object elementTypeKey = this.toKey(subscriptionType);
                    this.addFeatureListenerInternal(listener, subscriptionType, elementTypeKey);
                }
            }
        }
        return this.featureListeners;
    }

    void addFeatureListenerInternal(FeatureListener listener, EStructuralFeature subscriptionType, Object elementTypeKey) {
        HashSet<EStructuralFeature> subscriptionTypes = (HashSet<EStructuralFeature>)this.featureListeners.get(elementTypeKey, (Object)listener);
        if (subscriptionTypes == null) {
            subscriptionTypes = new HashSet<EStructuralFeature>();
            this.featureListeners.put(elementTypeKey, (Object)listener, subscriptionTypes);
        }
        subscriptionTypes.add(subscriptionType);
    }

    Table<Object, DataTypeListener, Set<EDataType>> getDataTypeListeners() {
        if (this.dataTypeListeners == null) {
            this.dataTypeListeners = HashBasedTable.create((int)100, (int)1);
            for (Map.Entry<DataTypeListener, Set<EDataType>> subscription : this.subscribedDataTypeListeners.entrySet()) {
                DataTypeListener listener = subscription.getKey();
                for (EDataType subscriptionType : subscription.getValue()) {
                    Object elementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addDatatypeListenerInternal(listener, subscriptionType, elementTypeKey);
                }
            }
        }
        return this.dataTypeListeners;
    }

    void addDatatypeListenerInternal(DataTypeListener listener, EDataType subscriptionType, Object elementTypeKey) {
        HashSet<EDataType> subscriptionTypes = (HashSet<EDataType>)this.dataTypeListeners.get(elementTypeKey, (Object)listener);
        if (subscriptionTypes == null) {
            subscriptionTypes = new HashSet<EDataType>();
            this.dataTypeListeners.put(elementTypeKey, (Object)listener, subscriptionTypes);
        }
        subscriptionTypes.add(subscriptionType);
    }

    @Override
    public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features) {
        this.ensureNotInWildcardMode();
        if (classes != null || features != null || dataTypes != null) {
            final Set<Object> resolvedFeatures = this.resolveFeaturesToKey(features);
            final Set<Object> resolvedClasses = this.resolveClassifiersToKey(classes);
            final Set<Object> resolvedDatatypes = this.resolveClassifiersToKey(dataTypes);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedFeatures.addAll(resolvedFeatures);
                        NavigationHelperImpl.this.delayedDataTypes.addAll(resolvedDatatypes);
                        NavigationHelperImpl.this.delayedClasses.addAll(resolvedClasses);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
            catch (Exception ex) {
                this.processingError(ex, "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
        }
    }

    @Override
    public void unregisterObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features) {
        this.unregisterEClasses(classes);
        this.unregisterEDataTypes(dataTypes);
        this.unregisterEStructuralFeatures(features);
    }

    @Override
    public void registerEStructuralFeatures(Set<? extends EStructuralFeature> features) {
        this.ensureNotInWildcardMode();
        if (features != null) {
            final Set<Object> resolved = this.resolveFeaturesToKey(features);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedFeatures.addAll(resolved);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register the observed EStructuralFeatures: " + resolved);
            }
            catch (Exception ex) {
                this.processingError(ex, "register the observed EStructuralFeatures: " + resolved);
            }
        }
    }

    @Override
    public void unregisterEStructuralFeatures(Set<? extends EStructuralFeature> features) {
        this.ensureNotInWildcardMode();
        if (features != null) {
            Set<Object> resolved = this.resolveFeaturesToKey(features);
            this.ensureNoListeners(resolved, this.getFeatureListeners());
            this.observedFeatures.removeAll(resolved);
            this.delayedFeatures.removeAll(resolved);
            for (Object f : resolved) {
                this.contentAdapter.getValueToFeatureToHolderMap().column(f).clear();
                if (this.contentAdapter.peekFeatureToHolderMap() != null) {
                    this.contentAdapter.peekFeatureToHolderMap().remove(f);
                }
                if (this.contentAdapter.peekHolderToFeatureToValueMap() == null) continue;
                this.contentAdapter.peekHolderToFeatureToValueMap().column(f).clear();
            }
        }
    }

    @Override
    public void registerEClasses(Set<EClass> classes) {
        this.ensureNotInWildcardMode();
        if (classes != null) {
            final Set<Object> resolvedClasses = this.resolveClassifiersToKey(classes);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedClasses.addAll(resolvedClasses);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register the observed EClasses: " + resolvedClasses);
            }
            catch (Exception ex) {
                this.processingError(ex, "register the observed EClasses: " + resolvedClasses);
            }
        }
    }

    protected void startObservingClasses(Set<Object> classKeys) {
        this.directlyObservedClasses.addAll(classKeys);
        this.getAllObservedClassesInternal().addAll(classKeys);
        for (Object classKey : classKeys) {
            Set<Object> subTypes = this.contentAdapter.getSubTypeMap().get(classKey);
            if (subTypes == null) continue;
            this.allObservedClasses.addAll(subTypes);
        }
    }

    @Override
    public void unregisterEClasses(Set<EClass> classes) {
        this.ensureNotInWildcardMode();
        if (classes != null) {
            Set<Object> resolved = this.resolveClassifiersToKey(classes);
            this.ensureNoListeners(resolved, this.getInstanceListeners());
            this.directlyObservedClasses.removeAll(resolved);
            this.allObservedClasses = null;
            this.delayedClasses.removeAll(resolved);
            for (Object c : resolved) {
                this.contentAdapter.removeInstanceSet(c);
            }
        }
    }

    @Override
    public void registerEDataTypes(Set<EDataType> dataTypes) {
        this.ensureNotInWildcardMode();
        if (dataTypes != null) {
            final Set<Object> resolved = this.resolveClassifiersToKey(dataTypes);
            try {
                this.coalesceTraversals(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        NavigationHelperImpl.this.delayedDataTypes.addAll(resolved);
                        return null;
                    }
                });
            }
            catch (InvocationTargetException ex) {
                this.processingError(ex.getCause(), "register the observed EDataTypes: " + resolved);
            }
            catch (Exception ex) {
                this.processingError(ex, "register the observed EDataTypes: " + resolved);
            }
        }
    }

    @Override
    public void unregisterEDataTypes(Set<EDataType> dataTypes) {
        this.ensureNotInWildcardMode();
        if (dataTypes != null) {
            Set<Object> resolved = this.resolveClassifiersToKey(dataTypes);
            this.ensureNoListeners(resolved, this.getDataTypeListeners());
            this.observedDataTypes.removeAll(resolved);
            this.delayedDataTypes.removeAll(resolved);
            for (Object dataType : resolved) {
                this.contentAdapter.removeDataTypeMap(dataType);
            }
        }
    }

    @Override
    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        V finalResult = null;
        if (this.delayTraversals) {
            try {
                finalResult = callable.call();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
            return finalResult;
        }
        boolean firstRun = true;
        while (callable != null) {
            this.delayedClasses = new HashSet<Object>();
            this.delayedFeatures = new HashSet<Object>();
            this.delayedDataTypes = new HashSet<Object>();
            try {
                NavigationHelperVisitor.TraversingVisitor visitor;
                HashSet<Object> toGatherDataTypes;
                HashSet<Object> toGatherFeatures;
                HashSet<Object> toGatherClasses;
                HashSet<Object> oldClasses;
                boolean classesWarrantTraversal;
                try {
                    this.delayTraversals = true;
                    V result = callable.call();
                    if (firstRun) {
                        firstRun = false;
                        finalResult = result;
                    }
                    while (!this.delayedProxyResolutions.isEmpty() && this.resolutionDelayingResources.isEmpty()) {
                        Collection entries = this.delayedProxyResolutions.entries();
                        Map.Entry toResolve = (Map.Entry)entries.iterator().next();
                        entries.remove(toResolve);
                        this.comprehension.tryResolveReference((EObject)toResolve.getKey(), (EReference)toResolve.getValue());
                    }
                }
                catch (Throwable throwable) {
                    this.delayTraversals = false;
                    callable = null;
                    this.delayedFeatures = this.setMinus(this.delayedFeatures, this.observedFeatures);
                    this.delayedClasses = this.setMinus(this.delayedClasses, this.directlyObservedClasses);
                    this.delayedDataTypes = this.setMinus(this.delayedDataTypes, this.observedDataTypes);
                    boolean bl = classesWarrantTraversal = !this.setMinus(this.delayedClasses, this.getAllObservedClassesInternal()).isEmpty();
                    if (!(this.delayedClasses.isEmpty() && this.delayedFeatures.isEmpty() && this.delayedDataTypes.isEmpty())) {
                        oldClasses = new HashSet<Object>(this.directlyObservedClasses);
                        this.startObservingClasses(this.delayedClasses);
                        this.observedDataTypes.addAll(this.delayedDataTypes);
                        this.observedFeatures.addAll(this.delayedFeatures);
                        toGatherClasses = new HashSet<Object>(this.delayedClasses);
                        toGatherFeatures = new HashSet<Object>(this.delayedFeatures);
                        toGatherDataTypes = new HashSet<Object>(this.delayedDataTypes);
                        if (classesWarrantTraversal || !toGatherFeatures.isEmpty() || !toGatherDataTypes.isEmpty()) {
                            visitor = new NavigationHelperVisitor.TraversingVisitor(this, toGatherFeatures, toGatherClasses, oldClasses, toGatherDataTypes);
                            callable = new Callable<V>(toGatherFeatures, visitor){
                                private final /* synthetic */ Set val$toGatherFeatures;
                                private final /* synthetic */ NavigationHelperVisitor val$visitor;
                                {
                                    this.val$toGatherFeatures = set;
                                    this.val$visitor = navigationHelperVisitor;
                                }

                                @Override
                                public V call() throws Exception {
                                    NavigationHelperImpl.this.ignoreResolveNotificationFeatures.addAll(this.val$toGatherFeatures);
                                    try {
                                        NavigationHelperImpl.this.traverse(this.val$visitor);
                                    }
                                    finally {
                                        NavigationHelperImpl.this.ignoreResolveNotificationFeatures.removeAll(this.val$toGatherFeatures);
                                    }
                                    return null;
                                }
                            };
                        }
                    }
                    throw throwable;
                }
                this.delayTraversals = false;
                callable = null;
                this.delayedFeatures = this.setMinus(this.delayedFeatures, this.observedFeatures);
                this.delayedClasses = this.setMinus(this.delayedClasses, this.directlyObservedClasses);
                this.delayedDataTypes = this.setMinus(this.delayedDataTypes, this.observedDataTypes);
                boolean bl = classesWarrantTraversal = !this.setMinus(this.delayedClasses, this.getAllObservedClassesInternal()).isEmpty();
                if (this.delayedClasses.isEmpty() && this.delayedFeatures.isEmpty() && this.delayedDataTypes.isEmpty()) continue;
                oldClasses = new HashSet<Object>(this.directlyObservedClasses);
                this.startObservingClasses(this.delayedClasses);
                this.observedDataTypes.addAll(this.delayedDataTypes);
                this.observedFeatures.addAll(this.delayedFeatures);
                toGatherClasses = new HashSet<Object>(this.delayedClasses);
                toGatherFeatures = new HashSet<Object>(this.delayedFeatures);
                toGatherDataTypes = new HashSet<Object>(this.delayedDataTypes);
                if (!classesWarrantTraversal && toGatherFeatures.isEmpty() && toGatherDataTypes.isEmpty()) continue;
                visitor = new NavigationHelperVisitor.TraversingVisitor(this, toGatherFeatures, toGatherClasses, oldClasses, toGatherDataTypes);
                callable = new /* invalid duplicate definition of identical inner class */;
            }
            catch (Exception e) {
                this.notifyFatalListener("EMF-IncQuery Base encountered an error while traversing the EMF model to gather new information. ", e);
                throw new InvocationTargetException(e);
            }
        }
        return finalResult;
    }

    private void traverse(NavigationHelperVisitor visitor) {
        for (Notifier root : this.modelRoots) {
            this.comprehension.traverseModel(visitor, root);
        }
        this.contentAdapter.notifyBaseIndexChangeListeners();
    }

    @Override
    public void addRoot(Notifier emfRoot) throws IncQueryBaseException {
        this.addRootInternal(emfRoot);
    }

    @Override
    public <T extends EObject> void cheapMoveTo(T element, EList<T> targetContainmentReferenceList) {
        if (element.eAdapters().contains((Object)this.contentAdapter) && targetContainmentReferenceList instanceof NotifyingList) {
            Object listNotifier = ((NotifyingList)targetContainmentReferenceList).getNotifier();
            if (listNotifier instanceof Notifier && ((Notifier)listNotifier).eAdapters().contains((Object)this.contentAdapter)) {
                this.contentAdapter.ignoreInsertionAndDeletion = element;
                try {
                    targetContainmentReferenceList.add(element);
                }
                finally {
                    this.contentAdapter.ignoreInsertionAndDeletion = null;
                }
            } else {
                targetContainmentReferenceList.add(element);
            }
        } else {
            targetContainmentReferenceList.add(element);
        }
    }

    @Override
    public void cheapMoveTo(EObject element, EObject parent, EReference containmentFeature) {
        this.contentAdapter.maintainMetamodel((EStructuralFeature)containmentFeature);
        if (containmentFeature.isMany()) {
            this.cheapMoveTo(element, (EList)parent.eGet((EStructuralFeature)containmentFeature));
        } else if (element.eAdapters().contains((Object)this.contentAdapter) && parent.eAdapters().contains((Object)this.contentAdapter)) {
            this.contentAdapter.ignoreInsertionAndDeletion = element;
            try {
                parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
            }
            finally {
                this.contentAdapter.ignoreInsertionAndDeletion = null;
            }
        } else {
            parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
        }
    }

    private void addRootInternal(Notifier emfRoot) throws IncQueryBaseException {
        if (!(emfRoot instanceof EObject || emfRoot instanceof Resource || emfRoot instanceof ResourceSet)) {
            throw new IncQueryBaseException("Emf navigation helper can only be attached on the contents of an EMF EObject, Resource, or ResourceSet.");
        }
        this.expandToAdditionalRoot(emfRoot);
    }

    @Override
    public Set<EClass> getAllCurrentClasses() {
        return this.contentAdapter.getAllCurrentClasses();
    }

    protected void processingError(Throwable ex, String task) {
        this.contentAdapter.processingFatal(ex, task);
    }

    private void ensureNotInWildcardMode() {
        if (this.inWildcardMode) {
            throw new IllegalStateException("Cannot register/unregister observed classes in wildcard mode");
        }
    }

    private <X, Y> void ensureNoListeners(Set<Object> unobservedTypes, Table<Object, X, Set<Y>> listenerRegistry) {
        if (!Collections.disjoint(unobservedTypes, listenerRegistry.rowKeySet())) {
            throw new IllegalStateException("Cannot unregister observed types for which there are active listeners");
        }
    }

    private void ensureNoListenersForDispose() {
        if (!(this.baseIndexChangeListeners.isEmpty() && this.subscribedFeatureListeners.isEmpty() && this.subscribedDataTypeListeners.isEmpty() && this.subscribedInstanceListeners.isEmpty())) {
            throw new IllegalStateException("Cannot dispose while there are active listeners");
        }
    }

    @Override
    public void resampleDerivedFeatures() {
        if (!this.baseIndexOptions.isTraverseOnlyWellBehavingDerivedFeatures()) {
            Set<EClass> allCurrentClasses = this.contentAdapter.getAllCurrentClasses();
            HashSet featuresToSample = Sets.newHashSet();
            for (EClass cls : allCurrentClasses) {
                EList features = cls.getEAllStructuralFeatures();
                for (EStructuralFeature f : features) {
                    if (!this.comprehension.onlySamplingFeature(f)) continue;
                    featuresToSample.add(f);
                }
            }
            final EMFVisitor removalVisitor = this.contentAdapter.visitor(false);
            final EMFVisitor insertionVisitor = this.contentAdapter.visitor(true);
            for (final EStructuralFeature f : featuresToSample) {
                EClass containingClass = f.getEContainingClass();
                this.processAllInstances(containingClass, new IEClassifierProcessor.IEClassProcessor(){

                    @Override
                    public void process(EClass type, EObject instance) {
                        NavigationHelperImpl.this.contentAdapter.resampleFeatureValueForHolder(instance, f, insertionVisitor, removalVisitor);
                    }
                });
            }
            this.contentAdapter.notifyBaseIndexChangeListeners();
        }
    }
}

