/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.extend;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendOperation;

public class IterateOverChildren
extends ExtendOperation<EObject> {
    private int sourcePosition;
    private boolean transitive;

    public IterateOverChildren(int position, int sourcePosition, boolean transitive) {
        super(position);
        this.sourcePosition = sourcePosition;
        this.transitive = transitive;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Preconditions.checkState((boolean)(frame.get(this.sourcePosition) instanceof EObject), (Object)"Only children of EObject elements are supported.");
        EObject source = (EObject)frame.get(this.sourcePosition);
        this.it = this.transitive ? source.eAllContents() : source.eContents().iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IterateOverChildren(");
        builder.append(this.position + ", " + this.sourcePosition + ", " + this.transitive);
        builder.append(")");
        return builder.toString();
    }
}

