/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.incquery.runtime.localsearch.MatchingKey;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public class MatchingFrame
extends Tuple
implements Cloneable {
    private Object pattern;
    private Object[] frame;
    private int keySize;

    public MatchingFrame(Object pattern, int keySize, int frameSize) {
        this.pattern = pattern;
        this.keySize = keySize;
        this.frame = new Object[frameSize];
    }

    public Object getValue(Integer position) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        return this.frame[position];
    }

    public void setValue(Integer position, Object value) {
        Preconditions.checkElementIndex((int)position, (int)this.frame.length);
        this.frame[position.intValue()] = value;
    }

    public boolean testAndSetValue(Integer position, Object value) {
        if (this.frame[position] == null) {
            this.frame[position.intValue()] = value;
            return true;
        }
        return this.frame[position].equals(value);
    }

    public Object getPattern() {
        return this.pattern;
    }

    public MatchingKey getKey() {
        return new MatchingKey(Arrays.copyOfRange(this.frame, 0, this.keySize));
    }

    public MatchingFrame clone() {
        MatchingFrame clone = new MatchingFrame(this.pattern, this.keySize, this.frame.length);
        clone.frame = Arrays.copyOf(this.frame, this.frame.length);
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.frame.length) {
            builder.append("frame[" + i + "]\t" + (this.frame[i] == null ? "null" : this.frame[i]).toString() + "\n");
            ++i;
        }
        return builder.toString();
    }

    public int getSize() {
        return this.frame.length;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object[] getElements() {
        Object[] allElements = new Object[this.keySize];
        int i = 0;
        while (i < this.keySize) {
            allElements[i] = this.get(i);
            ++i;
        }
        return allElements;
    }
}

