/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.check;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.operations.MatchingFrameValueProvider;
import org.eclipse.incquery.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.psystem.IValueProvider;

public class ExpressionCheck
extends CheckOperation {
    IExpressionEvaluator evaluator;
    Map<String, Integer> nameMap;

    public ExpressionCheck(IExpressionEvaluator evaluator, Map<String, Integer> nameMap) {
        this.evaluator = evaluator;
        this.nameMap = nameMap;
    }

    @Override
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        try {
            boolean result = (Boolean)this.evaluator.evaluateExpression((IValueProvider)new MatchingFrameValueProvider(frame, this.nameMap));
            return result;
        }
        catch (Exception e) {
            throw new LocalSearchException("Error while evaluating expression", e);
        }
    }

    @Override
    public List<Integer> getVariablePositions() {
        ArrayList variables = Lists.newArrayList();
        variables.addAll(this.nameMap.values());
        return variables;
    }

    public String toString() {
        return "Expression check";
    }
}

