/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem.basicenumerables;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.KeyedEnumerablePConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;

public class TypeTernary<PatternDescription, StubHandle>
extends KeyedEnumerablePConstraint<Object, PatternDescription, StubHandle>
implements ITypeInfoProviderConstraint {
    private final IPatternMatcherContext<PatternDescription> context;
    private PVariable edge;
    private PVariable source;
    private PVariable target;

    public TypeTernary(PSystem<PatternDescription, StubHandle, ?> pSystem, IPatternMatcherContext<PatternDescription> context, PVariable edge, PVariable source, PVariable target, Object supplierKey) {
        super(pSystem, new FlatTuple(edge, source, target), supplierKey);
        this.edge = edge;
        this.source = source;
        this.target = target;
        this.context = context;
    }

    @Override
    public Stub<StubHandle> doCreateStub() {
        return this.buildable.ternaryEdgeTypeStub(this.variablesTuple, this.supplierKey);
    }

    @Override
    public Object getTypeInfo(PVariable variable) {
        if (variable.equals(this.variablesTuple.get(0))) {
            return ITypeInfoProviderConstraint.TypeInfoSpecials.wrapTernary(this.supplierKey);
        }
        if (variable.equals(this.variablesTuple.get(1))) {
            return ITypeInfoProviderConstraint.TypeInfoSpecials.wrapAny(this.context.ternaryEdgeSourceType(this.supplierKey));
        }
        if (variable.equals(this.variablesTuple.get(2))) {
            return ITypeInfoProviderConstraint.TypeInfoSpecials.wrapAny(this.context.ternaryEdgeTargetType(this.supplierKey));
        }
        return ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED;
    }

    @Override
    protected String keyToString() {
        return this.pSystem.getContext().printType(this.supplierKey);
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        HashMap<Set<PVariable>, Set<PVariable>> result = new HashMap<Set<PVariable>, Set<PVariable>>();
        result.put(Collections.singleton(this.edge), new HashSet<PVariable>(Arrays.asList(this.source, this.target)));
        if (this.context.isBinaryEdgeMultiplicityToOne(this.supplierKey)) {
            result.put(Collections.singleton(this.source), new HashSet<PVariable>(Arrays.asList(this.edge, this.target)));
        }
        if (this.context.isBinaryEdgeMultiplicityOneTo(this.supplierKey)) {
            result.put(Collections.singleton(this.target), new HashSet<PVariable>(Arrays.asList(this.source, this.edge)));
        }
        return result;
    }
}

