/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.boundary.InputConnector;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Production;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.network.Tunnel;
import org.eclipse.incquery.runtime.rete.remote.Address;
import org.eclipse.incquery.runtime.rete.traceability.CompiledQuery;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;

public class ReteBoundary {
    protected ReteEngine engine;
    protected Network network;
    protected ReteContainer headContainer;
    protected IPatternMatcherRuntimeContext context;
    IPatternMatcherContext.GeneralizationQueryDirection generalizationQueryDirection;
    protected final InputConnector inputConnector;
    protected Map<SubPlan, Address<? extends Supplier>> subplanToAddressMapping;
    protected Map<Address<? extends Receiver>, Set<SubPlan>> parentPlansOfReceiver;

    public ReteContainer getHeadContainer() {
        return this.headContainer;
    }

    public ReteBoundary(ReteEngine engine) {
        this.engine = engine;
        this.network = engine.getReteNet();
        this.headContainer = this.network.getHeadContainer();
        this.inputConnector = this.network.getInputConnector();
        this.context = engine.getContext();
        this.generalizationQueryDirection = this.context.allowedGeneralizationQueryDirection();
        this.parentPlansOfReceiver = CollectionsFactory.getMap();
        this.subplanToAddressMapping = CollectionsFactory.getMap();
    }

    public Collection<? extends RecipeTraceInfo> getAllProductionNodes() {
        return this.engine.getCompiler().getCachedCompiledQueries().values();
    }

    public synchronized RecipeTraceInfo accessProductionTrace(PQuery query) throws QueryPlannerException {
        CompiledQuery compiled = this.engine.getCompiler().getCompiledForm(query);
        return compiled;
    }

    public synchronized Address<? extends Production> accessProductionNode(PQuery query) throws QueryPlannerException {
        return this.headContainer.getProvisioner().getOrCreateNodeByRecipe(this.accessProductionTrace(query));
    }

    public void updateUnary(Direction direction, Object entity, Object typeObject) {
        Address<? extends Tunnel> root = this.inputConnector.getUnaryRoot(typeObject);
        if (root != null) {
            this.network.sendExternalUpdate(root, direction, (Tuple)new FlatTuple(new Object[]{this.inputConnector.wrapElement(entity)}));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
        if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.SUPERTYPE_ONLY) {
            for (Object superType : this.context.enumerateDirectUnarySupertypes(typeObject)) {
                this.updateUnary(direction, entity, superType);
            }
        }
    }

    public void updateTernaryEdge(Direction direction, Object relation, Object from, Object to, Object typeObject) {
        Address<? extends Tunnel> root = this.inputConnector.getTernaryEdgeRoot(typeObject);
        if (root != null) {
            this.network.sendExternalUpdate(root, direction, (Tuple)new FlatTuple(new Object[]{this.inputConnector.wrapElement(relation), this.inputConnector.wrapElement(from), this.inputConnector.wrapElement(to)}));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
        if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.SUPERTYPE_ONLY) {
            for (Object superType : this.context.enumerateDirectTernaryEdgeSupertypes(typeObject)) {
                this.updateTernaryEdge(direction, relation, from, to, superType);
            }
        }
    }

    public void updateBinaryEdge(Direction direction, Object from, Object to, Object typeObject) {
        Address<? extends Tunnel> root = this.inputConnector.getBinaryEdgeRoot(typeObject);
        if (root != null) {
            this.network.sendExternalUpdate(root, direction, (Tuple)new FlatTuple(new Object[]{this.inputConnector.wrapElement(from), this.inputConnector.wrapElement(to)}));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
        if (typeObject != null && this.generalizationQueryDirection == IPatternMatcherContext.GeneralizationQueryDirection.SUPERTYPE_ONLY) {
            for (Object superType : this.context.enumerateDirectBinaryEdgeSupertypes(typeObject)) {
                this.updateBinaryEdge(direction, from, to, superType);
            }
        }
    }

    public void updateContainment(Direction direction, Object container, Object element) {
        Address<? extends Tunnel> containmentRoot = this.inputConnector.getContainmentRoot();
        if (containmentRoot != null) {
            this.network.sendExternalUpdate(containmentRoot, direction, (Tuple)new FlatTuple(new Object[]{this.inputConnector.wrapElement(container), this.inputConnector.wrapElement(element)}));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
    }

    public void updateInstantiation(Direction direction, Object parent, Object child) {
        Address<? extends Tunnel> instantiationRoot = this.inputConnector.getInstantiationRoot();
        if (instantiationRoot != null) {
            this.network.sendExternalUpdate(instantiationRoot, direction, (Tuple)new FlatTuple(new Object[]{this.inputConnector.wrapElement(parent), this.inputConnector.wrapElement(child)}));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
    }

    public void updateGeneralization(Direction direction, Object parent, Object child) {
        Address<? extends Tunnel> generalizationRoot = this.inputConnector.getGeneralizationRoot();
        if (generalizationRoot != null) {
            this.network.sendExternalUpdate(generalizationRoot, direction, (Tuple)new FlatTuple(new Object[]{this.inputConnector.wrapElement(parent), this.inputConnector.wrapElement(child)}));
            if (!this.engine.isParallelExecutionEnabled()) {
                this.network.waitForReteTermination();
            }
        }
    }

    public void notifyEvaluator(Address<? extends Receiver> receiver, Tuple tuple) {
        this.network.sendExternalUpdate(receiver, Direction.INSERT, tuple);
        if (!this.engine.isParallelExecutionEnabled()) {
            this.network.waitForReteTermination();
        }
    }

    @Deprecated
    public void registerParentPlanForReceiver(Address<? extends Receiver> receiver, SubPlan parentPlan) {
        Set<Object> parents = this.parentPlansOfReceiver.get(receiver);
        if (parents == null) {
            parents = CollectionsFactory.getSet();
            this.parentPlansOfReceiver.put(receiver, parents);
        }
        parents.add(parentPlan);
    }

    @Deprecated
    public Set<SubPlan> getParentPlansOfReceiver(Address<? extends Receiver> receiver) {
        Set<Object> parents = this.parentPlansOfReceiver.get(receiver);
        if (parents == null) {
            parents = Collections.emptySet();
        }
        return parents;
    }

    public void mapPlanToAddress(SubPlan plan, Address<? extends Supplier> handle) {
        this.subplanToAddressMapping.put(plan, handle);
    }

    public Address<? extends Supplier> getAddress(SubPlan plan) {
        return this.subplanToAddressMapping.get(plan);
    }
}

