/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.boundary.InputConnector;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.network.ConnectionFactory;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.NodeFactory;
import org.eclipse.incquery.runtime.rete.network.NodeProvisioner;
import org.eclipse.incquery.runtime.rete.network.Production;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.network.UpdateMessage;
import org.eclipse.incquery.runtime.rete.remote.Address;
import org.eclipse.incquery.runtime.rete.single.SingleInputNode;
import org.eclipse.incquery.runtime.rete.tuple.Clearable;

public final class ReteContainer {
    protected Thread consumerThread = null;
    protected boolean killed = false;
    protected Network network;
    protected LinkedList<Clearable> clearables;
    protected Map<Long, Node> nodesById;
    protected long nextId = 0L;
    protected ConnectionFactory connectionFactory;
    protected NodeProvisioner nodeProvisioner;
    protected Deque<UpdateMessage> internalMessageQueue = new ArrayDeque<UpdateMessage>();
    protected Deque<UpdateMessage> externalMessageQueue = new ArrayDeque<UpdateMessage>();
    protected Object externalMessageLock = new Object();
    protected Long clock = 1L;
    protected Map<ReteContainer, Long> terminationCriteria = null;

    public ReteContainer(Network network, boolean threaded) {
        this.network = network;
        this.nodesById = CollectionsFactory.getMap();
        this.clearables = new LinkedList();
        this.connectionFactory = new ConnectionFactory(this);
        this.nodeProvisioner = new NodeProvisioner(this);
        if (threaded) {
            this.terminationCriteria = CollectionsFactory.getMap();
            this.consumerThread = new Thread("Rete thread of " + ReteContainer.super.toString()){

                @Override
                public void run() {
                    ReteContainer.this.messageConsumptionCycle();
                }
            };
            this.consumerThread.start();
        }
    }

    public void kill() {
        this.killed = true;
        if (this.consumerThread != null) {
            this.consumerThread.interrupt();
        }
    }

    public void connectRemoteNodes(Address<? extends Supplier> supplier, Address<? extends Receiver> receiver, boolean synchronise) {
        if (!this.isLocal(receiver)) {
            receiver.getContainer().connectRemoteNodes(supplier, receiver, synchronise);
        } else {
            Receiver child = this.resolveLocal(receiver);
            this.connectRemoteSupplier(supplier, child, synchronise);
        }
    }

    public void disconnectRemoteNodes(Address<? extends Supplier> supplier, Address<? extends Receiver> receiver, boolean desynchronise) {
        if (!this.isLocal(receiver)) {
            receiver.getContainer().disconnectRemoteNodes(supplier, receiver, desynchronise);
        } else {
            Receiver child = this.resolveLocal(receiver);
            this.disconnectRemoteSupplier(supplier, child, desynchronise);
        }
    }

    public void connectRemoteSupplier(Address<? extends Supplier> supplier, Receiver receiver, boolean synchronise) {
        Supplier parent = this.nodeProvisioner.asSupplier(supplier);
        if (synchronise) {
            this.connectAndSynchronize(parent, receiver);
        } else {
            this.connect(parent, receiver);
        }
    }

    public void disconnectRemoteSupplier(Address<? extends Supplier> supplier, Receiver receiver, boolean desynchronise) {
        Supplier parent = this.nodeProvisioner.asSupplier(supplier);
        if (desynchronise) {
            this.disconnectAndDesynchronize(parent, receiver);
        } else {
            this.disconnect(parent, receiver);
        }
    }

    public void connect(Supplier supplier, Receiver receiver) {
        supplier.appendChild(receiver);
        receiver.appendParent(supplier);
    }

    public void disconnect(Supplier supplier, Receiver receiver) {
        supplier.removeChild(receiver);
        receiver.removeParent(supplier);
    }

    public void connectAndSynchronize(Supplier supplier, Receiver receiver) {
        this.flushUpdates();
        supplier.appendChild(receiver);
        receiver.appendParent(supplier);
        Collection<Tuple> pulled = this.pullContents(supplier);
        this.sendConstructionUpdates(receiver, Direction.INSERT, pulled);
        this.flushUpdates();
    }

    public void disconnectAndDesynchronize(Supplier supplier, Receiver receiver) {
        this.flushUpdates();
        supplier.removeChild(receiver);
        receiver.removeParent(supplier);
        Collection<Tuple> pulled = this.pullContents(supplier);
        this.sendConstructionUpdates(receiver, Direction.REVOKE, pulled);
        this.flushUpdates();
    }

    public void sendConstructionUpdate(Receiver receiver, Direction direction, Tuple updateElement) {
        if (this.consumerThread == null) {
            this.sendUpdateInternal(receiver, direction, updateElement);
        } else {
            this.network.sendConstructionUpdate(this.makeAddress(receiver), direction, updateElement);
        }
    }

    public void sendConstructionUpdates(Receiver receiver, Direction direction, Collection<Tuple> updateElements) {
        if (this.consumerThread == null) {
            for (Tuple updateElement : updateElements) {
                this.sendUpdateInternal(receiver, direction, updateElement);
            }
        } else {
            this.network.sendConstructionUpdates(this.makeAddress(receiver), direction, updateElements);
        }
    }

    public void sendUpdateInternal(Receiver receiver, Direction direction, Tuple updateElement) {
        UpdateMessage message = new UpdateMessage(receiver, direction, updateElement);
        this.internalMessageQueue.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long sendUpdateToLocalAddress(Address<? extends Receiver> address, Direction direction, Tuple updateElement) {
        long timestamp;
        Receiver receiver = this.resolveLocal(address);
        UpdateMessage message = new UpdateMessage(receiver, direction, updateElement);
        Object object = this.externalMessageLock;
        synchronized (object) {
            this.externalMessageQueue.add(message);
            timestamp = this.clock;
            this.externalMessageLock.notifyAll();
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long sendUpdatesToLocalAddress(Address<? extends Receiver> address, Direction direction, Collection<Tuple> updateElements) {
        long timestamp;
        Receiver receiver = this.resolveLocal(address);
        Object object = this.externalMessageLock;
        synchronized (object) {
            for (Tuple ps : updateElements) {
                this.externalMessageQueue.add(new UpdateMessage(receiver, direction, ps));
            }
            timestamp = this.clock;
            this.externalMessageLock.notifyAll();
        }
        return timestamp;
    }

    void sendUpdateToLocalAddressSingleThreaded(Address<? extends Receiver> address, Direction direction, Tuple updateElement) {
        Receiver receiver = this.resolveLocal(address);
        UpdateMessage message = new UpdateMessage(receiver, direction, updateElement);
        this.internalMessageQueue.add(message);
    }

    void sendUpdatesToLocalAddressSingleThreaded(Address<? extends Receiver> address, Direction direction, Collection<Tuple> updateElements) {
        Receiver receiver = this.resolveLocal(address);
        for (Tuple ps : updateElements) {
            this.internalMessageQueue.add(new UpdateMessage(receiver, direction, ps));
        }
    }

    public void sendUpdateToRemoteAddress(Address<? extends Receiver> address, Direction direction, Tuple updateElement) {
        ReteContainer otherContainer = address.getContainer();
        long otherClock = otherContainer.sendUpdateToLocalAddress(address, direction, updateElement);
        this.terminationCriteria.put(otherContainer, otherClock);
    }

    public void flushUpdates() {
        this.network.waitForReteTermination();
    }

    public Collection<Tuple> pullContents(Supplier supplier) {
        this.flushUpdates();
        LinkedList<Tuple> collector = new LinkedList<Tuple>();
        supplier.pullInto(collector);
        return collector;
    }

    public Collection<Tuple> pullPropagatedContents(SingleInputNode supplier) {
        this.flushUpdates();
        LinkedList<Tuple> collector = new LinkedList<Tuple>();
        supplier.propagatePullInto(collector);
        return collector;
    }

    public Collection<Tuple> remotePull(Address<? extends Supplier> supplier) {
        if (!this.isLocal(supplier)) {
            return supplier.getContainer().remotePull(supplier);
        }
        return this.pullContents(this.resolveLocal(supplier));
    }

    public Map<String, Integer> remotePosMapping(Address<? extends Production> production) {
        if (!this.isLocal(production)) {
            return production.getContainer().remotePosMapping(production);
        }
        return this.resolveLocal(production).getPosMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void messageConsumptionCycle() {
        while (!this.killed) {
            block16: {
                incrementedClock = 0L;
                message = null;
                if (!this.internalMessageQueue.isEmpty()) {
                    message = this.internalMessageQueue.removeFirst();
                } else {
                    var4_3 = this.externalMessageLock;
                    synchronized (var4_3) {
                        if (!this.externalMessageQueue.isEmpty()) {
                            message = this.takeExternalMessage();
                        } else {
                            this.clock = this.clock + 1L;
                            incrementedClock = this.clock;
                        }
                    }
                }
                if (message != null) break block16;
                this.localUpdateTermination(incrementedClock);
                block9: while (message == null) {
                    var4_3 = this.externalMessageLock;
                    synchronized (var4_3) {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            if (!this.externalMessageQueue.isEmpty()) {
                                message = this.takeExternalMessage();
                                continue block9;
                            }
                            try {
                                this.externalMessageLock.wait();
                            }
                            catch (InterruptedException v1) {
                                if (this.killed) ** break;
                                continue;
                                return;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                }
            }
            message.receiver.update(message.direction, message.updateElement);
        }
    }

    void messageConsumptionSingleThreaded() {
        while (!this.internalMessageQueue.isEmpty()) {
            UpdateMessage message = this.internalMessageQueue.removeFirst();
            message.receiver.update(message.direction, message.updateElement);
        }
    }

    private void localUpdateTermination(long incrementedClock) {
        this.network.reportLocalUpdateTermination(this, incrementedClock, this.terminationCriteria);
        this.terminationCriteria.clear();
    }

    private UpdateMessage takeExternalMessage() {
        UpdateMessage message = this.externalMessageQueue.removeFirst();
        if (!this.externalMessageQueue.isEmpty()) {
            Deque<UpdateMessage> temp = this.externalMessageQueue;
            this.externalMessageQueue = this.internalMessageQueue;
            this.internalMessageQueue = temp;
        }
        return message;
    }

    public <N extends Node> Address<N> makeAddress(N node) {
        return new Address<N>(node);
    }

    public boolean isLocal(Address<? extends Node> address) {
        return address.getContainer() == this;
    }

    public <N extends Node> N resolveLocal(Address<N> address) {
        if (this != address.getContainer()) {
            throw new IllegalArgumentException(String.format("Address %s non-local at container %s", address, this));
        }
        N cached = address.getNodeCache();
        if (cached != null) {
            return cached;
        }
        Node node = this.nodesById.get(address.getNodeId());
        address.setNodeCache(node);
        return (N)node;
    }

    public long registerNode(Node n) {
        long id = this.nextId++;
        this.nodesById.put(id, n);
        return id;
    }

    public void unregisterNode(Node n) {
        this.nodesById.remove(n.getNodeId());
    }

    public void registerClearable(Clearable c) {
        this.clearables.addFirst(c);
    }

    public void unregisterClearable(Clearable c) {
        this.clearables.remove(c);
    }

    public void clearAll() {
        for (Clearable c : this.clearables) {
            c.clear();
        }
    }

    public NodeFactory getNodeFactory() {
        return this.network.getNodeFactory();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public NodeProvisioner getProvisioner() {
        return this.nodeProvisioner;
    }

    public Network getNetwork() {
        return this.network;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = System.getProperty("line.separator");
        sb.append(String.valueOf(super.toString()) + "[[[" + separator);
        ArrayList<Long> keys = new ArrayList<Long>(this.nodesById.keySet());
        Collections.sort(keys);
        for (Long key : keys) {
            sb.append(key + " -> " + this.nodesById.get(key) + separator);
        }
        sb.append("]]] of " + this.network);
        return sb.toString();
    }

    public Collection<Node> getAllNodes() {
        return this.nodesById.values();
    }

    public InputConnector getInputConnectionFactory() {
        return this.network.getInputConnector();
    }
}

