/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi, Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.tooling.generator.sampleui;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.tooling.core.generator.ExtensionData;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.w3c.dom.Element;

@SuppressWarnings("all")
public class SampleUIGenerator implements IGenerationFragment {
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  private final static String ECLIPSE_UI_COMMANDS_EXTENSION_POINT = "org.eclipse.ui.commands";
  
  private final static String ECLIPSE_UI_HANDLERS_EXTENSION_POINT = "org.eclipse.ui.handlers";
  
  private final static String ECLIPSE_UI_MENUS_EXTENSION_POINT = "org.eclipse.ui.menus";
  
  public final static String UI_COMMANDS_PREFIX = "generated.incquery.command.";
  
  public final static String UI_HANDLERS_PREFIX = "generated.incquery.handler.";
  
  public final static String UI_MENUS_PREFIX = "generated.incquery.menu.";
  
  @Inject
  @Extension
  private ExtensionGenerator exGen = new ExtensionGenerator();
  
  public void generateFiles(final Pattern pattern, final IFileSystemAccess fsa) {
    String _handlerClassJavaFile = this.handlerClassJavaFile(pattern);
    CharSequence _patternHandler = this.patternHandler(pattern);
    fsa.generateFile(_handlerClassJavaFile, _patternHandler);
  }
  
  public void cleanUp(final Pattern pattern, final IFileSystemAccess fsa) {
    String _handlerClassJavaFile = this.handlerClassJavaFile(pattern);
    fsa.deleteFile(_handlerClassJavaFile);
  }
  
  public Iterable<Pair<String, String>> removeExtension(final Pattern pattern) {
    String _commandExtensionId = this.commandExtensionId(pattern);
    Pair<String, String> _of = Pair.<String, String>of(_commandExtensionId, SampleUIGenerator.ECLIPSE_UI_COMMANDS_EXTENSION_POINT);
    String _handlerExtensionId = this.handlerExtensionId(pattern);
    Pair<String, String> _of_1 = Pair.<String, String>of(_handlerExtensionId, SampleUIGenerator.ECLIPSE_UI_HANDLERS_EXTENSION_POINT);
    String _menuExtensionId = this.menuExtensionId(pattern);
    Pair<String, String> _of_2 = Pair.<String, String>of(_menuExtensionId, SampleUIGenerator.ECLIPSE_UI_MENUS_EXTENSION_POINT);
    return CollectionLiterals.<Pair<String, String>>newArrayList(_of, _of_1, _of_2);
  }
  
  public Collection<Pair<String, String>> getRemovableExtensions() {
    Pair<String, String> _of = Pair.<String, String>of(SampleUIGenerator.UI_COMMANDS_PREFIX, SampleUIGenerator.ECLIPSE_UI_COMMANDS_EXTENSION_POINT);
    Pair<String, String> _of_1 = Pair.<String, String>of(SampleUIGenerator.UI_HANDLERS_PREFIX, SampleUIGenerator.ECLIPSE_UI_HANDLERS_EXTENSION_POINT);
    Pair<String, String> _of_2 = Pair.<String, String>of(SampleUIGenerator.UI_MENUS_PREFIX, SampleUIGenerator.ECLIPSE_UI_MENUS_EXTENSION_POINT);
    return CollectionLiterals.<Pair<String, String>>newArrayList(_of, _of_1, _of_2);
  }
  
  public String[] getProjectDependencies() {
    return ((String[])Conversions.unwrapArray(CollectionLiterals.<String>newArrayList(
      "org.eclipse.core.runtime", 
      "org.eclipse.ui", 
      "org.eclipse.emf.ecore", 
      "org.eclipse.pde.core", 
      "org.eclipse.core.resources", 
      "org.eclipse.incquery.runtime", 
      "org.eclipse.incquery.tooling.ui"), String.class));
  }
  
  public String getProjectPostfix() {
    return "ui";
  }
  
  public Iterable<ExtensionData> extensionContribution(final Pattern pattern) {
    ArrayList<ExtensionData> _xblockexpression = null;
    {
      final ExtensionData menuContribution = this.menuContribution(pattern);
      String _commandExtensionId = this.commandExtensionId(pattern);
      final Procedure1<Element> _function = new Procedure1<Element>() {
        public void apply(final Element it) {
          final Procedure1<Element> _function = new Procedure1<Element>() {
            public void apply(final Element it) {
              String _commandId = SampleUIGenerator.this.commandId(pattern);
              SampleUIGenerator.this.exGen.contribAttribute(it, "id", _commandId);
              String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
              String _plus = ("Get All Matches for " + _fullyQualifiedName);
              SampleUIGenerator.this.exGen.contribAttribute(it, "name", _plus);
              SampleUIGenerator.this.exGen.contribAttribute(it, "categoryId", "org.eclipse.incquery.tooling.category");
            }
          };
          SampleUIGenerator.this.exGen.contribElement(it, "command", _function);
        }
      };
      ExtensionData _contribExtension = this.exGen.contribExtension(_commandExtensionId, SampleUIGenerator.ECLIPSE_UI_COMMANDS_EXTENSION_POINT, _function);
      String _handlerExtensionId = this.handlerExtensionId(pattern);
      final Procedure1<Element> _function_1 = new Procedure1<Element>() {
        public void apply(final Element it) {
          final Procedure1<Element> _function = new Procedure1<Element>() {
            public void apply(final Element it) {
              String _commandId = SampleUIGenerator.this.commandId(pattern);
              SampleUIGenerator.this.exGen.contribAttribute(it, "commandId", _commandId);
              String _handlerClassName = SampleUIGenerator.this.handlerClassName(pattern);
              SampleUIGenerator.this.exGen.contribAttribute(it, "class", _handlerClassName);
            }
          };
          SampleUIGenerator.this.exGen.contribElement(it, "handler", _function);
        }
      };
      ExtensionData _contribExtension_1 = this.exGen.contribExtension(_handlerExtensionId, SampleUIGenerator.ECLIPSE_UI_HANDLERS_EXTENSION_POINT, _function_1);
      _xblockexpression = CollectionLiterals.<ExtensionData>newArrayList(_contribExtension, _contribExtension_1, menuContribution);
    }
    return _xblockexpression;
  }
  
  public ExtensionData menuContribution(final Pattern pattern) {
    ExtensionData _xblockexpression = null;
    {
      final String fileExtension = this.handlerFileExtension(pattern);
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(fileExtension);
      if (_isNullOrEmpty) {
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
        String _plus = ("FileExtension must be defined for Handler annotation in pattern: " + _fullyQualifiedName);
        throw new IllegalArgumentException(_plus);
      }
      String _menuExtensionId = this.menuExtensionId(pattern);
      final Procedure1<Element> _function = new Procedure1<Element>() {
        public void apply(final Element it) {
          final Procedure1<Element> _function = new Procedure1<Element>() {
            public void apply(final Element it) {
              SampleUIGenerator.this.exGen.contribAttribute(it, "locationURI", "popup:org.eclipse.ui.popup.any");
              final Procedure1<Element> _function = new Procedure1<Element>() {
                public void apply(final Element it) {
                  SampleUIGenerator.this.exGen.contribAttribute(it, "label", "EMF-IncQuery");
                  final Procedure1<Element> _function = new Procedure1<Element>() {
                    public void apply(final Element it) {
                      String _commandId = SampleUIGenerator.this.commandId(pattern);
                      SampleUIGenerator.this.exGen.contribAttribute(it, "commandId", _commandId);
                      SampleUIGenerator.this.exGen.contribAttribute(it, "style", "push");
                      final Procedure1<Element> _function = new Procedure1<Element>() {
                        public void apply(final Element it) {
                          SampleUIGenerator.this.exGen.contribAttribute(it, "checkEnabled", "false");
                          final Procedure1<Element> _function = new Procedure1<Element>() {
                            public void apply(final Element it) {
                              SampleUIGenerator.this.exGen.contribAttribute(it, "variable", "selection");
                              final Procedure1<Element> _function = new Procedure1<Element>() {
                                public void apply(final Element it) {
                                  SampleUIGenerator.this.exGen.contribAttribute(it, "ifEmpty", "false");
                                  final Procedure1<Element> _function = new Procedure1<Element>() {
                                    public void apply(final Element it) {
                                      SampleUIGenerator.this.exGen.contribAttribute(it, "type", "org.eclipse.core.resources.IFile");
                                      final Procedure1<Element> _function = new Procedure1<Element>() {
                                        public void apply(final Element it) {
                                          SampleUIGenerator.this.exGen.contribAttribute(it, "property", "org.eclipse.core.resources.name");
                                          String _format = String.format("*.%s", fileExtension);
                                          SampleUIGenerator.this.exGen.contribAttribute(it, "value", _format);
                                        }
                                      };
                                      SampleUIGenerator.this.exGen.contribElement(it, "test", _function);
                                    }
                                  };
                                  SampleUIGenerator.this.exGen.contribElement(it, "adapt", _function);
                                }
                              };
                              SampleUIGenerator.this.exGen.contribElement(it, "iterate", _function);
                            }
                          };
                          SampleUIGenerator.this.exGen.contribElement(it, "with", _function);
                        }
                      };
                      SampleUIGenerator.this.exGen.contribElement(it, "visibleWhen", _function);
                    }
                  };
                  SampleUIGenerator.this.exGen.contribElement(it, "command", _function);
                }
              };
              SampleUIGenerator.this.exGen.contribElement(it, "menu", _function);
            }
          };
          SampleUIGenerator.this.exGen.contribElement(it, "menuContribution", _function);
        }
      };
      _xblockexpression = this.exGen.contribExtension(_menuExtensionId, SampleUIGenerator.ECLIPSE_UI_MENUS_EXTENSION_POINT, _function);
    }
    return _xblockexpression;
  }
  
  public String handlerFileExtension(final Pattern pattern) {
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation annotation : _annotations) {
      String _name = annotation.getName();
      boolean _equals = "Handler".equals(_name);
      if (_equals) {
        EList<AnnotationParameter> _parameters = annotation.getParameters();
        for (final AnnotationParameter parameter : _parameters) {
          String _name_1 = parameter.getName();
          boolean _equals_1 = "fileExtension".equals(_name_1);
          if (_equals_1) {
            ValueReference _value = parameter.getValue();
            if ((_value instanceof StringValue)) {
              ValueReference _value_1 = parameter.getValue();
              return ((StringValue) _value_1).getValue();
            }
          }
        }
      }
    }
    return null;
  }
  
  public String handlerClassName(final Pattern pattern) {
    String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
    String _firstUpper = StringExtensions.toFirstUpper(_realPatternName);
    return String.format("%s.handlers.%sHandler", _packageName, _firstUpper);
  }
  
  public String handlerClassPath(final Pattern pattern) {
    String _packagePath = this._eMFPatternLanguageJvmModelInferrerUtil.getPackagePath(pattern);
    String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
    String _firstUpper = StringExtensions.toFirstUpper(_realPatternName);
    return String.format("%s/handlers/%sHandler", _packagePath, _firstUpper);
  }
  
  public String handlerClassJavaFile(final Pattern pattern) {
    String _handlerClassPath = this.handlerClassPath(pattern);
    return (_handlerClassPath + ".java");
  }
  
  public String handlerExtensionId(final Pattern pattern) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    String _plus = (SampleUIGenerator.UI_HANDLERS_PREFIX + _fullyQualifiedName);
    return (_plus + "Handler");
  }
  
  public String commandExtensionId(final Pattern pattern) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    String _plus = (SampleUIGenerator.UI_COMMANDS_PREFIX + _fullyQualifiedName);
    return (_plus + "Command");
  }
  
  public String menuExtensionId(final Pattern pattern) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    String _plus = (SampleUIGenerator.UI_MENUS_PREFIX + _fullyQualifiedName);
    return (_plus + "MenuContribution");
  }
  
  public String commandId(final Pattern pattern) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    return (_fullyQualifiedName + "CommandId");
  }
  
  public CharSequence patternHandler(final Pattern pattern) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    _builder.append(_packageName, "");
    _builder.append(".handlers;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import java.util.Collection;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.core.commands.AbstractHandler;");
    _builder.newLine();
    _builder.append("import org.eclipse.core.commands.ExecutionEvent;");
    _builder.newLine();
    _builder.append("import org.eclipse.core.commands.ExecutionException;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.resource.Resource;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.resource.ResourceSet;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;");
    _builder.newLine();
    _builder.append("import org.eclipse.core.resources.IFile;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.common.notify.Notifier;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.common.util.URI;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.jface.dialogs.MessageDialog;");
    _builder.newLine();
    _builder.append("import org.eclipse.jface.viewers.IStructuredSelection;");
    _builder.newLine();
    _builder.append("import org.eclipse.swt.widgets.Display;");
    _builder.newLine();
    _builder.append("import org.eclipse.ui.handlers.HandlerUtil;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.tooling.ui.dialog.SampleUIDialogCreator;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.runtime.exception.IncQueryException;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.runtime.api.IncQueryEngine;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import ");
    String _packageName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    String _plus = (_packageName_1 + ".");
    String _matcherClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
    String _plus_1 = (_plus + _matcherClassName);
    _builder.append(_plus_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("import ");
    String _packageName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    String _plus_2 = (_packageName_2 + ".");
    String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
    String _plus_3 = (_plus_2 + _matchClassName);
    _builder.append(_plus_3, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _name = pattern.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    String _plus_4 = (_firstUpper + "Handler");
    _builder.append(_plus_4, "");
    _builder.append(" extends AbstractHandler {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Object execute(ExecutionEvent event) throws ExecutionException {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//returns the selected element");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("IStructuredSelection selection = (IStructuredSelection) HandlerUtil.getCurrentSelection(event);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Object firstElement = selection.getFirstElement();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//the filter is set in the command declaration no need for type checking");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("IFile file = (IFile)firstElement;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//Loads the resource");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ResourceSet resourceSet = new ResourceSetImpl();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("URI fileURI = URI.createPlatformResourceURI(file.getFullPath()");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append(".toString(), false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Resource resource = resourceSet.getResource(fileURI, true);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    String _matcherClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
    _builder.append(_matcherClassName_1, "\t\t");
    _builder.append(" matcher;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("try{");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("matcher = ");
    String _matcherClassName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
    _builder.append(_matcherClassName_2, "\t\t\t");
    _builder.append(".querySpecification().getMatcher(resource /* or resourceSet */);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (IncQueryException ex) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new ExecutionException(\"Error creating pattern matcher\", ex);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("SampleUIDialogCreator.createDialog(matcher).open();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public IPath[] getAdditionalBinIncludes() {
    Path _path = new Path("plugin.xml");
    return ((IPath[])Conversions.unwrapArray(CollectionLiterals.<IPath>newArrayList(_path), IPath.class));
  }
}
