package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.OpaqueExpressionResultMatch;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Parameter;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.opaqueExpressionResult pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class OpaqueExpressionResultProcessor implements IMatchProcessor<OpaqueExpressionResultMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final OpaqueExpression pSource, final Parameter pTarget);
  
  @Override
  public void process(final OpaqueExpressionResultMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
