/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewmodel.core;

import java.util.Collection;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewmodel.core.ViewModelRule;
import org.eclipse.incquery.viewmodel.traceability.Traceability;
import org.eclipse.incquery.viewmodel.traceability.TraceabilityFactory;

public class ViewModelManager {
    private static final String TRACEBILITY_RESOURCE = "org.eclipse.incquery.viewmodel.traceability.TraceabilityResource";
    private IncQueryEngine engine;
    private ExecutionSchema executionSchema;
    private Collection<ViewModelRule> rules;
    private Traceability traceability = TraceabilityFactory.eINSTANCE.createTraceability();
    private String traceabilityId = UUID.randomUUID().toString();

    public void initialize() throws IncQueryException, QueryInitializationException, IncQueryBaseException {
        this.prepareBaseNotifier();
        this.traceability.setId(this.traceabilityId);
        this.executionSchema = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)this.engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)this.engine));
        for (ViewModelRule rule : this.rules) {
            rule.initialize(this.traceabilityId);
            rule.getTracedSpecification().getMatcher(this.engine);
            rule.getReferencedSpecification().getMatcher(this.engine);
            rule.getBaseSpecification().getMatcher(this.engine);
            rule.createRuleSpecification(this.executionSchema);
        }
        Logger.getLogger(this.getClass()).info((Object)"View model manager initialized");
        this.executionSchema.startUnscheduledExecution();
        Logger.getLogger(this.getClass()).info((Object)"Unscheduled execution started");
    }

    private void prepareBaseNotifier() throws IncQueryException, IncQueryBaseException {
        Collection<? extends Notifier> notifiers = this.getNotifiers();
        Resource resource = null;
        block0: for (Notifier notifier : notifiers) {
            Resource r;
            if (notifier instanceof Resource && this.checkTraceabilityResource(r = (Resource)notifier)) {
                resource = r;
                break;
            }
            if (!(notifier instanceof ResourceSet)) continue;
            ResourceSet resourceSet = (ResourceSet)notifier;
            for (Resource r2 : resourceSet.getResources()) {
                if (!this.checkTraceabilityResource(r2)) continue;
                resource = r2;
                continue block0;
            }
        }
        if (resource == null) {
            resource = this.addTraceabilityResource();
        }
        resource.getContents().add((Object)this.traceability);
    }

    private boolean checkTraceabilityResource(Resource r) {
        return r.getURI().toString().equals(this.getTraceabilityResourceId());
    }

    public IncQueryEngine getEngine() {
        return this.engine;
    }

    private Resource addTraceabilityResource() throws IncQueryException, IncQueryBaseException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)this.getTraceabilityResourceId()));
        NavigationHelper helper = EMFScope.extractUnderlyingEMFIndex((IncQueryEngine)this.engine);
        helper.addRoot((Notifier)resourceSet);
        return resource;
    }

    public void setEngine(IncQueryEngine engine) {
        if (!(engine.getScope() instanceof EMFScope)) {
            IncQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only EMFScope is supported currently for IncQueryEngine");
            return;
        }
        this.engine = engine;
    }

    private Collection<? extends Notifier> getNotifiers() {
        return ((EMFScope)this.engine.getScope()).getScopeRoots();
    }

    public void setRules(Collection<ViewModelRule> rules) {
        this.rules = rules;
    }

    public Traceability getTraceability() {
        return this.traceability;
    }

    public void dispose() {
        EcoreUtil.delete((EObject)this.traceability);
        this.executionSchema.dispose();
    }

    private String getTraceabilityResourceId() {
        return TRACEBILITY_RESOURCE;
    }
}

