/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.eval;

import java.util.Collection;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.incquery.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.single.SingleInputNode;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;

public class PredicateEvaluatorNode
extends SingleInputNode {
    protected ReteEngine<?> engine;
    protected ReteBoundary<?> boundary;
    protected Integer rhsIndex;
    protected int[] affectedIndices;
    protected Set<Tuple> outgoing;
    protected MemoryNullIndexer memoryNullIndexer;
    protected MemoryIdentityIndexer memoryIdentityIndexer;
    protected AbstractEvaluator evaluator;
    private final int tupleWidth;
    private final TupleMask nullMask;
    private final TupleMask identityMask;

    public PredicateEvaluatorNode(ReteEngine<?> engine, ReteContainer container, Integer rhsIndex, int[] affectedIndices, int tupleWidth, AbstractEvaluator evaluator) {
        super(container);
        this.engine = engine;
        this.boundary = engine.getBoundary();
        this.rhsIndex = rhsIndex;
        this.affectedIndices = affectedIndices;
        this.tupleWidth = tupleWidth;
        this.evaluator = evaluator;
        this.outgoing = CollectionsFactory.getSet();
        this.nullMask = TupleMask.linear(0, tupleWidth);
        this.identityMask = TupleMask.identity(tupleWidth);
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask) {
        if (this.nullMask.equals(mask)) {
            return this.getNullIndexer();
        }
        if (this.identityMask.equals(mask)) {
            return this.getIdentityIndexer();
        }
        return super.constructIndex(mask);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple ps : this.outgoing) {
            collector.add(this.boundary.wrapTuple(ps));
        }
    }

    @Override
    public void update(Direction direction, Tuple wrappers) {
        Tuple updateElement = this.boundary.unwrapTuple(wrappers);
        if (direction == Direction.REVOKE) {
            if (this.outgoing.remove(updateElement)) {
                this.propagateUpdate(Direction.REVOKE, wrappers);
            }
        } else {
            this.check(updateElement);
        }
    }

    protected void check(Tuple ps) {
        boolean result = this.evaluateExpression(ps);
        if (result) {
            if (this.outgoing.add(ps)) {
                this.propagateUpdate(Direction.INSERT, this.boundary.wrapTuple(ps));
            }
        } else if (this.outgoing.remove(ps)) {
            this.propagateUpdate(Direction.REVOKE, this.boundary.wrapTuple(ps));
        }
    }

    protected boolean evaluateExpression(Tuple ps) {
        Object termResult = this.evaluateTerm(ps);
        if (this.rhsIndex != null) {
            Object rightHandSide = ps.get(this.rhsIndex);
            return rightHandSide.equals(termResult);
        }
        if (Boolean.FALSE.equals(termResult)) {
            return false;
        }
        if (Boolean.TRUE.equals(termResult)) {
            return true;
        }
        this.engine.getContext().logWarning(String.format("The incremental pattern matcher encountered a type compatibility problem during check() evaluation for pattern(s) %s over variables %s: expression evaluated to type %s instead of java.lang.Boolean. (Developer note: result was %s in %s)", this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), termResult == null ? null : termResult.getClass().getName(), termResult, this));
        return false;
    }

    public Object evaluateTerm(Tuple ps) {
        Object result = null;
        try {
            result = this.evaluator.evaluate(ps);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            this.engine.getContext().logWarning(String.format("The incremental pattern matcher encountered an error during %s evaluation for pattern(s) %s over values %s. Error message: %s. (Developer note: %s in %s)", this.rhsIndex == null ? "check()" : "eval()", this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), e.getMessage(), e.getClass().getSimpleName(), this), e);
            result = Boolean.FALSE;
        }
        return result;
    }

    protected String prettyPrintTuple(Tuple ps) {
        return ps.toString();
    }

    @Override
    protected void propagateUpdate(Direction direction, Tuple updateElement) {
        super.propagateUpdate(direction, updateElement);
        if (this.memoryIdentityIndexer != null) {
            this.memoryIdentityIndexer.propagate(direction, updateElement);
        }
        if (this.memoryNullIndexer != null) {
            this.memoryNullIndexer.propagate(direction, updateElement);
        }
    }

    public ReteEngine<?> getEngine() {
        return this.engine;
    }

    public MemoryNullIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new MemoryNullIndexer(this.reteContainer, this.tupleWidth, this.outgoing, this, this);
        }
        return this.memoryNullIndexer;
    }

    public MemoryIdentityIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new MemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.outgoing, this, this);
        }
        return this.memoryIdentityIndexer;
    }
}

