/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.patternregistry.views;

import com.google.inject.Inject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.incquery.runtime.patternregistry.IPatternInfo;
import org.eclipse.incquery.runtime.patternregistry.IPatternRegistryListener;
import org.eclipse.incquery.runtime.patternregistry.PatternRegistry;
import org.eclipse.incquery.tooling.ui.patternregistry.views.PatternRegistryTreeContentProvider;
import org.eclipse.incquery.tooling.ui.patternregistry.views.PatternRegistryTreeLabelProvider;
import org.eclipse.incquery.tooling.ui.patternregistry.views.ResourceChangeListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class PatternRegistryViewPart
extends ViewPart {
    private CheckboxTreeViewer checkboxTreeViewer;

    @Inject
    public PatternRegistryViewPart(IResourceSetProvider resourceSetProvider) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(resourceSetProvider), 8);
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.checkboxTreeViewer = new CheckboxTreeViewer(parent);
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new PatternRegistryTreeContentProvider());
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new PatternRegistryTreeLabelProvider());
        this.checkboxTreeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof IPatternInfo) {
                    IPatternInfo patternInfo = (IPatternInfo)element;
                    return patternInfo.isActive();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPatternInfo) {
                    IPatternInfo patternInfo;
                    patternInfo.setActive(!(patternInfo = (IPatternInfo)element).isActive());
                }
            }
        });
        this.checkboxTreeViewer.setInput((Object)"unused_input");
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu(this.checkboxTreeViewer.getControl());
        this.checkboxTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.checkboxTreeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.checkboxTreeViewer);
        this.updateCheckboxTreeViewer();
        PatternRegistry.INSTANCE.registerListener(new IPatternRegistryListener(){

            public void patternRemoved(IPatternInfo patternInfo) {
                PatternRegistryViewPart.this.updateCheckboxTreeViewer();
            }

            public void patternAdded(IPatternInfo patternInfo) {
                PatternRegistryViewPart.this.updateCheckboxTreeViewer();
            }

            public void patternActivated(IPatternInfo patternInfo) {
                PatternRegistryViewPart.this.updateCheckboxTreeViewer();
            }

            public void patternDeactivated(IPatternInfo patternInfo) {
                PatternRegistryViewPart.this.updateCheckboxTreeViewer();
            }
        });
    }

    private void updateCheckboxTreeViewer() {
        Display display = this.checkboxTreeViewer.getTree().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                PatternRegistryViewPart.this.checkboxTreeViewer.refresh();
            }
        });
    }
}

