package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementNamespaceQuerySpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.namedElementNamespace pattern,
 * to be used in conjunction with {@link NamedElementNamespaceMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see NamedElementNamespaceMatcher
 * @see NamedElementNamespaceProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class NamedElementNamespaceMatch extends BasePatternMatch {
  private NamedElement fNamedElement;
  
  private Namespace fNamespace;
  
  private static List<String> parameterNames = makeImmutableList("namedElement", "namespace");
  
  private NamedElementNamespaceMatch(final NamedElement pNamedElement, final Namespace pNamespace) {
    this.fNamedElement = pNamedElement;
    this.fNamespace = pNamespace;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("namedElement".equals(parameterName)) return this.fNamedElement;
    if ("namespace".equals(parameterName)) return this.fNamespace;
    return null;
  }
  
  public NamedElement getNamedElement() {
    return this.fNamedElement;
  }
  
  public Namespace getNamespace() {
    return this.fNamespace;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("namedElement".equals(parameterName) ) {
    	this.fNamedElement = (org.eclipse.uml2.uml.NamedElement) newValue;
    	return true;
    }
    if ("namespace".equals(parameterName) ) {
    	this.fNamespace = (org.eclipse.uml2.uml.Namespace) newValue;
    	return true;
    }
    return false;
  }
  
  public void setNamedElement(final NamedElement pNamedElement) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fNamedElement = pNamedElement;
  }
  
  public void setNamespace(final Namespace pNamespace) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fNamespace = pNamespace;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.namedElementNamespace";
  }
  
  @Override
  public List<String> parameterNames() {
    return NamedElementNamespaceMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fNamedElement, fNamespace};
  }
  
  @Override
  public NamedElementNamespaceMatch toImmutable() {
    return isMutable() ? newMatch(fNamedElement, fNamespace) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"namedElement\"=" + prettyPrintValue(fNamedElement) + ", ");
    
    result.append("\"namespace\"=" + prettyPrintValue(fNamespace)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fNamedElement == null) ? 0 : fNamedElement.hashCode());
    result = prime * result + ((fNamespace == null) ? 0 : fNamespace.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof NamedElementNamespaceMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    NamedElementNamespaceMatch other = (NamedElementNamespaceMatch) obj;
    if (fNamedElement == null) {if (other.fNamedElement != null) return false;}
    else if (!fNamedElement.equals(other.fNamedElement)) return false;
    if (fNamespace == null) {if (other.fNamespace != null) return false;}
    else if (!fNamespace.equals(other.fNamespace)) return false;
    return true;
  }
  
  @Override
  public NamedElementNamespaceQuerySpecification specification() {
    try {
    	return NamedElementNamespaceQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static NamedElementNamespaceMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static NamedElementNamespaceMatch newMutableMatch(final NamedElement pNamedElement, final Namespace pNamespace) {
    return new Mutable(pNamedElement, pNamespace);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pNamedElement the fixed value of pattern parameter namedElement, or null if not bound.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static NamedElementNamespaceMatch newMatch(final NamedElement pNamedElement, final Namespace pNamespace) {
    return new Immutable(pNamedElement, pNamespace);
  }
  
  private static final class Mutable extends NamedElementNamespaceMatch {
    Mutable(final NamedElement pNamedElement, final Namespace pNamespace) {
      super(pNamedElement, pNamespace);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends NamedElementNamespaceMatch {
    Immutable(final NamedElement pNamedElement, final Namespace pNamespace) {
      super(pNamedElement, pNamespace);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
