package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.PackageVisibleMemberMatch;
import org.eclipse.incquery.uml.derivedfeatures.PackageVisibleMemberMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageAllImportedPackagesQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageDirectlyVisibleMemberQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate PackageVisibleMemberMatcher in a type-safe way.
 * 
 * @see PackageVisibleMemberMatcher
 * @see PackageVisibleMemberMatch
 * 
 */
@SuppressWarnings("all")
public final class PackageVisibleMemberQuerySpecification extends BaseGeneratedEMFQuerySpecification<PackageVisibleMemberMatcher> {
  private PackageVisibleMemberQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static PackageVisibleMemberQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected PackageVisibleMemberMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return PackageVisibleMemberMatcher.on(engine);
  }
  
  @Override
  public PackageVisibleMemberMatch newEmptyMatch() {
    return PackageVisibleMemberMatch.newEmptyMatch();
  }
  
  @Override
  public PackageVisibleMemberMatch newMatch(final Object... parameters) {
    return PackageVisibleMemberMatch.newMatch((org.eclipse.uml2.uml.Package) parameters[0], (org.eclipse.uml2.uml.PackageableElement) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static PackageVisibleMemberQuerySpecification INSTANCE = make();
    
    public static PackageVisibleMemberQuerySpecification make() {
      return new PackageVisibleMemberQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static PackageVisibleMemberQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.packageVisibleMember";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("package_","visibleMember");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("package_", "org.eclipse.uml2.uml.Package"),new PParameter("visibleMember", "org.eclipse.uml2.uml.PackageableElement"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_package_ = body.getOrCreateVariableByName("package_");
      	PVariable var_visibleMember = body.getOrCreateVariableByName("visibleMember");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_package_, "package_"),
      				
      		new ExportedParameter(body, var_visibleMember, "visibleMember")
      	));
      	new TypeConstraint(body, new FlatTuple(var_package_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      	new TypeConstraint(body, new FlatTuple(var_visibleMember), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
      	new PositivePatternCall(body, new FlatTuple(var_package_, var_visibleMember), PackageDirectlyVisibleMemberQuerySpecification.instance().getInternalQueryRepresentation());
      	bodies.add(body);
      }
      {
      	PBody body = new PBody(this);
      	PVariable var_package_ = body.getOrCreateVariableByName("package_");
      	PVariable var_visibleMember = body.getOrCreateVariableByName("visibleMember");
      	PVariable var_importedPackage = body.getOrCreateVariableByName("importedPackage");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_package_, "package_"),
      				
      		new ExportedParameter(body, var_visibleMember, "visibleMember")
      	));
      	new TypeConstraint(body, new FlatTuple(var_package_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      	new TypeConstraint(body, new FlatTuple(var_visibleMember), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
      	new PositivePatternCall(body, new FlatTuple(var_package_, var_importedPackage), PackageAllImportedPackagesQuerySpecification.instance().getInternalQueryRepresentation());
      	new PositivePatternCall(body, new FlatTuple(var_importedPackage, var_visibleMember), PackageDirectlyVisibleMemberQuerySpecification.instance().getInternalQueryRepresentation());
      	bodies.add(body);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
