package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.StructuredClassifierRoleMatch;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.StructuredClassifier;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.structuredClassifierRole pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class StructuredClassifierRoleProcessor implements IMatchProcessor<StructuredClassifierRoleMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final StructuredClassifier pSource, final ConnectableElement pTarget);
  
  @Override
  public void process(final StructuredClassifierRoleMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
