/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.emf.helper.IncQueryRuntimeHelper;
import org.eclipse.incquery.validation.runtime.Constraint;
import org.eclipse.incquery.validation.runtime.ConstraintAdapter;

public class MarkerPlacerJob
implements IMatchProcessor<IPatternMatch> {
    private Constraint<IPatternMatch> constraint;
    private Logger logger;
    private ConstraintAdapter adapter;

    public MarkerPlacerJob(ConstraintAdapter adapter, Constraint<IPatternMatch> constraint, Logger logger) {
        this.constraint = constraint;
        this.logger = logger;
        this.adapter = adapter;
    }

    public void process(IPatternMatch match) {
        EObject location = this.constraint.getLocationObject(match);
        if (location != null && location.eResource() != null) {
            IResource markerLoc = this.adapter.getResourceForEditor();
            if (markerLoc == null) {
                URI uri = location.eResource().getURI();
                String platformString = uri.toPlatformString(true);
                if (platformString == null) {
                    this.logger.error((Object)("Marker location for " + location.toString() + " is invalid!"));
                    return;
                }
                markerLoc = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                if (markerLoc == null) {
                    this.logger.error((Object)("Marker location " + platformString + " for " + location + "is not in workspace!"));
                    return;
                }
            }
            try {
                IMarker marker = markerLoc.createMarker("org.eclipse.emf.ecore.diagnostic");
                marker.setAttribute("severity", this.constraint.getSeverity());
                marker.setAttribute("transient", true);
                String locationString = String.format("%1$s %2$s", location.eClass().getName(), BasePatternMatch.prettyPrintValue((Object)location));
                marker.setAttribute("location", (Object)locationString);
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)location).toString());
                marker.setAttribute("message", (Object)IncQueryRuntimeHelper.getMessage((IPatternMatch)match, (String)this.constraint.getMessage()));
                this.adapter.addMarker(match, marker);
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error during marker initialization!", (Throwable)e);
            }
        }
    }
}

