/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import com.google.common.base.Preconditions;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.incquery.viewers.runtime.model.FormatSpecification;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.converters.FormatParser;

public class ItemConverter
implements IConverter {
    private String parameterName;
    private String labelParameterName;
    private Item.HierarchyPolicy policy;
    private FormatSpecification format;

    public ItemConverter(PAnnotation itemAnnotation, PAnnotation formatAnnotation) {
        Preconditions.checkArgument((boolean)"Item".equals(itemAnnotation.getName()), (Object)"The converter should be initialized using a Item annotation.");
        this.parameterName = ((ParameterReference)itemAnnotation.getFirstValue("item")).getName();
        Object labelParam = itemAnnotation.getFirstValue("label");
        this.labelParameterName = labelParam == null ? "" : (String)labelParam;
        Object hierarchyParam = itemAnnotation.getFirstValue("hierarchy");
        Item.HierarchyPolicy hierarchyPolicy = this.policy = hierarchyParam == null ? Item.HierarchyPolicy.ALWAYS : Item.HierarchyPolicy.valueOf(((String)hierarchyParam).toUpperCase());
        if (formatAnnotation != null) {
            this.format = FormatParser.parseFormatAnnotation(formatAnnotation);
        }
    }

    public Object getToType() {
        return Item.class;
    }

    public Object getFromType() {
        return IPatternMatch.class;
    }

    public Object convert(Object fromObject) {
        IPatternMatch match = (IPatternMatch)fromObject;
        Object param = match.get(this.parameterName);
        Item item = new Item(match, param, this.labelParameterName, this.policy);
        item.setSpecification(this.format);
        return item;
    }
}

