/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.querybasedfeatures.runtime.IQueryBasedFeatureHandler;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeature;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureHandler;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.querybasedfeatures.runtime.handler.QueryBasedFeatures;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public final class QueryBasedFeatureHelper {
    private static final Map<Notifier, Map<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>>> FEATURE_MAP = new WeakHashMap<Notifier, Map<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>>>();

    private QueryBasedFeatureHelper() {
    }

    public static Notifier prepareNotifierForSource(EObject source) {
        if (source != null) {
            Resource eResource = source.eResource();
            if (eResource != null) {
                ResourceSet resourceSet = eResource.getResourceSet();
                if (resourceSet != null) {
                    return resourceSet;
                }
                return eResource;
            }
            EObject top = source;
            while (top.eContainer() != null) {
                top = top.eContainer();
            }
            if (!top.equals(source)) {
                return QueryBasedFeatureHelper.prepareNotifierForSource(top);
            }
        }
        return source;
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandler(Notifier notifier, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind, boolean keepCache) {
        WeakReference<IQueryBasedFeatureHandler> weakReference;
        IQueryBasedFeatureHandler derivedFeature;
        Map<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>> features = FEATURE_MAP.get(notifier);
        if (features == null) {
            features = new HashMap<EStructuralFeature, WeakReference<IQueryBasedFeatureHandler>>();
            FEATURE_MAP.put(notifier, features);
        }
        IQueryBasedFeatureHandler iQueryBasedFeatureHandler = derivedFeature = (weakReference = features.get(feature)) == null ? null : (IQueryBasedFeatureHandler)weakReference.get();
        if (derivedFeature != null) {
            return derivedFeature;
        }
        QueryBasedFeature newFeature = QueryBasedFeatureHelper.createQueryBasedFeature(feature, kind, keepCache);
        if (newFeature == null) {
            IncQueryLoggingUtil.getLogger(QueryBasedFeatureHelper.class).error((Object)("Handler initialization failed, feature kind " + (Object)((Object)kind) + " not supported!"));
            return null;
        }
        QueryBasedFeatureHandler queryBasedFeatureHandler = new QueryBasedFeatureHandler(newFeature);
        features.put(feature, new WeakReference<QueryBasedFeatureHandler>(queryBasedFeatureHandler));
        IQuerySpecification querySpecification = QuerySpecificationRegistry.getQuerySpecification((String)patternFQN);
        if (querySpecification != null) {
            try {
                IncQueryMatcher matcher = querySpecification.getMatcher(IncQueryEngine.on((Notifier)notifier));
                newFeature.initialize((IncQueryMatcher<IPatternMatch>)matcher, sourceParamName, targetParamName);
                newFeature.startMonitoring();
            }
            catch (IncQueryException e) {
                IncQueryLoggingUtil.getLogger(QueryBasedFeatureHelper.class).error((Object)"Handler initialization failed", (Throwable)e);
                return null;
            }
        } else {
            IncQueryLoggingUtil.getLogger(QueryBasedFeatureHelper.class).error((Object)String.format("Handler initialization failed, query specification is null for %s. Make sure to include your EMF-IncQuery project with the query definitions in the configuration.", patternFQN));
        }
        return queryBasedFeatureHandler;
    }

    private static QueryBasedFeature createQueryBasedFeature(EStructuralFeature feature, QueryBasedFeatureKind kind, boolean keepCache) {
        QueryBasedFeature newFeature = null;
        switch (kind) {
            case SINGLE_REFERENCE: {
                newFeature = QueryBasedFeatures.newSingleValueFeature(feature, keepCache);
                break;
            }
            case MANY_REFERENCE: {
                newFeature = QueryBasedFeatures.newMultiValueFeatue(feature, keepCache);
                break;
            }
            case SUM: {
                newFeature = QueryBasedFeatures.newSumFeature(feature);
                break;
            }
        }
        return newFeature;
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandlerOnNotifier(Notifier notifier, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind) {
        return QueryBasedFeatureHelper.getQueryBasedFeatureHandler(notifier, feature, patternFQN, sourceParamName, targetParamName, kind, true);
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandler(EObject source, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind, boolean keepCache, boolean useSourceAsNotifier) {
        EObject notifier = source;
        if (!useSourceAsNotifier) {
            notifier = QueryBasedFeatureHelper.prepareNotifierForSource(source);
        }
        return QueryBasedFeatureHelper.getQueryBasedFeatureHandler((Notifier)notifier, feature, patternFQN, sourceParamName, targetParamName, kind, keepCache);
    }

    public static IQueryBasedFeatureHandler getQueryBasedFeatureHandler(EObject source, EStructuralFeature feature, String patternFQN, String sourceParamName, String targetParamName, QueryBasedFeatureKind kind) {
        return QueryBasedFeatureHelper.getQueryBasedFeatureHandler(source, feature, patternFQN, sourceParamName, targetParamName, kind, true, false);
    }
}

